/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen.docs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.Document;
import io.ballerina.projects.ModuleReadmeMd;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageReadmeMd;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.bala.BalaProject;
import io.ballerina.projects.util.ProjectUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.FileUtils;
import org.ballerinalang.docgen.Generator;
import org.ballerinalang.docgen.docs.utils.BallerinaDocUtils;
import org.ballerinalang.docgen.docs.utils.PathToJson;
import org.ballerinalang.docgen.generator.model.ApiDocsJson;
import org.ballerinalang.docgen.generator.model.CentralStdLibrary;
import org.ballerinalang.docgen.generator.model.Module;
import org.ballerinalang.docgen.generator.model.ModuleDoc;
import org.ballerinalang.docgen.generator.model.ModuleLibrary;
import org.ballerinalang.docgen.generator.model.ModuleMetaData;
import org.ballerinalang.docgen.generator.model.search.ConstructSearchJson;
import org.ballerinalang.docgen.generator.model.search.ModuleSearchJson;
import org.ballerinalang.docgen.generator.model.search.SearchJson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.util.RepoUtils;

public final class BallerinaDocGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(BallerinaDocGenerator.class);
    private static PrintStream out = System.out;
    public static final String API_DOCS_JSON = "api-docs.json";
    private static final String API_DOCS_JS = "api-docs.js";
    private static final String CENTRAL_STDLIB_INDEX_JSON = "stdlib-index.json";
    private static final String CENTRAL_STDLIB_SEARCH_JSON = "stdlib-search.json";
    private static final String BALLERINA_DOC_UI_ZIP_FILE_NAME = "ballerina-doc-ui.zip";
    private static final String CONTENT_TYPE = "application/json";
    private static final String DOCS_FOLDER_NAME = "docs";
    private static final String ICON_NAME = "icon.png";
    private static final String JSON_KEY_HASH_VALUE = "hashValue";
    private static final String JSON_KEY_FILE_URL = "fileURL";
    private static final String RELEASE_DESCRIPTION_MD = "/release-description.md";
    private static final String SHA256_ALGORITHM = "SHA-256";
    private static final String SHA256_HASH_FILE_NAME = "ballerina-doc-ui-hash.sha256";
    private static final String PROPERTIES_FILE = "/META-INF/properties";
    private static final String CENTRAL_REGISTRY_PATH = "/registry";
    private static final String CENTRAL_DOC_UI_PATH = "/docs/doc-ui";
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(Path.class, (Object)new PathToJson()).excludeFieldsWithoutExposeAnnotation().create();

    private BallerinaDocGenerator() {
    }

    public static void mergeApiDocs(Path apiDocsRoot) {
        out.println("docerina: API documentation generation for doc path - " + String.valueOf(apiDocsRoot));
        File directory = apiDocsRoot.toFile();
        Object[] orgFileList = directory.listFiles();
        if (orgFileList == null) {
            LOG.error(String.format("docerina: API documentation generation failed. Could not find any packages in given path %s", apiDocsRoot));
            return;
        }
        Arrays.sort(orgFileList);
        ModuleLibrary moduleLib = new ModuleLibrary();
        CentralStdLibrary centralLib = new CentralStdLibrary();
        moduleLib.releaseVersion = BallerinaDocGenerator.getBallerinaShortVersion().replace("sl", "swan-lake-");
        centralLib.releaseVersion = BallerinaDocGenerator.getBallerinaShortVersion().replace("sl", "swan-lake-");
        centralLib.releaseShortVersion = BallerinaDocGenerator.getBallerinaShortVersion();
        centralLib.description = BallerinaDocGenerator.getReleaseDescription();
        for (Object orgFile : orgFileList) {
            if (!((File)orgFile).isDirectory()) continue;
            Object[] moduleFileList = ((File)orgFile).listFiles();
            Arrays.sort(moduleFileList);
            for (Object moduleFile : moduleFileList) {
                File versionFile;
                Path docJsonPath;
                if (!((File)moduleFile).isDirectory() || ((File)moduleFile).listFiles().length <= 0 || !((File)moduleFile).listFiles()[0].isDirectory() || !(docJsonPath = Path.of((versionFile = ((File)moduleFile).listFiles()[0]).getAbsolutePath(), API_DOCS_JSON)).toFile().exists()) continue;
                try (BufferedReader br = Files.newBufferedReader(docJsonPath, StandardCharsets.UTF_8);){
                    ApiDocsJson apiDocsJson = (ApiDocsJson)GSON.fromJson((Reader)br, ApiDocsJson.class);
                    if (apiDocsJson.docsData.modules.isEmpty()) {
                        LOG.warn("No packages found at: " + docJsonPath.toString());
                        continue;
                    }
                    apiDocsJson.docsData.modules.forEach(arg_0 -> BallerinaDocGenerator.lambda$mergeApiDocs$0((File)orgFile, arg_0));
                    for (Module module : apiDocsJson.docsData.modules) {
                        ModuleMetaData moduleMeta = new ModuleMetaData();
                        moduleMeta.id = module.id;
                        moduleMeta.summary = module.summary;
                        moduleMeta.orgName = module.orgName;
                        moduleMeta.version = module.version;
                        moduleMeta.isDefaultModule = module.isDefaultModule;
                        if (module.id.startsWith("lang.")) {
                            centralLib.langLibs.add(moduleMeta);
                            moduleLib.langLibs.add(module);
                            continue;
                        }
                        centralLib.modules.add(moduleMeta);
                        moduleLib.modules.add(module);
                    }
                }
                catch (IOException e) {
                    LOG.error(String.format("API documentation generation failed. Cause: %s", e.getMessage()), (Throwable)e);
                    return;
                }
            }
        }
        moduleLib.modules.sort((o1, o2) -> o1.id.compareToIgnoreCase(o2.id));
        centralLib.modules.sort((o1, o2) -> o1.id.compareToIgnoreCase(o2.id));
        BallerinaDocGenerator.writeAPIDocs(moduleLib, apiDocsRoot, true, false);
        String stdIndexJson = GSON.toJson((Object)centralLib);
        File stdIndexJsonFile = apiDocsRoot.resolve(CENTRAL_STDLIB_INDEX_JSON).toFile();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(stdIndexJsonFile), StandardCharsets.UTF_8);){
            writer.write(new String(stdIndexJson.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOG.error("Failed to create {} file.", (Object)CENTRAL_STDLIB_INDEX_JSON, (Object)e);
        }
        String stdSearchJson = GSON.toJson((Object)BallerinaDocGenerator.genSearchJson(moduleLib));
        File stdSearchJsonFile = apiDocsRoot.resolve(CENTRAL_STDLIB_SEARCH_JSON).toFile();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(stdSearchJsonFile), StandardCharsets.UTF_8);){
            writer.write(new String(stdSearchJson.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOG.error("Failed to create {} file.", (Object)CENTRAL_STDLIB_SEARCH_JSON, (Object)e);
        }
    }

    public static void generateAPIDocs(Project project, String output, boolean excludeUI) throws IOException {
        Map<String, ModuleDoc> moduleDocMap = BallerinaDocGenerator.generateModuleDocMap(project);
        ModuleLibrary moduleLib = new ModuleLibrary();
        moduleLib.modules = BallerinaDocGenerator.getDocsGenModel(moduleDocMap, project.currentPackage().packageOrg().toString(), project.currentPackage().packageVersion().toString());
        BallerinaDocGenerator.writeAPIDocs(moduleLib, Path.of(output, new String[0]), false, excludeUI);
        BallerinaDocGenerator.copyIcon(project, Path.of(output, new String[0]), moduleLib);
    }

    public static void copyIcon(Project project, Path output, ModuleLibrary moduleLib) {
        String sourceLocation = project.currentPackage().manifest().icon();
        if (!sourceLocation.isEmpty()) {
            output = output.resolve(moduleLib.modules.get((int)0).orgName).resolve(moduleLib.modules.get((int)0).id).resolve(moduleLib.modules.get((int)0).version).resolve(ICON_NAME);
            Path iconPath = Path.of(sourceLocation, new String[0]);
            try {
                byte[] iconByteArray = Files.readAllBytes(iconPath);
                Files.write(output, iconByteArray, new OpenOption[0]);
            }
            catch (IOException e) {
                LOG.error("Failed to copy icon to the API docs.", (Throwable)e);
            }
        }
    }

    private static void writeAPIDocs(ModuleLibrary moduleLib, Path output, boolean isMerge, boolean excludeUI) {
        if (moduleLib.modules.isEmpty()) {
            LOG.error("No modules found to create docs.");
            return;
        }
        if (!isMerge && excludeUI) {
            for (Module module : moduleLib.modules) {
                ModuleLibrary tempLib = new ModuleLibrary();
                tempLib.modules.add(module);
                Path outputPath = output.resolve(module.orgName).resolve(module.id).resolve(module.version);
                BallerinaDocGenerator.genApiDocsJson(tempLib, outputPath, true);
                BallerinaDocGenerator.copyResources(module.resources, outputPath);
            }
            return;
        }
        if (!isMerge) {
            output = output.resolve(moduleLib.modules.get((int)0).orgName).resolve(moduleLib.modules.get((int)0).id).resolve(moduleLib.modules.get((int)0).version);
        }
        BallerinaDocGenerator.genApiDocsJson(moduleLib, output, false);
        for (Module module : moduleLib.modules) {
            BallerinaDocGenerator.copyResources(module.resources, output);
        }
        BallerinaDocGenerator.copyDocerinaUI(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyDocerinaUI(Path output) {
        String source = RepoUtils.getRemoteRepoURL();
        source = source.replace(CENTRAL_REGISTRY_PATH, CENTRAL_DOC_UI_PATH);
        Path docsDirPath = ProjectUtils.createAndGetHomeReposPath().resolve(DOCS_FOLDER_NAME);
        Path sha256FilePath = docsDirPath.resolve(SHA256_HASH_FILE_NAME);
        Path zipFilePath = docsDirPath.resolve(BALLERINA_DOC_UI_ZIP_FILE_NAME);
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().get().url(source).build();
        try (Response response = client.newCall(request).execute();){
            if (response.code() != 200 || response.body() == null || !Objects.equals(response.header("content-type"), CONTENT_TYPE)) {
                throw new IOException("Response failed with status code: " + response.code());
            }
            ResponseBody responseBody = response.body();
            JsonObject jsonResponse = JsonParser.parseReader((Reader)responseBody.charStream()).getAsJsonObject();
            String sha256HashValue = jsonResponse.get(JSON_KEY_HASH_VALUE).getAsString();
            String zipFileURL = jsonResponse.get(JSON_KEY_FILE_URL).getAsString();
            if (!Files.exists(sha256FilePath, new LinkOption[0]) || !Files.exists(zipFilePath, new LinkOption[0])) {
                if (!docsDirPath.toFile().exists()) {
                    Files.createDirectories(docsDirPath, new FileAttribute[0]);
                }
                BallerinaDocGenerator.writeFileInCache(zipFileURL, sha256HashValue, zipFilePath, sha256FilePath);
            } else {
                String hashValueInCache = Files.readString(sha256FilePath).trim();
                if (!sha256HashValue.equals(hashValueInCache)) {
                    BallerinaDocGenerator.writeFileInCache(zipFileURL, sha256HashValue, zipFilePath, sha256FilePath);
                }
            }
            BallerinaDocGenerator.copyDocUIToProjectDir(output, zipFilePath);
        }
        catch (IOException e) {
            if (Files.exists(zipFilePath, new LinkOption[0])) {
                String warning = "WARNING: Unable to fetch the latest UI from the central.\nThis document is built using an existing version of the UI.\n";
                out.println(warning);
                BallerinaDocGenerator.copyDocUIToProjectDir(output, zipFilePath);
            } else {
                File sourceDir = Path.of(System.getProperty("ballerina.home"), "lib", "tools", "doc-ui").toFile();
                if (sourceDir.exists()) {
                    try {
                        FileUtils.copyDirectory((File)sourceDir, (File)output.toFile());
                    }
                    catch (IOException ex) {
                        LOG.error("Failed to copy the API doc UI", (Throwable)ex);
                    }
                } else {
                    try {
                        FileUtils.copyInputStreamToFile((InputStream)BallerinaDocGenerator.class.getResourceAsStream("/doc-ui/index.html"), (File)output.resolve("index.html").toFile());
                    }
                    catch (IOException ex) {
                        LOG.error("Failed to copy the API doc UI", (Throwable)ex);
                    }
                }
            }
        }
        finally {
            client.dispatcher().executorService().shutdown();
            client.connectionPool().evictAll();
        }
    }

    private static void writeFileInCache(String fileURL, String hashValue, Path zipFilePath, Path hashFilePath) throws IOException {
        block8: {
            OkHttpClient client = new OkHttpClient();
            Request request = new Request.Builder().get().url(fileURL).build();
            try (Response response = client.newCall(request).execute();){
                if (response.code() == 200 && response.body() != null) {
                    ResponseBody responseBody = response.body();
                    byte[] contentInBytes = responseBody.bytes();
                    byte[] hash = BallerinaDocUtils.getHash(contentInBytes, SHA256_ALGORITHM);
                    String checksum = BallerinaDocUtils.bytesToHex(hash);
                    if (checksum.equals(hashValue)) {
                        Files.write(zipFilePath, contentInBytes, new OpenOption[0]);
                        Files.write(hashFilePath, hashValue.getBytes(), new OpenOption[0]);
                        break block8;
                    }
                    throw new IOException("Failed to fetch API docs UI. UI Components may have been corrupted.");
                }
                throw new IOException("Failed to fetch API docs UI. Request failed.");
            }
        }
    }

    private static void copyDocUIToProjectDir(Path output, Path zipFilePath) {
        try (FileInputStream inputStream = new FileInputStream(zipFilePath.toFile());){
            ZipEntry entry;
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream));
            while ((entry = zipInputStream.getNextEntry()) != null) {
                Path docUIFilePath = output.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(docUIFilePath, new FileAttribute[0]);
                    continue;
                }
                try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(docUIFilePath.toFile()));){
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = zipInputStream.read(buffer)) > 0) {
                        ((OutputStream)outputStream).write(buffer, 0, length);
                    }
                }
                catch (IOException e) {
                    LOG.error("Unable to write to the file", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Error occurred when unzipping file", (Throwable)e);
        }
    }

    private static void copyResources(List<Path> resources, Path output) {
        if (!resources.isEmpty()) {
            File resourcesDirFile = output.resolve("resources").toFile();
            if (BallerinaDocUtils.isDebugEnabled()) {
                out.println("docerina: copying project resources ");
            }
            for (Path resourcePath : resources) {
                try {
                    FileUtils.copyFileToDirectory((File)resourcePath.toFile(), (File)resourcesDirFile);
                }
                catch (IOException e) {
                    LOG.error(String.format("docerina: failed to copy [resource] %s into [resources directory] %s. Cause: %s", resourcePath.toString(), resourcesDirFile.toString(), e.getMessage()), (Throwable)e);
                }
            }
            if (BallerinaDocUtils.isDebugEnabled()) {
                out.println("docerina: successfully copied project resources into " + String.valueOf(resourcesDirFile));
            }
        }
    }

    private static String getApiDocsVersion() {
        String string;
        block8: {
            String apiDocsVersion = "";
            InputStream inputStream = BallerinaDocGenerator.class.getResourceAsStream("/META-INF/tool.properties");
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                string = apiDocsVersion = properties.getProperty("apiDocs.version").split("-")[0];
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return "NOT_FOUND";
                }
            }
            inputStream.close();
        }
        return string;
    }

    private static void genApiDocsJson(ModuleLibrary moduleLib, Path destination, boolean excludeUI) {
        OutputStreamWriter writer;
        try {
            Files.createDirectories(destination, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.error("API documentation generation failed when creating directory:", (Throwable)e);
        }
        ApiDocsJson apiDocsJson = new ApiDocsJson();
        apiDocsJson.apiDocsVersion = BallerinaDocGenerator.getApiDocsVersion();
        apiDocsJson.docsData = moduleLib;
        apiDocsJson.searchData = BallerinaDocGenerator.genSearchJson(moduleLib);
        File jsFile = destination.resolve(API_DOCS_JS).toFile();
        File jsonFile = destination.resolve(API_DOCS_JSON).toFile();
        if (jsFile.exists() && !jsFile.delete()) {
            LOG.error("docerina: failed to delete {}", (Object)jsFile.toString());
        }
        if (jsonFile.exists() && !jsonFile.delete()) {
            LOG.error("docerina: failed to delete {}", (Object)jsonFile.toString());
        }
        String json = GSON.toJson((Object)apiDocsJson);
        if (!excludeUI) {
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(jsFile), StandardCharsets.UTF_8);
                try {
                    String js = "var apiDocsJson = " + json + ";";
                    writer.write(new String(js.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
                }
                finally {
                    ((Writer)writer).close();
                }
            }
            catch (IOException e) {
                LOG.error("Failed to create {} file.", (Object)API_DOCS_JS, (Object)e);
            }
        }
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), StandardCharsets.UTF_8);
            try {
                writer.write(new String(json.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (IOException e) {
            LOG.error("Failed to create {} file.", (Object)API_DOCS_JSON, (Object)e);
        }
    }

    private static SearchJson genSearchJson(ModuleLibrary moduleLib) {
        ArrayList<ModuleSearchJson> searchModules = new ArrayList<ModuleSearchJson>();
        ArrayList<ConstructSearchJson> searchFunctions = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchClasses = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchRecords = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchConstants = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchErrors = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchTypes = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchClients = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchListeners = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchAnnotations = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchObjectTypes = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchEnums = new ArrayList<ConstructSearchJson>();
        ArrayList<Module> allModules = new ArrayList<Module>();
        allModules.addAll(moduleLib.langLibs);
        allModules.addAll(moduleLib.modules);
        allModules.sort((o1, o2) -> o1.id.compareToIgnoreCase(o2.id));
        for (Module module : allModules) {
            if (module.summary != null) {
                searchModules.add(new ModuleSearchJson(module.id, module.orgName, module.version, module.summary, module.isDefaultModule));
            }
            module.functions.forEach(function -> searchFunctions.add(new ConstructSearchJson(function.name, module.id, module.orgName, module.version, function.description)));
            module.classes.forEach(bClass -> searchClasses.add(new ConstructSearchJson(bClass.name, module.id, module.orgName, module.version, bClass.description)));
            module.objectTypes.forEach(absObj -> searchObjectTypes.add(new ConstructSearchJson(absObj.name, module.id, module.orgName, module.version, absObj.description)));
            module.clients.forEach(client -> searchClients.add(new ConstructSearchJson(client.name, module.id, module.orgName, module.version, client.description)));
            module.listeners.forEach(listener -> searchListeners.add(new ConstructSearchJson(listener.name, module.id, module.orgName, module.version, listener.description)));
            module.records.forEach(record -> searchRecords.add(new ConstructSearchJson(record.name, module.id, module.orgName, module.version, record.description)));
            module.constants.forEach(constant -> searchConstants.add(new ConstructSearchJson(constant.name, module.id, module.orgName, module.version, constant.description)));
            module.errors.forEach(error -> searchErrors.add(new ConstructSearchJson(error.name, module.id, module.orgName, module.version, error.description)));
            module.types.forEach(unionType -> searchTypes.add(new ConstructSearchJson(unionType.name, module.id, module.orgName, module.version, unionType.description)));
            module.annotations.forEach(annotation -> searchAnnotations.add(new ConstructSearchJson(annotation.name, module.id, module.orgName, module.version, annotation.description)));
            module.enums.forEach(benum -> searchEnums.add(new ConstructSearchJson(benum.name, module.id, module.orgName, module.version, benum.description)));
        }
        return new SearchJson(searchModules, searchClasses, searchFunctions, searchRecords, searchConstants, searchErrors, searchTypes, searchClients, searchListeners, searchAnnotations, searchObjectTypes, searchEnums);
    }

    public static Map<String, ModuleDoc> generateModuleDocMap(Project project) throws IOException {
        HashMap<String, PackageManifest.Module> modulesMap = new HashMap<String, PackageManifest.Module>();
        if (project.currentPackage().manifest().modules() != null) {
            for (PackageManifest.Module module : project.currentPackage().manifest().modules()) {
                modulesMap.put(module.name(), module);
            }
        }
        HashMap<String, ModuleDoc> moduleDocMap = new HashMap<String, ModuleDoc>();
        for (io.ballerina.projects.Module module : project.currentPackage().modules()) {
            String moduleMdText;
            Path modulePath;
            String moduleName;
            String summary = null;
            if (module.isDefaultModule()) {
                moduleName = module.moduleName().packageName().toString();
                modulePath = project.sourceRoot();
                moduleMdText = project.kind() == ProjectKind.BALA_PROJECT && "2.0.0".equals(((BalaProject)project).balaVersion()) ? module.readmeMd().map(ModuleReadmeMd::content).orElse("") : project.currentPackage().readmeMd().map(PackageReadmeMd::content).orElse("");
                summary = project.currentPackage().manifest().description();
            } else {
                moduleName = module.moduleName().toString();
                modulePath = project.sourceRoot().resolve("modules").resolve(module.moduleName().moduleNamePart());
                moduleMdText = module.readmeMd().map(ModuleReadmeMd::content).orElse("");
                if (modulesMap.containsKey(module.moduleName().toString())) {
                    summary = ((PackageManifest.Module)modulesMap.get(module.moduleName().toString())).description();
                }
            }
            if (!project.currentPackage().manifest().exportedModules().contains(moduleName)) continue;
            List<Path> resources = BallerinaDocGenerator.getResourcePaths(modulePath);
            HashMap<String, SyntaxTree> syntaxTreeMap = new HashMap<String, SyntaxTree>();
            module.documentIds().forEach(documentId -> {
                Document document = module.document(documentId);
                syntaxTreeMap.put(document.name(), document.syntaxTree());
            });
            ModuleDoc moduleDoc = new ModuleDoc(moduleMdText, summary, resources, syntaxTreeMap, module.getCompilation().getSemanticModel(), module.isDefaultModule());
            moduleDocMap.put(moduleName, moduleDoc);
        }
        return moduleDocMap;
    }

    public static String getBallerinaShortVersion() {
        String string;
        block8: {
            InputStream inputStream = BallerinaDocGenerator.class.getResourceAsStream(PROPERTIES_FILE);
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                string = properties.getProperty("ballerina.version");
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    return "unknown";
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static String getReleaseDescription() {
        String string;
        block8: {
            InputStream inputStream = BallerinaDocGenerator.class.getResourceAsStream(RELEASE_DESCRIPTION_MD);
            try {
                String desc;
                string = desc = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    return "";
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static void setPrintStream(PrintStream out) {
        BallerinaDocGenerator.out = out;
    }

    public static List<Module> getDocsGenModel(Map<String, ModuleDoc> docsMap, String orgName, String version) {
        ArrayList<Module> moduleDocs = new ArrayList<Module>();
        ArrayList<ModuleMetaData> relatedModules = new ArrayList<ModuleMetaData>();
        for (Map.Entry<String, ModuleDoc> moduleDoc : docsMap.entrySet()) {
            SemanticModel model = moduleDoc.getValue().semanticModel;
            Module module3 = new Module();
            module3.id = moduleDoc.getKey();
            module3.orgName = orgName;
            String moduleVersion = version;
            module3.version = moduleVersion.isEmpty() ? System.getProperty("version") : moduleVersion;
            module3.summary = moduleDoc.getValue().summary;
            module3.description = moduleDoc.getValue().description;
            module3.isDefaultModule = moduleDoc.getValue().isDefault;
            module3.resources.addAll(moduleDoc.getValue().resources);
            for (Map.Entry<String, SyntaxTree> syntaxTreeMapEntry : moduleDoc.getValue().syntaxTreeMap.entrySet()) {
                Generator.setModuleFromSyntaxTree(module3, syntaxTreeMapEntry.getValue(), model);
            }
            module3.records.sort((o1, o2) -> o1.name.compareToIgnoreCase(o2.name));
            module3.functions.sort((o1, o2) -> o1.name.compareToIgnoreCase(o2.name));
            module3.classes.sort((o1, o2) -> o1.name.compareToIgnoreCase(o2.name));
            module3.clients.sort((o1, o2) -> o1.name.compareToIgnoreCase(o2.name));
            module3.listeners.sort((o1, o2) -> o1.name.compareToIgnoreCase(o2.name));
            module3.objectTypes.sort((o1, o2) -> o1.name.compareToIgnoreCase(o2.name));
            module3.enums.sort((o1, o2) -> o1.name.compareToIgnoreCase(o2.name));
            module3.types.sort((o1, o2) -> o1.name.compareToIgnoreCase(o2.name));
            module3.constants.sort((o1, o2) -> o1.name.compareToIgnoreCase(o2.name));
            module3.annotations.sort((o1, o2) -> o1.name.compareToIgnoreCase(o2.name));
            module3.errors.sort((o1, o2) -> o1.name.compareToIgnoreCase(o2.name));
            moduleDocs.add(module3);
            ModuleMetaData moduleMeta = new ModuleMetaData();
            moduleMeta.id = module3.id;
            moduleMeta.orgName = module3.orgName;
            moduleMeta.summary = module3.summary;
            moduleMeta.version = module3.version;
            moduleMeta.isDefaultModule = module3.isDefaultModule;
            relatedModules.add(moduleMeta);
        }
        moduleDocs.sort((module1, module2) -> module1.id.compareToIgnoreCase(module2.id));
        if (relatedModules.size() > 1) {
            relatedModules.sort((mod1, mod2) -> mod1.id.compareToIgnoreCase(mod2.id));
            moduleDocs.forEach(module -> {
                module.relatedModules = relatedModules;
            });
        }
        return moduleDocs;
    }

    private static List<Path> getResourcePaths(Path absolutePkgPath) throws IOException {
        Path resourcesDirPath = absolutePkgPath.resolve("resources");
        List<Path> resources = new ArrayList<Path>();
        if (resourcesDirPath.toFile().exists()) {
            try (Stream<Path> paths = Files.walk(resourcesDirPath, new FileVisitOption[0]);){
                resources = paths.filter(path -> !path.equals(resourcesDirPath)).toList();
            }
        }
        return resources;
    }

    private static /* synthetic */ void lambda$mergeApiDocs$0(File orgFile, Module mod) {
        try {
            mod.resources.addAll(BallerinaDocGenerator.getResourcePaths(Path.of(orgFile.getAbsolutePath(), new String[0])));
        }
        catch (IOException e) {
            LOG.error(String.format("API documentation generation failed. Cause: %s", e.getMessage()), (Throwable)e);
            return;
        }
    }
}

