/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.avro;

import io.ballerina.lib.avro.Utils;
import io.ballerina.lib.avro.deserialize.DeserializeFactory;
import io.ballerina.lib.avro.deserialize.Deserializer;
import io.ballerina.lib.avro.deserialize.visitor.DeserializeVisitor;
import io.ballerina.lib.avro.serialize.MessageFactory;
import io.ballerina.lib.avro.serialize.Serializer;
import io.ballerina.lib.avro.serialize.visitor.SerializeVisitor;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;

public final class Avro {
    private Avro() {
    }

    public static void generateSchema(BObject schemaObject, BString schema) {
        Schema.Parser parser = new Schema.Parser();
        Schema nativeSchema = parser.parse(schema.getValue());
        schemaObject.addNativeData("avroSchema", (Object)nativeSchema);
    }

    public static Object toAvro(BObject schemaObject, Object data) {
        BArray bArray;
        Schema schema = (Schema)schemaObject.getNativeData("avroSchema");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            SerializeVisitor serializeVisitor = new SerializeVisitor();
            Serializer serializer = MessageFactory.createMessage(schema);
            Object avroData = Objects.requireNonNull(serializer).convert(serializeVisitor, data);
            GenericDatumWriter writer = new GenericDatumWriter(schema);
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)outputStream, null);
            writer.write(avroData, (Encoder)encoder);
            encoder.flush();
            bArray = ValueCreator.createArrayValue((byte[])outputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return Utils.createError("Avro serialization error", e);
            }
        }
        outputStream.close();
        return bArray;
    }

    public static Object fromAvro(BObject schemaObject, BArray payload, BTypedesc typeParam) {
        Schema schema = (Schema)schemaObject.getNativeData("avroSchema");
        GenericDatumReader datumReader = new GenericDatumReader(schema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(payload.getBytes(), null);
        try {
            Object data = datumReader.read((Object)payload, (Decoder)decoder);
            DeserializeVisitor deserializeVisitor = new DeserializeVisitor();
            Deserializer deserializer = DeserializeFactory.generateDeserializer(schema, typeParam.getDescribingType());
            return Objects.requireNonNull(deserializer).accept(deserializeVisitor, data);
        }
        catch (Exception e) {
            return Utils.createError("Avro deserialization error", e);
        }
    }
}

