/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.persist.BalException;
import io.ballerina.persist.configuration.DatabaseConfiguration;
import io.ballerina.persist.configuration.PersistConfiguration;
import io.ballerina.persist.introspect.Introspector;
import io.ballerina.persist.introspect.MsSqlInstrospector;
import io.ballerina.persist.introspect.MySqlIntrospector;
import io.ballerina.persist.introspect.PostgreSqlIntrospector;
import io.ballerina.persist.models.Module;
import io.ballerina.persist.nodegenerator.SourceGenerator;
import io.ballerina.persist.utils.BalProjectUtils;
import io.ballerina.persist.utils.DatabaseConnector;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Objects;
import java.util.Scanner;
import picocli.CommandLine;

@CommandLine.Command(name="pull", description={"Create model.bal file according to given database schema"})
public class Pull
implements BLauncherCmd {
    private static final PrintStream errStream = System.err;
    private final String sourcePath;
    private static final String COMMAND_IDENTIFIER = "persist-pull";
    @CommandLine.Option(names={"--datastore"})
    private String datastore = "mysql";
    @CommandLine.Option(names={"--host"})
    private String host;
    @CommandLine.Option(names={"--port"})
    private String port;
    @CommandLine.Option(names={"--user"})
    private String user;
    @CommandLine.Option(names={"--database"})
    private String database;
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;

    public Pull() {
        this("");
    }

    public Pull(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public void execute() {
        boolean modelFile;
        Introspector introspector;
        Scanner scanner = new Scanner(System.in, StandardCharsets.UTF_8);
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)COMMAND_IDENTIFIER);
            errStream.println(commandUsageInfo);
            return;
        }
        switch (this.datastore) {
            case "mysql": {
                introspector = new MySqlIntrospector();
                if (!Objects.isNull(this.port)) break;
                this.port = "3306";
                errStream.println("MySQL database introspection operates on the default port 3306");
                break;
            }
            case "postgresql": {
                introspector = new PostgreSqlIntrospector();
                if (!Objects.isNull(this.port)) break;
                this.port = "5432";
                errStream.println("PostgreSQL database introspection operates on the default port 5432");
                break;
            }
            case "mssql": {
                introspector = new MsSqlInstrospector();
                if (!Objects.isNull(this.port)) break;
                this.port = "1433";
                errStream.println("MSSQL database introspection operates on the default port 1433");
                break;
            }
            default: {
                errStream.printf("ERROR: unsupported data store: '%s'%n", this.datastore);
                return;
            }
        }
        try {
            BalProjectUtils.validatePullCommandOptions(this.datastore, this.host, this.port, this.user, this.database);
        }
        catch (BalException e) {
            errStream.println("ERROR: invalid option(s): " + System.lineSeparator() + e.getMessage());
            return;
        }
        String password = DatabaseConnector.readDatabasePassword(scanner, errStream);
        try {
            BalProjectUtils.validateBallerinaProject(Paths.get(this.sourcePath, new String[0]));
        }
        catch (BalException e) {
            errStream.println(e.getMessage());
            return;
        }
        Path persistDir = Paths.get(this.sourcePath, "persist");
        if (!Files.exists(persistDir, new LinkOption[0])) {
            try {
                Files.createDirectory(persistDir.toAbsolutePath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                errStream.println("ERROR: failed to create the persist directory. " + e.getMessage());
                return;
            }
        }
        if (modelFile = Files.exists(Path.of(String.valueOf(persistDir), "model.bal"), new LinkOption[0])) {
            String yellowColor = "\u001b[33m";
            String resetColor = "\u001b[0m";
            errStream.print(yellowColor + "WARNING A model.bal file already exists. Continuing would overwrite it. Do you wish to continue? (y/n) " + resetColor);
            String input = scanner.nextLine();
            if (!input.toLowerCase(Locale.ENGLISH).equals("y") && !input.toLowerCase(Locale.ENGLISH).equals("yes")) {
                errStream.println("Introspection aborted.");
                return;
            }
            errStream.println("Continuing...");
        }
        PersistConfiguration persistConfigurations = new PersistConfiguration();
        persistConfigurations.setProvider(this.datastore);
        persistConfigurations.setSourcePath(this.sourcePath);
        try {
            persistConfigurations.setDbConfig(new DatabaseConfiguration(this.host, this.user, password, this.port, this.database));
        }
        catch (BalException e) {
            errStream.println(e.getMessage());
            return;
        }
        Module entityModule = null;
        try {
            entityModule = introspector.introspectDatabase(persistConfigurations);
        }
        catch (BalException e) {
            errStream.printf("ERROR: failed to introspect database: %s%n", e.getMessage());
            return;
        }
        SourceGenerator sourceGenerator = new SourceGenerator(this.sourcePath, Paths.get(this.sourcePath, "persist"), "Introspect.db", entityModule);
        try {
            sourceGenerator.createDbModel();
        }
        catch (BalException e) {
            errStream.printf(String.format("ERROR: failed to generate model for introspected database: %s%n", e.getMessage()), new Object[0]);
            return;
        }
        errStream.println("Introspection complete! The model.bal file created successfully.");
    }

    public String getName() {
        return "persist";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Generate model definition by introspecting the database").append(System.lineSeparator());
        out.append(System.lineSeparator());
    }

    public void printUsage(StringBuilder stringBuilder) {
        stringBuilder.append("  ballerina persist pull").append(System.lineSeparator());
    }

    public void setParentCmdParser(CommandLine commandLine) {
    }
}

