/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.cmd;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.persist.BalException;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;

public class Utils {
    public static void generateSchemaBalFile(Path persistPath) throws BalException {
        try {
            String configTree = Utils.generateSchemaSyntaxTree();
            Utils.writeOutputString(configTree, persistPath.resolve("model.bal").toAbsolutePath().toString());
        }
        catch (Exception e) {
            throw new BalException(e.getMessage());
        }
    }

    public static void writeOutputString(String content, String outPath) throws BalException, IOException {
        Path pathToFile = Paths.get(outPath, new String[0]);
        Path parentDirectory = pathToFile.getParent();
        if (Objects.nonNull(parentDirectory)) {
            if (!Files.exists(parentDirectory, new LinkOption[0])) {
                try {
                    Files.createDirectories(parentDirectory, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new BalException(String.format("could not create the parent directories of output path %s. %s", parentDirectory, e.getMessage()));
                }
            }
            try (PrintWriter writer = new PrintWriter(outPath, StandardCharsets.UTF_8);){
                writer.println(content);
            }
        }
    }

    public static void writeToTargetFile(String content, String outPath) throws BalException, IOException {
        Path pathToFile = Paths.get(outPath, new String[0]);
        Path parentDirectory = pathToFile.getParent();
        if (Objects.nonNull(parentDirectory)) {
            boolean fileCreated;
            File file;
            if (!Files.exists(parentDirectory, new LinkOption[0])) {
                try {
                    Files.createDirectories(parentDirectory, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new BalException(String.format("could not create the parent directories of output path %s. %s", parentDirectory, e.getMessage()));
                }
            }
            if (!(file = new File(pathToFile.toString())).exists() && !(fileCreated = file.createNewFile())) {
                throw new BalException(String.format("Could not create the file in the output path %s.", outPath));
            }
            try (PrintWriter writer = new PrintWriter(outPath, StandardCharsets.UTF_8);){
                writer.println(content);
            }
        }
    }

    public static String generateSchemaSyntaxTree() throws FormatterException {
        NodeList imports = AbstractNodeFactory.createEmptyNodeList();
        NodeList moduleMembers = AbstractNodeFactory.createEmptyNodeList();
        imports = imports.add((Node)NodeParser.parseImportDeclaration((String)"import ballerina/persist as _;"));
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode((NodeList)imports, (NodeList)moduleMembers, (Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree balTree = SyntaxTree.from((TextDocument)textDocument);
        return Formatter.format((String)balTree.modifyWith((Node)modulePartNode).toSourceCode());
    }
}

