/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.introspect;

import io.ballerina.persist.introspect.Introspector;
import io.ballerina.persist.introspectiondto.SqlColumn;
import io.ballerina.persist.models.SqlType;
import io.ballerina.persist.utils.DatabaseConnector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MsSqlInstrospector
extends Introspector {
    public MsSqlInstrospector() {
        this.databaseConnector = new DatabaseConnector("jdbc:%s://%s:%s;databaseName=%s;trustServerCertificate=true;encrypt=false", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
    }

    @Override
    public String getTablesQuery() {
        String formatQuery = "SELECT\n    tbl.name AS table_name\nFROM sys.tables tbl\nWHERE tbl.is_ms_shipped = 0 AND tbl.type = 'U'\nORDER BY tbl.name;\n";
        formatQuery = formatQuery.replace("\r\n", "%n");
        return formatQuery;
    }

    @Override
    public String getColumnsQuery(String tableName) {
        String formatQuery = "SELECT\n    c.name AS column_name,\n    CASE typ.is_assembly_type\n        WHEN 1 THEN UPPER(TYPE_NAME(c.user_type_id))\n        ELSE UPPER(TYPE_NAME(c.system_type_id))\n        END AS data_type,\n    CASE\n        WHEN c.system_type_id IN (35, 99) THEN\n            UPPER(CONCAT(TYPE_NAME(c.user_type_id), '(', c.precision, ', ', c.scale, ')'))\n        WHEN c.system_type_id IN (48, 52, 56, 59, 60, 62, 106, 108, 122, 127) THEN\n            UPPER(CONCAT(TYPE_NAME(c.system_type_id), '(', c.precision, ')'))\n        WHEN c.system_type_id IN (35, 99) THEN\n            UPPER(CONCAT(TYPE_NAME(c.system_type_id), '(', c.precision, ', ', c.scale, ')'))\n        WHEN c.system_type_id IN (167, 175) THEN\n            UPPER(CONCAT(TYPE_NAME(c.system_type_id), '(', c.max_length, ')'))\n        ELSE\n            UPPER(TYPE_NAME(c.system_type_id))\n        END AS full_data_type,\n    IIF(COLUMNPROPERTY(c.object_id, c.name, 'charmaxlen') = -1, 0,\n        COLUMNPROPERTY(c.object_id, c.name, 'charmaxlen'))  AS character_maximum_length,\n    OBJECT_DEFINITION(c.default_object_id) AS column_default,\n    IIF(c.is_nullable = 1, 'YES', 'NO') AS is_nullable,\n    COLUMNPROPERTY(c.object_id, c.name, 'IsIdentity') AS dbGenerated,\n    OBJECT_NAME(c.object_id) AS table_name,\n    CONVERT(TINYINT, CASE\n                         WHEN c.system_type_id IN (48, 52, 56, 59, 60, 62, 106, 108, 122, 127)\n                         THEN c.precision\n                     END) AS numeric_precision,\n    CONVERT(INT, CASE\n                     WHEN c.system_type_id IN (40, 41, 42, 43, 58, 61) THEN NULL\n                     ELSE ODBCSCALE(c.system_type_id, c.scale) END) AS numeric_scale,\n    OBJECT_SCHEMA_NAME(c.object_id) AS namespace,\n    cc.definition AS check_constraint,\n    CASE\n        WHEN (SELECT DISTINCT\n            count(*)\n        FROM\n            sys.indexes ind\n                INNER JOIN sys.index_columns ic\n                           ON ind.object_id = ic.object_id AND ind.index_id = ic.index_id\n                INNER JOIN sys.columns col\n                           ON ic.object_id = col.object_id AND ic.column_id = col.column_id\n                INNER JOIN\n            sys.tables t ON ind.object_id = t.object_id\n        WHERE  t.name = OBJECT_NAME(c.object_id)\n          AND col.name = c.name\n          AND ind.is_primary_key = 1) = 1\n        THEN 'PRI'\n        ELSE 'NO'\n    END AS column_key\nFROM\n    sys.columns c\n        INNER JOIN sys.objects obj ON c.object_id = obj.object_id\n        INNER JOIN sys.types typ ON c.user_type_id = typ.user_type_id\n        LEFT JOIN sys.check_constraints cc ON c.object_id = cc.parent_object_id\n        AND c.column_id = cc.parent_column_id\nWHERE\n    obj.is_ms_shipped = 0\n  AND OBJECT_NAME(c.object_id) = '%s'\nORDER BY\n    table_name, COLUMNPROPERTY(c.object_id, c.name, 'ordinal');\n";
        formatQuery = formatQuery.replace("\r\n", "%n");
        return String.format(formatQuery, tableName);
    }

    @Override
    public String getIndexesQuery(String tableName) {
        String formatQuery = "SELECT DISTINCT\n    ind.name AS index_name,\n    ind.is_unique AS is_unique,\n    ind.is_unique_constraint AS is_unique_constraint,\n    col.name AS column_name,\n    ic.key_ordinal AS seq_in_index,\n    t.name AS table_name\nFROM\n    sys.indexes ind\n        INNER JOIN sys.index_columns ic\n                   ON ind.object_id = ic.object_id AND ind.index_id = ic.index_id\n        INNER JOIN sys.columns col\n                   ON ic.object_id = col.object_id AND ic.column_id = col.column_id\n        INNER JOIN\n    sys.tables t ON ind.object_id = t.object_id\nWHERE t.is_ms_shipped = 0\n  AND ic.key_ordinal != 0\n  AND ind.filter_definition IS NULL\n  AND ind.is_primary_key = 0\n  AND ind.name IS NOT NULL\n  AND ind.type_desc IN (\n        'CLUSTERED',\n        'NONCLUSTERED',\n        'CLUSTERED COLUMNSTORE',\n        'NONCLUSTERED COLUMNSTORE'\n    )\n  AND t.name = '%s'\nORDER BY table_name, index_name, seq_in_index;\n";
        formatQuery = formatQuery.replace("\r\n", "%n");
        return String.format(formatQuery, tableName);
    }

    @Override
    public String getForeignKeysQuery(String tableName) {
        String formatQuery = "SELECT OBJECT_NAME(fkc.constraint_object_id) AS constraint_name,\n       parent_table.name                        AS table_name,\n       referenced_table.name                    AS referenced_table_name,\n       parent_column.name                       AS column_name,\n       referenced_column.name                   AS referenced_column_name,\n       fk.delete_referential_action             AS delete_rule,\n       fk.update_referential_action             AS update_rule,\n       fkc.constraint_column_id                 AS ordinal_position\nFROM sys.foreign_key_columns AS fkc\n         INNER JOIN sys.tables AS parent_table\n                    ON fkc.parent_object_id = parent_table.object_id\n         INNER JOIN sys.tables AS referenced_table\n                    ON fkc.referenced_object_id = referenced_table.object_id\n         INNER JOIN sys.columns AS parent_column\n                    ON fkc.parent_object_id = parent_column.object_id\n                        AND fkc.parent_column_id = parent_column.column_id\n         INNER JOIN sys.columns AS referenced_column\n                    ON fkc.referenced_object_id = referenced_column.object_id\n                        AND fkc.referenced_column_id = referenced_column.column_id\n         INNER JOIN sys.foreign_keys AS fk\n                    ON fkc.constraint_object_id = fk.object_id\n                        AND fkc.parent_object_id = fk.parent_object_id\nWHERE parent_table.is_ms_shipped = 0\n  AND referenced_table.is_ms_shipped = 0\n  AND parent_table.name = '%s'\nORDER BY table_name, ordinal_position;\n";
        formatQuery = formatQuery.replace("\r\n", "%n");
        return String.format(formatQuery, tableName);
    }

    @Override
    protected String getEnumsQuery() {
        String formatQuery = "SELECT\n    OBJECT_NAME(parent_object_id) AS table_name,\n    COL_NAME(parent_object_id, parent_column_id) AS column_name,\n    definition AS full_enum_type\nFROM sys.check_constraints\nWHERE definition LIKE '%OR%'\n    AND definition LIKE '%=%'\n    AND definition NOT LIKE '%AND%'\n    AND definition NOT LIKE '%>%'\n    AND definition NOT LIKE '%<%';\n";
        formatQuery = formatQuery.replace("\r\n", "%n");
        return formatQuery;
    }

    @Override
    protected boolean isEnumType(SqlColumn column) {
        if (Objects.isNull(column.getCheckConstraint())) {
            return false;
        }
        Pattern pattern = Pattern.compile("^\\((\\[(\\w+(\\s+\\w+){0,3})]='(\\w+(\\s+\\w+){0,3})')(\\sOR\\s\\[(\\w+(\\s+\\w+){0,3})]='(\\w+(\\s+\\w+){0,3})')*\\)$");
        return pattern.matcher(column.getCheckConstraint()).find();
    }

    @Override
    protected List<String> extractEnumValues(String enumString) {
        ArrayList<String> enumValues = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\((.*?)\\)");
        Matcher matcher = pattern.matcher(enumString);
        if (matcher.find()) {
            String valuesInsideParentheses = matcher.group(1);
            String[] valuesArray = valuesInsideParentheses.split("OR");
            Arrays.stream(valuesArray).map(value -> {
                String[] splitValue = value.split("=");
                return splitValue[1].replace("'", "").trim();
            }).forEach(enumValues::add);
        }
        return enumValues;
    }

    @Override
    protected String getBalType(SqlType sqlType) {
        if (Objects.equals(sqlType.getTypeName(), "BIT")) {
            return "boolean";
        }
        return this.getBalTypeForCommonDataTypes(sqlType);
    }
}

