/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.introspectiondto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SqlForeignKey {
    private final String constraintName;
    private final String tableName;
    private List<String> columnNames;
    private final String referencedTableName;
    private List<String> referencedColumnNames;
    private final String updateRule;
    private final String deleteRule;

    public String getConstraintName() {
        return this.constraintName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.columnNames);
    }

    public SqlForeignKey(String constraintName, String tableName, List<String> columnNames, String referencedTableName, List<String> referencedColumnNames, String updateRule, String deleteRule) {
        this.constraintName = constraintName;
        this.tableName = tableName;
        this.columnNames = Collections.unmodifiableList(columnNames);
        this.referencedTableName = referencedTableName;
        this.referencedColumnNames = Collections.unmodifiableList(referencedColumnNames);
        this.updateRule = updateRule;
        this.deleteRule = deleteRule;
    }

    public String getReferencedTableName() {
        return this.referencedTableName;
    }

    public List<String> getReferencedColumnNames() {
        return Collections.unmodifiableList(this.referencedColumnNames);
    }

    public String getUpdateRule() {
        return this.updateRule;
    }

    public String getDeleteRule() {
        return this.deleteRule;
    }

    public void addColumnName(String columnName) {
        ArrayList<String> newColumnNames = new ArrayList<String>(this.columnNames);
        newColumnNames.add(columnName);
        this.columnNames = Collections.unmodifiableList(newColumnNames);
    }

    public void addReferencedColumnName(String referencedColumnName) {
        ArrayList<String> newReferencedColumnNames = new ArrayList<String>(this.referencedColumnNames);
        newReferencedColumnNames.add(referencedColumnName);
        this.referencedColumnNames = Collections.unmodifiableList(newReferencedColumnNames);
    }

    public static class Builder {
        private final String constraintName;
        private String tableName;
        private final List<String> columnNames;
        private String referencedTableName;
        private final List<String> referencedColumnNames;
        private String updateRule;
        private String deleteRule;

        public static Builder newBuilder(String constraintName) {
            return new Builder(constraintName);
        }

        private Builder(String constraintName) {
            this.constraintName = constraintName;
            this.columnNames = new ArrayList<String>();
            this.referencedColumnNames = new ArrayList<String>();
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder addColumnName(String columnName) {
            this.columnNames.add(columnName);
            return this;
        }

        public Builder setReferencedTableName(String referencedTableName) {
            this.referencedTableName = referencedTableName;
            return this;
        }

        public Builder addReferencedColumnName(String referencedColumnName) {
            this.referencedColumnNames.add(referencedColumnName);
            return this;
        }

        public Builder setUpdateRule(String updateRule) {
            this.updateRule = updateRule;
            return this;
        }

        public Builder setDeleteRule(String deleteRule) {
            this.deleteRule = deleteRule;
            return this;
        }

        public SqlForeignKey build() {
            return new SqlForeignKey(this.constraintName, this.tableName, this.columnNames, this.referencedTableName, this.referencedColumnNames, this.updateRule, this.deleteRule);
        }
    }
}

