/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.introspectiondto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SqlIndex {
    private final String tableName;
    private final String indexName;
    private final List<String> columnNames;
    private final boolean unique;

    private SqlIndex(String indexName, String tableName, List<String> columnNames, boolean unique) {
        this.indexName = indexName;
        this.tableName = tableName;
        this.columnNames = columnNames;
        this.unique = unique;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.columnNames);
    }

    public boolean getUnique() {
        return this.unique;
    }

    public void addColumnName(String columnName) {
        this.columnNames.add(columnName);
    }

    public static Builder newBuilder(String indexName) {
        return new Builder(indexName);
    }

    public static class Builder {
        private final String indexName;
        private String tableName;
        private final List<String> columnNames;
        private boolean unique;

        public static Builder newBuilder(String indexName) {
            return new Builder(indexName);
        }

        private Builder(String indexName) {
            this.indexName = indexName;
            this.columnNames = new ArrayList<String>();
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder addColumnName(String columnName) {
            this.columnNames.add(columnName);
            return this;
        }

        public Builder setUnique(boolean unique) {
            this.unique = unique;
            return this;
        }

        public SqlIndex build() {
            return new SqlIndex(this.indexName, this.tableName, this.columnNames, this.unique);
        }
    }
}

