/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.models;

import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.persist.models.Enum;
import io.ballerina.persist.models.Relation;
import io.ballerina.persist.models.SqlType;
import io.ballerina.persist.nodegenerator.syntax.utils.BalSyntaxUtils;
import io.ballerina.persist.utils.StubUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EntityField {
    private final String fieldName;
    private final String fieldColumnName;
    private final String fieldType;
    private final SqlType sqlType;
    private final boolean arrayType;
    private final boolean optionalType;
    private final boolean isDbGenerated;
    private final boolean optionalField;
    private Relation relation;
    private Enum enumValue;
    private final List<AnnotationNode> annotationNodes;
    private final List<String> relationRefs;

    EntityField(String fieldName, String fieldColumnName, String fieldType, boolean arrayType, boolean optionalType, boolean optionalField, List<AnnotationNode> annotationNodes, SqlType sqlType, List<String> relationRefs, boolean isDbGenerated) {
        this.fieldName = fieldName;
        this.fieldColumnName = fieldColumnName;
        this.fieldType = fieldType;
        this.arrayType = arrayType;
        this.optionalType = optionalType;
        this.optionalField = optionalField;
        this.annotationNodes = Collections.unmodifiableList(annotationNodes != null ? annotationNodes : new ArrayList());
        this.sqlType = sqlType;
        this.relationRefs = Collections.unmodifiableList(relationRefs != null ? relationRefs : new ArrayList());
        this.isDbGenerated = isDbGenerated;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldColumnName() {
        return this.fieldColumnName;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public SqlType getSqlType() {
        return this.sqlType;
    }

    public List<AnnotationNode> getAnnotation() {
        return this.annotationNodes;
    }

    public boolean isDbGenerated() {
        return this.isDbGenerated;
    }

    public boolean shouldColumnMappingGenerated() {
        if (this.fieldColumnName == null || this.fieldColumnName.isBlank()) {
            return false;
        }
        return !this.fieldColumnName.equals(BalSyntaxUtils.stripEscapeCharacter(this.fieldName));
    }

    public List<String> getRelationRefs() {
        return this.relationRefs;
    }

    public void setRelation(Relation relation) {
        this.relation = relation;
    }

    public void setEnum(Enum enumValue) {
        this.enumValue = enumValue;
    }

    public Enum getEnum() {
        return this.enumValue;
    }

    public boolean isArrayType() {
        return this.arrayType;
    }

    public boolean isOptionalType() {
        return this.optionalType;
    }

    public boolean isOptionalField() {
        return this.optionalField;
    }

    public static Builder newBuilder(String fieldName) {
        return new Builder(fieldName);
    }

    public static class Builder {
        String fieldName;
        String fieldColumnName;
        String fieldType;
        private boolean arrayType = false;
        private boolean optionalType = false;
        boolean optionalField = false;
        SqlType sqlType;
        private List<AnnotationNode> annotationNodes = null;
        private List<String> relationRefs;
        private boolean isDbGenerated = false;

        Builder(String fieldName) {
            if (StubUtils.isLiteralName(fieldName)) {
                this.fieldName = "'" + fieldName;
                return;
            }
            this.fieldName = fieldName;
        }

        public void setType(String fieldType) {
            if (fieldType.contains(":") && !fieldType.startsWith("time:")) {
                fieldType = fieldType.split(":", 2)[1];
            }
            this.fieldType = fieldType;
        }

        public void setSqlType(SqlType sqlType) {
            this.sqlType = sqlType;
        }

        public void setFieldColumnName(String fieldColumnName) {
            this.fieldColumnName = fieldColumnName;
        }

        public void setRelationRefs(List<String> relationRefs) {
            this.relationRefs = relationRefs;
        }

        public void setIsDbGenerated(boolean isDbGenerated) {
            this.isDbGenerated = isDbGenerated;
        }

        public void setArrayType(boolean arrayType) {
            this.arrayType = arrayType;
        }

        public void setOptionalType(boolean optionalType) {
            this.optionalType = optionalType;
        }

        public void setOptionalField(boolean optionalField) {
            this.optionalField = optionalField;
        }

        public void setAnnotations(List<AnnotationNode> annotationNodes) {
            this.annotationNodes = annotationNodes;
        }

        public EntityField build() {
            return new EntityField(this.fieldName, this.fieldColumnName, this.fieldType, this.arrayType, this.optionalType, this.optionalField, this.annotationNodes, this.sqlType, this.relationRefs, this.isDbGenerated);
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }
}

