/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.nodegenerator.syntax.utils;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.persist.PersistToolsConstants;
import io.ballerina.persist.components.Client;
import io.ballerina.persist.components.Function;
import io.ballerina.persist.components.TypeDescriptor;
import io.ballerina.persist.models.Entity;
import io.ballerina.persist.models.EntityField;
import io.ballerina.persist.models.Enum;
import io.ballerina.persist.models.EnumMember;
import io.ballerina.persist.models.Module;
import io.ballerina.persist.models.Relation;
import io.ballerina.persist.models.SqlType;
import io.ballerina.persist.nodegenerator.syntax.constants.BalSyntaxConstants;
import io.ballerina.persist.nodegenerator.syntax.constants.SyntaxTokenConstants;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class BalSyntaxUtils {
    public static NodeList<ImportDeclarationNode> generateImport(Module entityModule) {
        NodeList imports = AbstractNodeFactory.createEmptyNodeList();
        MinutiaeList commentMinutiaeList = BalSyntaxUtils.createCommentMinutiaeList(String.format("// This file is an auto-generated file by Ballerina persistence layer for %s.", entityModule.getModuleName()));
        imports = imports.add((Node)BalSyntaxUtils.getImportDeclarationNodeWithAutogeneratedComment(commentMinutiaeList, "jballerina.java"));
        imports = imports.add((Node)BalSyntaxUtils.getImportDeclarationNode("ballerina", "persist", null));
        return imports;
    }

    public static NodeList<ImportDeclarationNode> generateImportGSheets(Module entityModule) {
        NodeList imports = AbstractNodeFactory.createEmptyNodeList();
        MinutiaeList commentMinutiaeList = BalSyntaxUtils.createCommentMinutiaeList(String.format("// This file is an auto-generated file by Ballerina persistence layer for %s.", entityModule.getModuleName()));
        imports = imports.add((Node)BalSyntaxUtils.getImportDeclarationNodeWithAutogeneratedComment(commentMinutiaeList, "http"));
        imports = imports.add((Node)BalSyntaxUtils.getImportDeclarationNode("ballerina", "jballerina.java", null));
        imports = imports.add((Node)BalSyntaxUtils.getImportDeclarationNode("ballerina", "persist", null));
        return imports;
    }

    public static NodeList<ModuleMemberDeclarationNode> generateConstantVariables(Module entityModule) {
        NodeList moduleMembers = AbstractNodeFactory.createEmptyNodeList();
        for (Entity entity : entityModule.getEntityMap().values()) {
            if (entity.containsUnsupportedTypes()) continue;
            moduleMembers = moduleMembers.add((Node)NodeParser.parseModuleMemberDeclaration((String)String.format("const %s = \"%s\";", BalSyntaxUtils.stripEscapeCharacter(BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName())), BalSyntaxUtils.stripEscapeCharacter(entity.getClientResourceName()))));
        }
        return moduleMembers;
    }

    public static SyntaxTree generateSyntaxTree(NodeList<ImportDeclarationNode> imports, NodeList<ModuleMemberDeclarationNode> moduleMembers) {
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode(imports, moduleMembers, (Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree balTree = SyntaxTree.from((TextDocument)textDocument);
        return balTree.modifyWith((Node)modulePartNode);
    }

    public static Client generateClientSignature(String clientName, boolean isIsolated) {
        Client clientObject = new Client(clientName);
        if (isIsolated) {
            clientObject.addQualifiers(new String[]{"isolated", "client"});
        } else {
            clientObject.addQualifiers(new String[]{"client"});
        }
        clientObject.addMember((Node)NodeFactory.createTypeReferenceNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ASTERISK_TOKEN), (Node)NodeFactory.createQualifiedNameReferenceNode((Token)NodeFactory.createIdentifierToken((String)"persist"), (Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (IdentifierToken)NodeFactory.createIdentifierToken((String)"AbstractPersistClient")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN)), false);
        return clientObject;
    }

    public static Function generateCloseFunction() {
        Function close = new Function("close", SyntaxKind.OBJECT_METHOD_DEFINITION);
        close.addQualifiers(new String[]{"public", "isolated"});
        close.addReturns((TypeDescriptorNode)TypeDescriptor.getOptionalTypeDescriptorNode("", "persist:Error"));
        return close;
    }

    public static FunctionDefinitionNode generateGetFunction(Entity entity, String className, String moduleName) {
        return (FunctionDefinitionNode)NodeParser.parseObjectMember((String)String.format(BalSyntaxConstants.EXTERNAL_GET_METHOD_TEMPLATE, entity.getClientResourceName(), entity.getEntityName(), moduleName, className));
    }

    public static FunctionDefinitionNode generateGetByKeyFunction(Entity entity, String className, String moduleName) {
        StringBuilder keyBuilder = new StringBuilder();
        for (EntityField keyField : entity.getKeys()) {
            if (keyBuilder.length() > 0) {
                keyBuilder.append("/");
            }
            keyBuilder.append("[");
            keyBuilder.append(keyField.getFieldType());
            keyBuilder.append(" ");
            keyBuilder.append(keyField.getFieldName());
            keyBuilder.append("]");
        }
        return (FunctionDefinitionNode)NodeParser.parseObjectMember((String)String.format(BalSyntaxConstants.EXTERNAL_GET_BY_KEY_METHOD_TEMPLATE, entity.getClientResourceName(), keyBuilder, entity.getEntityName(), moduleName, className));
    }

    public static Function generatePostFunction(Entity entity, List<EntityField> primaryKeys, String parameterType) {
        Function create = new Function("post", SyntaxKind.RESOURCE_ACCESSOR_DEFINITION);
        NodeList resourcePaths = AbstractNodeFactory.createEmptyNodeList();
        resourcePaths = resourcePaths.add((Node)AbstractNodeFactory.createIdentifierToken((String)entity.getClientResourceName()));
        create.addRelativeResourcePaths((NodeList<Node>)resourcePaths);
        create.addRequiredParameter((Node)TypeDescriptor.getArrayTypeDescriptorNode(parameterType), "data");
        create.addQualifiers(new String[]{"isolated", "resource"});
        BalSyntaxUtils.addReturnsToPostResourceSignature(create, primaryKeys);
        return create;
    }

    public static Function generatePutFunction(Entity entity, StringBuilder filterKeys, StringBuilder path) {
        Function update = new Function("put", SyntaxKind.RESOURCE_ACCESSOR_DEFINITION);
        update.addQualifiers(new String[]{"isolated", "resource"});
        update.addRequiredParameter((Node)TypeDescriptor.getSimpleNameReferenceNode(String.format("%sUpdate", entity.getEntityName())), "value");
        NodeList<Node> resourcePaths = AbstractNodeFactory.createEmptyNodeList();
        resourcePaths = BalSyntaxUtils.getResourcePath(resourcePaths, entity.getKeys(), filterKeys, path, entity.getClientResourceName());
        update.addRelativeResourcePaths(resourcePaths);
        update.addReturns((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(entity.getEntityName()), (TypeDescriptorNode)TypeDescriptor.getQualifiedNameReferenceNode("persist", "Error")));
        return update;
    }

    public static Function generateDeleteFunction(Entity entity, StringBuilder filterKeys, StringBuilder path) {
        Function delete = new Function("delete", SyntaxKind.RESOURCE_ACCESSOR_DEFINITION);
        delete.addQualifiers(new String[]{"isolated", "resource"});
        NodeList<Node> resourcePaths = AbstractNodeFactory.createEmptyNodeList();
        resourcePaths = BalSyntaxUtils.getResourcePath(resourcePaths, entity.getKeys(), filterKeys, path, entity.getClientResourceName());
        delete.addRelativeResourcePaths(resourcePaths);
        delete.addReturns((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(entity.getEntityName()), (TypeDescriptorNode)TypeDescriptor.getQualifiedNameReferenceNode("persist", "Error")));
        return delete;
    }

    private static MinutiaeList createCommentMinutiaeList(String comment) {
        return NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{AbstractNodeFactory.createCommentMinutiae((String)"// AUTO-GENERATED FILE. DO NOT MODIFY."), AbstractNodeFactory.createEndOfLineMinutiae((String)System.lineSeparator()), AbstractNodeFactory.createEndOfLineMinutiae((String)System.lineSeparator()), AbstractNodeFactory.createCommentMinutiae((String)comment), AbstractNodeFactory.createEndOfLineMinutiae((String)System.lineSeparator()), AbstractNodeFactory.createCommentMinutiae((String)"// It should not be modified by hand."), AbstractNodeFactory.createEndOfLineMinutiae((String)System.lineSeparator()), AbstractNodeFactory.createEndOfLineMinutiae((String)System.lineSeparator())});
    }

    private static ImportDeclarationNode getImportDeclarationNodeWithAutogeneratedComment(MinutiaeList commentMinutiaeList, String moduleName) {
        IdentifierToken orgNameToken = AbstractNodeFactory.createIdentifierToken((String)"ballerina");
        ImportOrgNameNode importOrgNameNode = NodeFactory.createImportOrgNameNode((Token)orgNameToken, (Token)SyntaxTokenConstants.SYNTAX_TREE_SLASH);
        IdentifierToken moduleNameToken = AbstractNodeFactory.createIdentifierToken((String)moduleName);
        SeparatedNodeList moduleNodeList = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{moduleNameToken});
        Token importToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.IMPORT_KEYWORD, (MinutiaeList)commentMinutiaeList, (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{AbstractNodeFactory.createWhitespaceMinutiae((String)" ")}));
        return NodeFactory.createImportDeclarationNode((Token)importToken, (ImportOrgNameNode)importOrgNameNode, (SeparatedNodeList)moduleNodeList, null, (Token)SyntaxTokenConstants.SYNTAX_TREE_SEMICOLON);
    }

    private static void addReturnsToPostResourceSignature(Function create, List<EntityField> primaryKeys) {
        ArrayDimensionNode arrayDimensionNode = NodeFactory.createArrayDimensionNode((Token)SyntaxTokenConstants.SYNTAX_TREE_OPEN_BRACKET, null, (Token)SyntaxTokenConstants.SYNTAX_TREE_CLOSE_BRACKET);
        NodeList dimensionList = NodeFactory.createNodeList((Node[])new ArrayDimensionNode[]{arrayDimensionNode});
        ArrayList typeTuple = new ArrayList();
        if (primaryKeys.size() > 1) {
            primaryKeys.forEach(primaryKey -> {
                if (!typeTuple.isEmpty()) {
                    typeTuple.add(NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
                }
                typeTuple.add(NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createIdentifierToken((String)primaryKey.getFieldType())));
            });
            create.addReturns((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode((TypeDescriptorNode)NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)NodeFactory.createTupleTypeDescriptorNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN), (SeparatedNodeList)NodeFactory.createSeparatedNodeList(typeTuple), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN)), (NodeList)dimensionList), (TypeDescriptorNode)TypeDescriptor.getQualifiedNameReferenceNode("persist", "Error")));
        } else {
            create.addReturns((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getArrayTypeDescriptorNode(primaryKeys.get(0).getFieldType()), (TypeDescriptorNode)TypeDescriptor.getQualifiedNameReferenceNode("persist", "Error")));
        }
    }

    private static NodeList<Node> getResourcePath(NodeList<Node> resourcePaths, List<EntityField> keys, StringBuilder filterKeys, StringBuilder path, String tableName) {
        resourcePaths = resourcePaths.add((Node)AbstractNodeFactory.createIdentifierToken((String)tableName));
        for (EntityField entry : keys) {
            resourcePaths = resourcePaths.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SLASH_TOKEN));
            resourcePaths = resourcePaths.add((Node)NodeFactory.createResourcePathParameterNode((SyntaxKind)SyntaxKind.RESOURCE_PATH_SEGMENT_PARAM, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (TypeDescriptorNode)NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)SyntaxKind.STRING_TYPE_DESC, (Token)AbstractNodeFactory.createIdentifierToken((String)(entry.getFieldType() + " "))), null, (Token)AbstractNodeFactory.createIdentifierToken((String)entry.getFieldName()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN)));
            filterKeys.append("\"").append(BalSyntaxUtils.stripEscapeCharacter(entry.getFieldName())).append("\"").append(":").append(entry.getFieldName()).append(", ");
            path.append("/").append("[").append(entry.getFieldName()).append("]");
        }
        return resourcePaths;
    }

    public static SyntaxTree createDriverImportFile(String datastore) {
        NodeList imports = AbstractNodeFactory.createEmptyNodeList();
        NodeList moduleMembers = AbstractNodeFactory.createEmptyNodeList();
        imports = switch (datastore) {
            case "mysql" -> imports.add((Node)NodeParser.parseImportDeclaration((String)"import ballerinax/mysql.driver as _;"));
            case "postgresql" -> imports.add((Node)NodeParser.parseImportDeclaration((String)"import ballerinax/postgresql.driver as _;"));
            case "sqlserver" -> imports.add((Node)NodeParser.parseImportDeclaration((String)"import ballerinax/mssql.driver as _;"));
            case "h2" -> imports.add((Node)NodeParser.parseImportDeclaration((String)"import ballerinax/h2.driver as _;"));
            default -> imports;
        };
        return BalSyntaxUtils.generateSyntaxTree((NodeList<ImportDeclarationNode>)imports, (NodeList<ModuleMemberDeclarationNode>)moduleMembers);
    }

    public static SyntaxTree generateModelSyntaxTree(Module entityModule) {
        NodeList imports = AbstractNodeFactory.createEmptyNodeList();
        NodeList moduleMembers = AbstractNodeFactory.createEmptyNodeList();
        imports = imports.add((Node)NodeParser.parseImportDeclaration((String)"import ballerina/persist as _;"));
        boolean areAnnotationsAdded = false;
        block0: for (Entity entity2 : entityModule.getEntityMap().values()) {
            if (entity2.shouldTableMappingGenerated() || entity2.getIndexes() != null && !entity2.getIndexes().isEmpty() || entity2.getUniqueIndexes() != null && !entity2.getUniqueIndexes().isEmpty()) {
                areAnnotationsAdded = true;
                break;
            }
            for (EntityField field : entity2.getFields()) {
                if (!field.shouldColumnMappingGenerated() && !field.isDbGenerated() && !BalSyntaxUtils.isDbTypeMappingRequired(field) && (field.getRelationRefs() == null || field.getRelationRefs().isEmpty())) continue;
                areAnnotationsAdded = true;
                continue block0;
            }
        }
        if (areAnnotationsAdded) {
            imports = imports.add((Node)NodeParser.parseImportDeclaration((String)"import ballerinax/persist.sql;"));
        }
        if (entityModule.getEntityMap().values().stream().anyMatch(entity -> entity.getFields().stream().anyMatch(field -> field.getFieldType().startsWith("time")))) {
            imports = imports.add((Node)NodeParser.parseImportDeclaration((String)"import ballerina/time;"));
        }
        for (Enum enumValue : entityModule.getEnumMap().values()) {
            moduleMembers = moduleMembers.add((Node)BalSyntaxUtils.createEnumDeclaration(enumValue, false, entityModule.getModuleName()));
        }
        for (Entity entity2 : entityModule.getEntityMap().values()) {
            moduleMembers = moduleMembers.add((Node)BalSyntaxUtils.createEntityRecord(entity2, false, entityModule.getModuleName(), true));
        }
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode((NodeList)imports, (NodeList)moduleMembers, (Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree balTree = SyntaxTree.from((TextDocument)textDocument);
        return balTree.modifyWith((Node)modulePartNode);
    }

    public static SyntaxTree generateTypeSyntaxTree(Module entityModule, String datastore) {
        NodeList imports = AbstractNodeFactory.createEmptyNodeList();
        NodeList moduleMembers = AbstractNodeFactory.createEmptyNodeList();
        MinutiaeList commentMinutiaeList = BalSyntaxUtils.createCommentMinutiaeList(String.format("// This file is an auto-generated file by Ballerina persistence layer for %s.", entityModule.getModuleName()));
        for (String string : entityModule.getImportModulePrefixes()) {
            if (imports.isEmpty()) {
                imports = imports.add((Node)BalSyntaxUtils.getImportDeclarationNodeWithAutogeneratedComment(string, commentMinutiaeList));
                continue;
            }
            imports = imports.add((Node)BalSyntaxUtils.getImportDeclarationNode(string));
        }
        boolean includeAutoGeneratedComment = imports.isEmpty();
        for (Enum enumValue : entityModule.getEnumMap().values()) {
            moduleMembers = moduleMembers.add((Node)BalSyntaxUtils.createEnumDeclaration(enumValue, includeAutoGeneratedComment, entityModule.getModuleName()));
            if (!includeAutoGeneratedComment) continue;
            includeAutoGeneratedComment = false;
        }
        for (Entity entity : entityModule.getEntityMap().values()) {
            boolean hasRelations = false;
            for (EntityField field : entity.getFields()) {
                if (field.getRelation() == null) continue;
                hasRelations = true;
                break;
            }
            moduleMembers = moduleMembers.add((Node)BalSyntaxUtils.createEntityRecord(entity, includeAutoGeneratedComment, entityModule.getModuleName(), false));
            if (includeAutoGeneratedComment) {
                includeAutoGeneratedComment = false;
            }
            moduleMembers = moduleMembers.add((Node)BalSyntaxUtils.createEntityRecordOptionalized(entity));
            if (hasRelations) {
                moduleMembers = moduleMembers.add((Node)BalSyntaxUtils.createEntityRecordWithRelation(entity));
            }
            moduleMembers = moduleMembers.add((Node)BalSyntaxUtils.createEntityTargetType(entity, hasRelations));
            moduleMembers = moduleMembers.add((Node)BalSyntaxUtils.createInsertRecord(entity, datastore));
            moduleMembers = moduleMembers.add((Node)BalSyntaxUtils.createUpdateRecord(entity));
        }
        IdentifierToken identifierToken = AbstractNodeFactory.createIdentifierToken((String)"");
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode((NodeList)imports, (NodeList)moduleMembers, (Token)identifierToken);
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree balTree = SyntaxTree.from((TextDocument)textDocument);
        return balTree.modifyWith((Node)modulePartNode);
    }

    private static ImportDeclarationNode getImportDeclarationNode(String moduleName) {
        IdentifierToken orgNameToken = AbstractNodeFactory.createIdentifierToken((String)"ballerina");
        ImportOrgNameNode importOrgNameNode = NodeFactory.createImportOrgNameNode((Token)orgNameToken, (Token)SyntaxTokenConstants.SYNTAX_TREE_SLASH);
        IdentifierToken moduleNameToken = AbstractNodeFactory.createIdentifierToken((String)moduleName);
        SeparatedNodeList moduleNodeList = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{moduleNameToken});
        return NodeFactory.createImportDeclarationNode((Token)SyntaxTokenConstants.SYNTAX_TREE_KEYWORD_IMPORT, (ImportOrgNameNode)importOrgNameNode, (SeparatedNodeList)moduleNodeList, null, (Token)SyntaxTokenConstants.SYNTAX_TREE_SEMICOLON);
    }

    private static ModuleMemberDeclarationNode createEntityRecord(Entity entity, boolean includeAutogeneratedComment, String moduleName, boolean withAnnotations) {
        StringBuilder recordFields = new StringBuilder();
        recordFields.append(BalSyntaxConstants.NEWLINE);
        for (EntityField field : entity.getFields()) {
            if (Objects.equals(field.getFieldType(), "Unsupported")) {
                recordFields.append("/");
                recordFields.append("/");
                recordFields.append("Unsupported");
                recordFields.append("[");
                recordFields.append(field.getSqlType().getFullDataType());
                recordFields.append("]");
                recordFields.append(" ");
                recordFields.append(field.getFieldColumnName());
                recordFields.append(";");
                recordFields.append(BalSyntaxConstants.NEWLINE);
                continue;
            }
            if (withAnnotations) {
                BalSyntaxUtils.addDbMappingAnnotationToField(field, recordFields);
                BalSyntaxUtils.addDbTypeMappingAnnotationToField(field, recordFields);
                BalSyntaxUtils.addDbRelationMappingAnnotationToField(field, recordFields);
                BalSyntaxUtils.addDbIndexAnnotationToField(entity, field, recordFields);
                BalSyntaxUtils.addDbGeneratedAnnotationToField(field, recordFields);
            }
            if (entity.getKeys().stream().anyMatch(key -> key == field)) {
                BalSyntaxUtils.addConstrainAnnotationToField(field, recordFields);
                recordFields.append("readonly");
                recordFields.append(" ");
                recordFields.append(field.getFieldType());
                if (field.isArrayType()) {
                    recordFields.append("[]");
                }
                recordFields.append(" ");
                recordFields.append(field.getFieldName());
                if (field.isOptionalField()) {
                    recordFields.append("?");
                }
                recordFields.append(";");
                recordFields.append(" ");
            } else if (field.getRelation() != null) {
                if (field.getRelation().isOwner()) {
                    for (Relation.Key key2 : field.getRelation().getKeyColumns()) {
                        BalSyntaxUtils.addConstraintsAnnotationForForeignKey(field, recordFields);
                        recordFields.append(key2.getType());
                        recordFields.append(" ");
                        recordFields.append(key2.getField());
                        recordFields.append(";");
                        recordFields.append(" ");
                    }
                }
            } else {
                BalSyntaxUtils.addConstrainAnnotationToField(field, recordFields);
                BalSyntaxUtils.addFieldString(recordFields, field);
            }
            recordFields.append(BalSyntaxConstants.NEWLINE);
        }
        if (includeAutogeneratedComment) {
            String commentBuilder = "// AUTO-GENERATED FILE. DO NOT MODIFY." + System.lineSeparator() + System.lineSeparator() + String.format("// This file is an auto-generated file by Ballerina persistence layer for %s.", moduleName) + System.lineSeparator() + "// It should not be modified by hand." + System.lineSeparator() + System.lineSeparator() + "public type %s record {| %s |};";
            return NodeParser.parseModuleMemberDeclaration((String)String.format(commentBuilder, entity.getEntityName().trim(), recordFields));
        }
        StringBuilder recordString = new StringBuilder();
        if (withAnnotations) {
            BalSyntaxUtils.addDbMappingAnnotationToEntity(entity, recordString);
        }
        recordString.append(String.format("public type %s record {| %s |};", entity.getEntityName().trim(), recordFields));
        return NodeParser.parseModuleMemberDeclaration((String)recordString.toString());
    }

    private static void addDbGeneratedAnnotationToField(EntityField field, StringBuilder recordFields) {
        if (field.isDbGenerated()) {
            recordFields.append(BalSyntaxConstants.SQL_GENERATED_ANNOTATION);
            recordFields.append(BalSyntaxConstants.NEWLINE);
        }
    }

    private static void addDbIndexAnnotationToField(Entity entity, EntityField field, StringBuilder recordFields) {
        ArrayList<String> indexNames = new ArrayList<String>();
        ArrayList<String> uniqueIndexNames = new ArrayList<String>();
        entity.getUniqueIndexes().forEach(index -> {
            if (index.getFields().contains(field)) {
                uniqueIndexNames.add(index.getIndexName());
            }
        });
        entity.getIndexes().forEach(index -> {
            if (index.getFields().contains(field)) {
                indexNames.add(index.getIndexName());
            }
        });
        if (!indexNames.isEmpty()) {
            if (indexNames.size() == 1) {
                recordFields.append(String.format(BalSyntaxConstants.SQL_INDEX_MAPPING_ANNOTATION, "\"" + (String)indexNames.get(0) + "\""));
            } else {
                recordFields.append(String.format(BalSyntaxConstants.SQL_INDEX_MAPPING_ANNOTATION, BalSyntaxUtils.formatToBalStringArray(indexNames)));
            }
            recordFields.append(BalSyntaxConstants.NEWLINE);
        }
        if (!uniqueIndexNames.isEmpty()) {
            if (uniqueIndexNames.size() == 1) {
                recordFields.append(String.format(BalSyntaxConstants.SQL_UNIQUE_INDEX_MAPPING_ANNOTATION, "\"" + (String)uniqueIndexNames.get(0) + "\""));
            } else {
                recordFields.append(String.format(BalSyntaxConstants.SQL_UNIQUE_INDEX_MAPPING_ANNOTATION, BalSyntaxUtils.formatToBalStringArray(uniqueIndexNames)));
            }
            recordFields.append(BalSyntaxConstants.NEWLINE);
        }
    }

    private static void addDbRelationMappingAnnotationToField(EntityField field, StringBuilder recordFields) {
        if (!field.getRelationRefs().isEmpty()) {
            recordFields.append(String.format(BalSyntaxConstants.SQL_RELATION_MAPPING_ANNOTATION, BalSyntaxUtils.formatToBalStringArray(field.getRelationRefs())));
        }
    }

    private static String formatToBalStringArray(List<String> list) {
        StringBuilder stringArray = new StringBuilder();
        stringArray.append(SyntaxTokenConstants.SYNTAX_TREE_OPEN_BRACKET);
        for (String item : list) {
            stringArray.append("\"");
            stringArray.append(item);
            stringArray.append("\"");
            stringArray.append(", ");
        }
        stringArray.delete(stringArray.length() - 2, stringArray.length());
        stringArray.append(SyntaxTokenConstants.SYNTAX_TREE_CLOSE_BRACKET);
        return stringArray.toString();
    }

    private static void addDbTypeMappingAnnotationToField(EntityField field, StringBuilder recordFields) {
        SqlType sqlType = field.getSqlType();
        if (sqlType != null) {
            switch (sqlType.getTypeName()) {
                case "CHAR": 
                case "BPCHAR": 
                case "CHARACTER": {
                    recordFields.append(String.format(BalSyntaxConstants.SQL_CHAR_MAPPING_ANNOTATION, sqlType.getMaxLength()));
                    break;
                }
                case "VARCHAR": {
                    if (191 == sqlType.getMaxLength()) break;
                    recordFields.append(String.format(BalSyntaxConstants.SQL_VARCHAR_MAPPING_ANNOTATION, sqlType.getMaxLength()));
                    break;
                }
                case "DECIMAL": 
                case "NUMERIC": {
                    int precision = 65;
                    int scale = 30;
                    if (sqlType.getDatastore().equals("sqlserver")) {
                        precision = 38;
                    }
                    if (sqlType.getNumericPrecision() == precision && sqlType.getNumericScale() == scale) break;
                    recordFields.append(String.format(BalSyntaxConstants.SQL_DECIMAL_MAPPING_ANNOTATION, sqlType.getNumericPrecision(), sqlType.getNumericScale()));
                    break;
                }
            }
        }
    }

    private static boolean isDbTypeMappingRequired(EntityField field) {
        SqlType sqlType = field.getSqlType();
        if (sqlType != null) {
            switch (sqlType.getTypeName()) {
                case "CHAR": 
                case "BPCHAR": 
                case "CHARACTER": {
                    return true;
                }
                case "VARCHAR": {
                    return 191 != sqlType.getMaxLength();
                }
                case "DECIMAL": 
                case "NUMERIC": {
                    int precision = 65;
                    int scale = 30;
                    if (sqlType.getDatastore().equals("sqlserver")) {
                        precision = 38;
                    }
                    return sqlType.getNumericPrecision() != precision || sqlType.getNumericScale() != scale;
                }
            }
            return false;
        }
        return false;
    }

    private static void addDbMappingAnnotationToField(EntityField field, StringBuilder recordFields) {
        if (field.shouldColumnMappingGenerated()) {
            recordFields.append(String.format(BalSyntaxConstants.SQL_DB_NAME_ANNOTATION, field.getFieldColumnName()));
            recordFields.append(BalSyntaxConstants.NEWLINE);
        }
    }

    private static void addDbMappingAnnotationToEntity(Entity entity, StringBuilder recordString) {
        if (entity.shouldTableMappingGenerated()) {
            recordString.append(String.format(BalSyntaxConstants.SQL_DB_NAME_ANNOTATION, entity.getTableName()));
            recordString.append(BalSyntaxConstants.NEWLINE);
        }
    }

    private static ModuleMemberDeclarationNode createEnumDeclaration(Enum enumValue, boolean includeAutogeneratedComment, String moduleName) {
        StringBuilder enumMembers = new StringBuilder();
        for (int i = 0; i < enumValue.getMembers().size(); ++i) {
            EnumMember member = enumValue.getMembers().get(i);
            enumMembers.append(member.getIdentifier());
            if (member.getValue() != null) {
                enumMembers.append(" ");
                enumMembers.append("=");
                enumMembers.append(" ");
                enumMembers.append("\"");
                enumMembers.append(member.getValue());
                enumMembers.append("\"");
            }
            if (i != enumValue.getMembers().size() - 1) {
                enumMembers.append(", ");
            }
            enumMembers.append(System.lineSeparator());
        }
        if (includeAutogeneratedComment) {
            String commentBuilder = "// AUTO-GENERATED FILE. DO NOT MODIFY." + System.lineSeparator() + System.lineSeparator() + String.format("// This file is an auto-generated file by Ballerina persistence layer for %s.", moduleName) + System.lineSeparator() + "// It should not be modified by hand." + System.lineSeparator() + System.lineSeparator() + "public enum %s { %s }";
            return NodeParser.parseModuleMemberDeclaration((String)String.format(commentBuilder, enumValue.getEnumName().trim(), enumMembers));
        }
        return NodeParser.parseModuleMemberDeclaration((String)String.format("public enum %s { %s }", enumValue.getEnumName().trim(), enumMembers));
    }

    private static ModuleMemberDeclarationNode createEntityRecordOptionalized(Entity entity) {
        StringBuilder recordFields = new StringBuilder();
        for (EntityField field : entity.getFields()) {
            if (field.getRelation() != null) {
                BalSyntaxUtils.addConstraintsAnnotationForForeignKey(field, recordFields);
                if (!field.getRelation().isOwner()) continue;
                for (Relation.Key key : field.getRelation().getKeyColumns()) {
                    recordFields.append(key.getType());
                    recordFields.append(" ");
                    recordFields.append(key.getField());
                    recordFields.append("?");
                    recordFields.append(";");
                    recordFields.append(" ");
                }
                continue;
            }
            BalSyntaxUtils.addConstrainAnnotationToField(field, recordFields);
            recordFields.append(field.isOptionalType() ? field.getFieldType() + (field.isArrayType() ? "[]" : "") + "?" : field.getFieldType() + (field.isArrayType() ? "[]" : ""));
            recordFields.append(" ");
            recordFields.append(field.getFieldName());
            recordFields.append("?");
            recordFields.append(";");
            recordFields.append(" ");
        }
        return NodeParser.parseModuleMemberDeclaration((String)String.format("public type %sOptionalized record {| %s |};", entity.getEntityName().trim(), recordFields));
    }

    private static void addConstraintsAnnotationForForeignKey(EntityField field, StringBuilder recordFields) {
        Relation relation = field.getRelation();
        List<String> references = relation.getReferences();
        block0: for (EntityField assocField : relation.getAssocEntity().getFields()) {
            for (String reference : references) {
                if (!assocField.getFieldName().equals(reference)) continue;
                String params = BalSyntaxUtils.getConstraintField(assocField);
                if (params == null) continue block0;
                recordFields.append(String.format(BalSyntaxConstants.CONSTRAINT_ANNOTATION, params));
                continue block0;
            }
        }
    }

    private static void addConstrainAnnotationToField(EntityField field, StringBuilder recordFields) {
        String params = BalSyntaxUtils.getConstraintField(field);
        if (params != null) {
            recordFields.append(String.format(BalSyntaxConstants.CONSTRAINT_ANNOTATION, params));
        }
    }

    public static String readStringValueFromAnnotation(AnnotationUtilRecord annotationMethodRecord) {
        for (AnnotationNode annotationNode : annotationMethodRecord.annotationNodes) {
            Optional annotationFieldNode;
            String annotationName = annotationNode.annotReference().toSourceCode().trim();
            if (!annotationName.equals(annotationMethodRecord.annotation) || !(annotationFieldNode = annotationNode.annotValue()).isPresent()) continue;
            for (MappingFieldNode mappingFieldNode : ((MappingConstructorExpressionNode)annotationFieldNode.get()).fields()) {
                SpecificFieldNode specificFieldNode = (SpecificFieldNode)mappingFieldNode;
                String fieldName = specificFieldNode.fieldName().toSourceCode().trim();
                if (!fieldName.equals(annotationMethodRecord.field)) {
                    return "";
                }
                Optional valueExpr = specificFieldNode.valueExpr();
                if (!valueExpr.isPresent()) continue;
                return ((ExpressionNode)valueExpr.get()).toSourceCode().trim().replace("\"", "").trim();
            }
        }
        return "";
    }

    public static boolean isAnnotationPresent(List<AnnotationNode> annotationNodes, String annotation) {
        for (AnnotationNode annotationNode : annotationNodes) {
            String annotationName = annotationNode.annotReference().toSourceCode().trim();
            if (!annotationName.equals(annotation)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotationFieldStringType(AnnotationUtilRecord annotationMethodRecord) {
        for (AnnotationNode annotationNode : annotationMethodRecord.annotationNodes) {
            Optional annotationFieldNode;
            String annotationName = annotationNode.annotReference().toSourceCode().trim();
            if (!annotationName.equals(annotationMethodRecord.annotation) || !(annotationFieldNode = annotationNode.annotValue()).isPresent()) continue;
            for (MappingFieldNode mappingFieldNode : ((MappingConstructorExpressionNode)annotationFieldNode.get()).fields()) {
                SpecificFieldNode specificFieldNode = (SpecificFieldNode)mappingFieldNode;
                String fieldName = specificFieldNode.fieldName().toSourceCode().trim();
                if (!fieldName.equals(annotationMethodRecord.field)) {
                    return false;
                }
                Optional valueExpr = specificFieldNode.valueExpr();
                if (!valueExpr.isPresent()) continue;
                return ((ExpressionNode)valueExpr.get()).toSourceCode().trim().startsWith("\"") && ((ExpressionNode)valueExpr.get()).toSourceCode().trim().endsWith("\"");
            }
        }
        return false;
    }

    public static boolean isAnnotationFieldArrayType(AnnotationUtilRecord annotationMethodRecord) {
        for (AnnotationNode annotationNode : annotationMethodRecord.annotationNodes) {
            Optional annotationFieldNode;
            String annotationName = annotationNode.annotReference().toSourceCode().trim();
            if (!annotationName.equals(annotationMethodRecord.annotation) || !(annotationFieldNode = annotationNode.annotValue()).isPresent()) continue;
            for (MappingFieldNode mappingFieldNode : ((MappingConstructorExpressionNode)annotationFieldNode.get()).fields()) {
                SpecificFieldNode specificFieldNode = (SpecificFieldNode)mappingFieldNode;
                String fieldName = specificFieldNode.fieldName().toSourceCode().trim();
                if (!fieldName.equals(annotationMethodRecord.field)) {
                    return false;
                }
                Optional valueExpr = specificFieldNode.valueExpr();
                if (!valueExpr.isPresent()) continue;
                return ((ExpressionNode)valueExpr.get()).toSourceCode().trim().startsWith("[") && ((ExpressionNode)valueExpr.get()).toSourceCode().trim().endsWith("]");
            }
        }
        return false;
    }

    public static List<String> readStringArrayValueFromAnnotation(AnnotationUtilRecord annotationUtilRecord) {
        for (AnnotationNode annotationNode : annotationUtilRecord.annotationNodes) {
            Optional annotationFieldNode;
            String annotationName = annotationNode.annotReference().toSourceCode().trim();
            if (!annotationName.equals(annotationUtilRecord.annotation) || !(annotationFieldNode = annotationNode.annotValue()).isPresent()) continue;
            for (MappingFieldNode mappingFieldNode : ((MappingConstructorExpressionNode)annotationFieldNode.get()).fields()) {
                SpecificFieldNode specificFieldNode = (SpecificFieldNode)mappingFieldNode;
                String fieldName = specificFieldNode.fieldName().toSourceCode().trim();
                if (!fieldName.equals(annotationUtilRecord.field)) {
                    return Collections.emptyList();
                }
                Optional valueExpr = specificFieldNode.valueExpr();
                if (!valueExpr.isPresent()) continue;
                String strings = ((ExpressionNode)valueExpr.get()).toSourceCode().trim().replace("[", "").replace("]", "");
                if (strings.trim().isEmpty()) {
                    return Collections.emptyList();
                }
                return Stream.of(strings.replace("\"", "").split(",")).map(String::trim).toList();
            }
        }
        return Collections.emptyList();
    }

    private static String getConstraintField(EntityField field) {
        for (AnnotationNode annotationNode : field.getAnnotation()) {
            Optional annotationFieldNode;
            String annotationName = annotationNode.annotReference().toSourceCode().trim();
            if (!annotationName.equals("constraint:String") || !(annotationFieldNode = annotationNode.annotValue()).isPresent()) continue;
            for (MappingFieldNode mappingFieldNode : ((MappingConstructorExpressionNode)annotationFieldNode.get()).fields()) {
                Optional valueExpr;
                SpecificFieldNode specificFieldNode = (SpecificFieldNode)mappingFieldNode;
                String fieldName = specificFieldNode.fieldName().toSourceCode().trim();
                if (fieldName.equals("maxLength")) {
                    valueExpr = specificFieldNode.valueExpr();
                    if (!valueExpr.isPresent()) continue;
                    return "maxLength:" + ((ExpressionNode)valueExpr.get()).toSourceCode().trim();
                }
                if (!fieldName.equals("length") || !(valueExpr = specificFieldNode.valueExpr()).isPresent()) continue;
                return "length:" + ((ExpressionNode)valueExpr.get()).toSourceCode().trim();
            }
        }
        return null;
    }

    private static ModuleMemberDeclarationNode createEntityRecordWithRelation(Entity entity) {
        StringBuilder recordFields = new StringBuilder();
        recordFields.append(String.format("*%sOptionalized;", entity.getEntityName()));
        for (EntityField field : entity.getFields()) {
            if (field.getRelation() == null) continue;
            recordFields.append(String.format("%sOptionalized", field.getFieldType()));
            if (field.isArrayType()) {
                recordFields.append("[]");
            }
            recordFields.append(" ");
            recordFields.append(field.getFieldName());
            recordFields.append("?");
            recordFields.append(";");
            recordFields.append(" ");
        }
        return NodeParser.parseModuleMemberDeclaration((String)String.format("public type %sWithRelations record {| %s |};", entity.getEntityName().trim(), recordFields));
    }

    private static ModuleMemberDeclarationNode createEntityTargetType(Entity entity, boolean hasRelations) {
        return NodeParser.parseModuleMemberDeclaration((String)String.format("public type %sTargetType typedesc<%s>;", entity.getEntityName().trim(), entity.getEntityName().trim() + (hasRelations ? "WithRelations" : "Optionalized")));
    }

    private static ModuleMemberDeclarationNode createUpdateRecord(Entity entity) {
        StringBuilder recordFields = new StringBuilder();
        for (EntityField field : entity.getFields()) {
            if (!entity.getKeys().stream().noneMatch(key -> key == field)) continue;
            if (field.getRelation() != null) {
                if (!field.getRelation().isOwner()) continue;
                for (Relation.Key key2 : field.getRelation().getKeyColumns()) {
                    BalSyntaxUtils.addConstraintsAnnotationForForeignKey(field, recordFields);
                    recordFields.append(key2.getType());
                    recordFields.append(" ");
                    recordFields.append(key2.getField());
                    recordFields.append("?");
                    recordFields.append(";");
                    recordFields.append(" ");
                }
                continue;
            }
            BalSyntaxUtils.addConstrainAnnotationToField(field, recordFields);
            recordFields.append(field.isOptionalType() ? field.getFieldType() + (field.isArrayType() ? "[]" : "") + "?" : field.getFieldType() + (field.isArrayType() ? "[]" : ""));
            recordFields.append(" ");
            recordFields.append(field.getFieldName());
            recordFields.append("?");
            recordFields.append(";");
            recordFields.append(" ");
        }
        return NodeParser.parseModuleMemberDeclaration((String)String.format("public type %sUpdate record {| %s |};", entity.getEntityName().trim(), recordFields));
    }

    private static ModuleMemberDeclarationNode createInsertRecord(Entity entity, String datastore) {
        boolean isAutoGenerated = entity.getFields().stream().anyMatch(EntityField::isDbGenerated);
        if (!isAutoGenerated || PersistToolsConstants.SUPPORTED_NOSQL_DB_PROVIDERS.contains(datastore)) {
            return NodeParser.parseModuleMemberDeclaration((String)String.format("public type %sInsert %s;", entity.getEntityName(), entity.getEntityName()));
        }
        StringBuilder recordFields = new StringBuilder();
        for (EntityField field : entity.getFields()) {
            if (entity.getKeys().stream().anyMatch(key -> key == field)) continue;
            if (field.getRelation() != null) {
                if (!field.getRelation().isOwner()) continue;
                for (Relation.Key key2 : field.getRelation().getKeyColumns()) {
                    recordFields.append(key2.getType());
                    recordFields.append(" ");
                    recordFields.append(key2.getField());
                    recordFields.append(";");
                    recordFields.append(" ");
                }
                continue;
            }
            BalSyntaxUtils.addFieldString(recordFields, field);
        }
        StringBuilder recordString = new StringBuilder();
        recordString.append(String.format("public type %sInsert record {| %s |};", entity.getEntityName().trim(), recordFields));
        return NodeParser.parseModuleMemberDeclaration((String)recordString.toString());
    }

    private static void addFieldString(StringBuilder recordFields, EntityField field) {
        recordFields.append(field.getFieldType());
        recordFields.append(field.isArrayType() ? "[]" : "");
        recordFields.append(field.isOptionalType() ? "?" : "");
        recordFields.append(" ");
        recordFields.append(field.getFieldName());
        recordFields.append(field.isOptionalField() ? "?" : "");
        recordFields.append(";");
        recordFields.append(" ");
    }

    public static ImportDeclarationNode getImportDeclarationNodeWithAutogeneratedComment(String moduleName, MinutiaeList commentMinutiaeList) {
        IdentifierToken orgNameToken = AbstractNodeFactory.createIdentifierToken((String)"ballerina");
        ImportOrgNameNode importOrgNameNode = NodeFactory.createImportOrgNameNode((Token)orgNameToken, (Token)SyntaxTokenConstants.SYNTAX_TREE_SLASH);
        IdentifierToken moduleNameToken = AbstractNodeFactory.createIdentifierToken((String)moduleName);
        SeparatedNodeList moduleNodeList = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{moduleNameToken});
        Token importToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.IMPORT_KEYWORD, (MinutiaeList)commentMinutiaeList, (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{AbstractNodeFactory.createWhitespaceMinutiae((String)" ")}));
        return NodeFactory.createImportDeclarationNode((Token)importToken, (ImportOrgNameNode)importOrgNameNode, (SeparatedNodeList)moduleNodeList, null, (Token)SyntaxTokenConstants.SYNTAX_TREE_SEMICOLON);
    }

    public static String getStringWithUnderScore(String entityName) {
        String[] splitedStrings;
        StringBuilder outputString = new StringBuilder();
        for (String splitedString : splitedStrings = BalSyntaxUtils.stripEscapeCharacter(entityName).split("(?=\\p{Upper})")) {
            if (outputString.length() != 0) {
                outputString.append("_");
            }
            outputString.append(splitedString.toUpperCase(Locale.ENGLISH));
        }
        if (entityName.startsWith("'")) {
            return "'" + String.valueOf(outputString);
        }
        return outputString.toString();
    }

    public static String stripEscapeCharacter(String fieldName) {
        return fieldName.startsWith("'") ? fieldName.substring(1) : fieldName;
    }

    public static ImportDeclarationNode getImportDeclarationNode(String orgName, String moduleName, ImportPrefixNode prefix) {
        IdentifierToken orgNameToken = AbstractNodeFactory.createIdentifierToken((String)orgName);
        ImportOrgNameNode importOrgNameNode = NodeFactory.createImportOrgNameNode((Token)orgNameToken, (Token)SyntaxTokenConstants.SYNTAX_TREE_SLASH);
        IdentifierToken moduleNameToken = AbstractNodeFactory.createIdentifierToken((String)moduleName);
        SeparatedNodeList moduleNodeList = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{moduleNameToken});
        return NodeFactory.createImportDeclarationNode((Token)SyntaxTokenConstants.SYNTAX_TREE_KEYWORD_IMPORT, (ImportOrgNameNode)importOrgNameNode, (SeparatedNodeList)moduleNodeList, (ImportPrefixNode)prefix, (Token)SyntaxTokenConstants.SYNTAX_TREE_SEMICOLON);
    }

    public static String getPrimaryKeys(Entity entity, boolean addDoubleQuotes) {
        StringBuilder keyFields = new StringBuilder();
        for (EntityField key : entity.getKeys()) {
            if (keyFields.length() != 0) {
                keyFields.append(", ");
            }
            if (addDoubleQuotes) {
                keyFields.append("\"").append(BalSyntaxUtils.stripEscapeCharacter(key.getFieldName())).append("\"");
                continue;
            }
            keyFields.append(BalSyntaxUtils.stripEscapeCharacter(key.getFieldName()));
        }
        return keyFields.toString();
    }

    public record AnnotationUtilRecord(List<AnnotationNode> annotationNodes, String annotation, String field) {
        public AnnotationUtilRecord(List<AnnotationNode> annotationNodes, String annotation, String field) {
            this.annotationNodes = Collections.unmodifiableList(annotationNodes);
            this.annotation = annotation;
            this.field = field;
        }
    }
}

