/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.nodegenerator.syntax.utils;

import io.ballerina.persist.BalException;
import io.ballerina.persist.PersistToolsConstants;
import io.ballerina.persist.configuration.DatabaseConfiguration;
import io.ballerina.persist.configuration.PersistConfiguration;
import io.ballerina.persist.utils.BalProjectUtils;
import io.ballerina.toml.syntax.tree.AbstractNodeFactory;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.IdentifierToken;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeList;
import io.ballerina.toml.syntax.tree.SyntaxTree;
import io.ballerina.toml.syntax.tree.TableArrayNode;
import io.ballerina.toml.syntax.tree.TableNode;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.validator.SampleNodeGenerator;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Objects;
import java.util.Properties;

public class TomlSyntaxUtils {
    public static final String REGEX_TOML_TABLE_NAME_SPLITTER = "\\.";

    private TomlSyntaxUtils() {
    }

    public static PersistConfiguration readDatabaseConfigurations(Path configPath) throws BalException {
        try {
            TextDocument configDocument = TextDocuments.from((String)Files.readString(configPath));
            SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)configDocument);
            DocumentNode rootNote = (DocumentNode)syntaxTree.rootNode();
            NodeList nodeList = rootNote.members();
            PersistConfiguration configuration = new PersistConfiguration();
            boolean dbConfigExists = false;
            for (DocumentMemberDeclarationNode member : nodeList) {
                TableNode node;
                String tableName;
                if (!(member instanceof TableNode) || !(tableName = (node = (TableNode)member).identifier().toSourceCode().trim()).startsWith("persist.model.storage")) continue;
                String[] nameParts = tableName.split(REGEX_TOML_TABLE_NAME_SPLITTER);
                if (nameParts.length > 3 && PersistToolsConstants.SUPPORTED_DB_PROVIDERS.contains(nameParts[3])) {
                    configuration.setProvider(nameParts[3]);
                    dbConfigExists = true;
                    DatabaseConfiguration databaseConfiguration = new DatabaseConfiguration("model", (NodeList<KeyValueNode>)node.fields());
                    configuration.setDbConfig(databaseConfiguration);
                    continue;
                }
                throw new BalException("database is not configured properly. give correct database configurations with database name to create tables.");
            }
            if (!dbConfigExists) {
                throw new BalException("the persist tool config doesn't exist in the Ballerina.toml. add [persist.model.storage.<provider>] table with db configurations.");
            }
            return configuration;
        }
        catch (IOException e) {
            throw new BalException("error while reading configurations. " + e.getMessage());
        }
    }

    public static HashMap<String, String> readBallerinaTomlConfig(Path configPath) throws BalException {
        try {
            TextDocument configDocument = TextDocuments.from((String)Files.readString(configPath));
            SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)configDocument);
            DocumentNode rootNote = (DocumentNode)syntaxTree.rootNode();
            NodeList nodeList = rootNote.members();
            boolean dbConfigExists = false;
            HashMap<String, String> persistConfig = new HashMap<String, String>();
            for (DocumentMemberDeclarationNode member : nodeList) {
                TableArrayNode node;
                String tableName;
                if (!(member instanceof TableArrayNode) || !(tableName = (node = (TableArrayNode)member).identifier().toSourceCode().trim()).equals("tool.persist")) continue;
                dbConfigExists = true;
                for (KeyValueNode field : node.fields()) {
                    persistConfig.put(field.identifier().toSourceCode().trim(), field.value().toSourceCode().trim().replaceAll("\"", ""));
                }
            }
            if (!dbConfigExists) {
                throw new BalException("the persist config doesn't exist in the Ballerina.toml. add [tool.persist] table with persist configurations.");
            }
            if (!persistConfig.containsKey("targetModule") || !persistConfig.containsKey("options.datastore")) {
                throw new BalException("the persist configurations does not exist under [persist] table.");
            }
            return persistConfig;
        }
        catch (IOException e) {
            throw new BalException("error while reading persist configurations. " + e.getMessage());
        }
    }

    public static String readPackageName(String sourcePath) throws BalException {
        try {
            TextDocument configDocument = TextDocuments.from((String)Files.readString(Paths.get(sourcePath, "Ballerina.toml")));
            SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)configDocument);
            DocumentNode rootNote = (DocumentNode)syntaxTree.rootNode();
            NodeList nodeList = rootNote.members();
            for (DocumentMemberDeclarationNode member : nodeList) {
                TableNode node;
                String tableName;
                if (!(member instanceof TableNode) || !(tableName = (node = (TableNode)member).identifier().toSourceCode().trim()).equals("package")) continue;
                NodeList fields = node.fields();
                for (KeyValueNode field : fields) {
                    if (!field.identifier().toSourceCode().trim().equals("name")) continue;
                    return field.value().toSourceCode().trim().replaceAll("\"", "");
                }
            }
            throw new BalException("ERROR: couldn't find the package name in Ballerina.toml file.");
        }
        catch (IOException e) {
            throw new BalException("ERROR: couldn't read the Ballerina.toml file. " + e.getMessage());
        }
    }

    public static ConfigDeclaration getConfigDeclaration(Path configPath, NativeDependency dependency) throws IOException {
        Path fileNamePath = configPath.getFileName();
        TextDocument configDocument = TextDocuments.from((String)Files.readString(configPath));
        NodeList moduleMembers = AbstractNodeFactory.createEmptyNodeList();
        TableArrayNode dependencyNode = null;
        TableArrayNode testDependencyNode = null;
        boolean persistConfigExists = false;
        if (Objects.nonNull(fileNamePath)) {
            SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)configDocument, (String)fileNamePath.toString());
            DocumentNode rootNote = (DocumentNode)syntaxTree.rootNode();
            NodeList nodeList = rootNote.members();
            for (DocumentMemberDeclarationNode member : nodeList) {
                if (member instanceof TableArrayNode) {
                    TableArrayNode node = (TableArrayNode)member;
                    if (node.identifier().toSourceCode().trim().equals("tool.persist")) {
                        persistConfigExists = true;
                    } else if (node.identifier().toSourceCode().trim().equals("platform.java21.dependency")) {
                        NodeList fields = ((TableArrayNode)member).fields();
                        for (KeyValueNode field : fields) {
                            String value = field.value().toSourceCode().trim();
                            if (field.identifier().toSourceCode().trim().equals("artifactId")) {
                                if (value.substring(1, value.length() - 1).equals(String.format("%s-native", dependency.artifactId()))) {
                                    dependencyNode = node;
                                }
                                if (dependency.testArtifactId() != null && value.substring(1, value.length() - 1).equals(String.format("%s-native", dependency.testArtifactId()))) {
                                    testDependencyNode = node;
                                }
                            }
                            if (dependencyNode == null || dependency.testArtifactId() != null != (testDependencyNode != null)) continue;
                            break;
                        }
                    }
                    moduleMembers = moduleMembers.add((Node)member);
                    continue;
                }
                moduleMembers = moduleMembers.add((Node)member);
            }
        }
        return new ConfigDeclaration((NodeList<DocumentMemberDeclarationNode>)moduleMembers, dependencyNode, testDependencyNode, persistConfigExists);
    }

    public static NativeDependency getDependencyConfig(String datasource, String testDatasource) {
        Object artifactId = "persist." + datasource;
        if (datasource.equals("mysql") || datasource.equals("mssql") || datasource.equals("postgresql") || datasource.equals("h2")) {
            artifactId = "persist.sql";
        }
        Object testArtifactId = null;
        if (Objects.nonNull(testDatasource)) {
            testArtifactId = "h2".equals(testDatasource) ? "persist.sql" : "persist." + testDatasource;
        }
        return new NativeDependency((String)artifactId, (String)testArtifactId);
    }

    public static void validateDependency(TableArrayNode node, String datasource) throws BalException {
        NodeList fields = node.fields();
        for (KeyValueNode field : fields) {
            String value = field.value().toSourceCode().trim().replaceAll("\"", "");
            if (!field.identifier().toSourceCode().trim().equals("version") || value.equals(TomlSyntaxUtils.getPersistVersion(datasource))) continue;
            throw new BalException("the 'Ballerina.toml' file is already updated with the Persist client native dependency but the version is different from the current version. Please remove the existing dependency and try again.");
        }
    }

    public static NodeList<DocumentMemberDeclarationNode> populatePersistDependency(NodeList<DocumentMemberDeclarationNode> moduleMembers, String artifactID, String datasource) throws BalException {
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"groupId", (String)(datasource.equals("redis") ? "io.ballerina.lib" : "io.ballerina.stdlib"), null));
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"artifactId", (String)String.format("%s-native", artifactID), null));
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"version", (String)TomlSyntaxUtils.getPersistVersion(datasource), null));
        return moduleMembers;
    }

    public static String populateNativeDependencyConfig(String datastore, String testDatastore, ConfigDeclaration declaration, NativeDependency dependency) throws BalException {
        NodeList<DocumentMemberDeclarationNode> moduleMembers = declaration.moduleMembers();
        if (!moduleMembers.isEmpty()) {
            moduleMembers = BalProjectUtils.addNewLine(moduleMembers, 1);
            if (declaration.dependencyNode() == null) {
                moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createTableArray((String)"platform.java21.dependency", null));
                moduleMembers = TomlSyntaxUtils.populatePersistDependency(moduleMembers, dependency.artifactId(), datastore);
            } else {
                TomlSyntaxUtils.validateDependency(declaration.dependencyNode(), datastore);
            }
            if (dependency.testArtifactId() != null && !dependency.testArtifactId().equals(dependency.artifactId())) {
                if (declaration.testDependencyNode() == null) {
                    moduleMembers = BalProjectUtils.addNewLine(moduleMembers, 1);
                    moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createTableArray((String)"platform.java21.dependency", null));
                    moduleMembers = TomlSyntaxUtils.populatePersistDependency(moduleMembers, dependency.testArtifactId(), testDatastore);
                } else {
                    TomlSyntaxUtils.validateDependency(declaration.testDependencyNode(), testDatastore);
                }
            }
        }
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        DocumentNode documentNode = NodeFactory.createDocumentNode(moduleMembers, (Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)documentNode.toSourceCode());
        return SyntaxTree.from((TextDocument)textDocument).toSourceCode();
    }

    private static String getPersistVersion(String datasource) throws BalException {
        String string;
        block23: {
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            InputStream inputStream = classloader.getResourceAsStream("version.properties");
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                string = switch (datasource) {
                    case "mysql", "mssql", "postgresql", "h2" -> properties.get("persistSqlVersion").toString();
                    case "inmemory" -> properties.get("persistInMemoryVersion").toString();
                    case "googlesheets" -> properties.get("persistGoogleSheetsVersion").toString();
                    case "redis" -> properties.get("persistRedisVersion").toString();
                    default -> throw new BalException("ERROR: invalid datasource: " + datasource);
                };
                if (inputStream == null) break block23;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new BalException("ERROR: couldn't read the version.properties file. " + e.getMessage());
                }
            }
            inputStream.close();
        }
        return string;
    }

    public record NativeDependency(String artifactId, String testArtifactId) {
    }

    public record ConfigDeclaration(NodeList<DocumentMemberDeclarationNode> moduleMembers, TableArrayNode dependencyNode, TableArrayNode testDependencyNode, boolean persistConfigExists) {
    }
}

