/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.utils;

import io.ballerina.persist.BalException;
import io.ballerina.persist.configuration.PersistConfiguration;
import io.ballerina.persist.utils.JdbcDriverLoader;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.Project;
import io.ballerina.projects.ResolvedPackageDependency;
import java.io.Console;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;

public class DatabaseConnector {
    private final String jdbcUrlWithDatabaseFormat;
    private final String driverClass;

    public DatabaseConnector(String jdbcUrlWithDatabaseFormat, String driverClass) {
        this.driverClass = driverClass;
        this.jdbcUrlWithDatabaseFormat = jdbcUrlWithDatabaseFormat;
    }

    public Connection getConnection(Driver driver, PersistConfiguration persistConfigurations, boolean withDB) throws SQLException {
        String host = persistConfigurations.getDbConfig().getHost();
        int port = persistConfigurations.getDbConfig().getPort();
        String user = persistConfigurations.getDbConfig().getUsername();
        String password = persistConfigurations.getDbConfig().getPassword();
        String database = persistConfigurations.getDbConfig().getDatabase();
        String provider = persistConfigurations.getProvider();
        String url = withDB ? String.format(this.jdbcUrlWithDatabaseFormat, provider, host, port, database) : String.format("jdbc:%s://%s:%s/", provider, host, port);
        Properties props = new Properties();
        if (user != null) {
            props.put("user", user);
        }
        if (password != null) {
            props.put("password", password);
        }
        return driver.connect(url, props);
    }

    public Driver getJdbcDriver(JdbcDriverLoader driverLoader) throws BalException {
        Driver driver;
        try {
            Class<?> drvClass = driverLoader.loadClass(this.driverClass);
            driver = (Driver)drvClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new BalException("required database driver class not found. " + e.getMessage());
        }
        catch (InstantiationException | InvocationTargetException e) {
            throw new BalException("the database driver instantiation is failed. " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new BalException("access denied while trying to instantiation the database driver. " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new BalException("method not found while trying to instantiate jdbc driver. " + e.getMessage());
        }
        return driver;
    }

    public JdbcDriverLoader getJdbcDriverLoader(Project balProject) throws BalException {
        return this.getJdbcDriverLoaderPrivate(balProject);
    }

    private JdbcDriverLoader getJdbcDriverLoaderPrivate(Project balProject) throws BalException {
        JdbcDriverLoader driverLoader = null;
        Path driverDirectoryPath = this.getDriverPath(balProject).getParent();
        if (Objects.nonNull(driverDirectoryPath)) {
            Path driverPath = driverDirectoryPath.toAbsolutePath();
            URL[] urls = new URL[]{};
            try {
                driverLoader = new JdbcDriverLoader(urls, driverPath);
            }
            catch (IOException e) {
                throw new BalException("could not load the driver from the driver path. " + e.getMessage());
            }
        }
        return driverLoader;
    }

    private Path getDriverPath(Project balProject) throws BalException {
        Optional<ResolvedPackageDependency> postgresqlDriverDependency;
        Optional<ResolvedPackageDependency> mssqlDriverDependency;
        ResolvedPackageDependency root;
        DependencyGraph resolvedPackageDependencyDependencyGraph = balProject.currentPackage().getResolution().dependencyGraph();
        Optional<ResolvedPackageDependency> mysqlDriverDependency = resolvedPackageDependencyDependencyGraph.getDirectDependencies((Object)(root = (ResolvedPackageDependency)resolvedPackageDependencyDependencyGraph.getRoot())).stream().filter(resolvedPackageDependency -> resolvedPackageDependency.packageInstance().descriptor().toString().contains("ballerinax/mysql.driver")).findFirst();
        if (mysqlDriverDependency.isPresent()) {
            Package mysqlDriverPackage = mysqlDriverDependency.get().packageInstance();
            List<Map<String, Object>> dependencies = DatabaseConnector.getDependencies(mysqlDriverPackage);
            for (Map<String, Object> dependency : dependencies) {
                if (!dependency.get("path").toString().contains("mysql-connector")) continue;
                String relativeLibPath = dependency.get("path").toString();
                return mysqlDriverPackage.project().sourceRoot().resolve(relativeLibPath);
            }
        }
        if ((mssqlDriverDependency = resolvedPackageDependencyDependencyGraph.getDirectDependencies((Object)root).stream().filter(resolvedPackageDependency -> resolvedPackageDependency.packageInstance().descriptor().toString().contains("ballerinax/mssql.driver")).findFirst()).isPresent()) {
            Package mssqlDriverPackage = mssqlDriverDependency.get().packageInstance();
            List<Map<String, Object>> dependencies = DatabaseConnector.getDependencies(mssqlDriverPackage);
            for (Map map : dependencies) {
                if (!map.get("path").toString().contains("mssql-jdbc")) continue;
                String relativeLibPath = map.get("path").toString();
                return mssqlDriverPackage.project().sourceRoot().resolve(relativeLibPath);
            }
        }
        if ((postgresqlDriverDependency = resolvedPackageDependencyDependencyGraph.getDirectDependencies((Object)root).stream().filter(resolvedPackageDependency -> resolvedPackageDependency.packageInstance().descriptor().toString().contains("ballerinax/postgresql.driver")).findFirst()).isPresent()) {
            Package postgresqlDriverPackage = postgresqlDriverDependency.get().packageInstance();
            List<Map<String, Object>> dependencies = DatabaseConnector.getDependencies(postgresqlDriverPackage);
            for (Map<String, Object> dependency : dependencies) {
                if (!dependency.get("path").toString().contains("postgresql")) continue;
                String relativeLibPath = dependency.get("path").toString();
                return postgresqlDriverPackage.project().sourceRoot().resolve(relativeLibPath);
            }
        }
        throw new BalException("failed to retrieve driver path in the local cache.");
    }

    private static List<Map<String, Object>> getDependencies(Package driverPackage) {
        ArrayList<Map<String, Object>> dependencies = new ArrayList<Map<String, Object>>();
        for (JvmTarget jvmTarget : JvmTarget.values()) {
            PackageManifest.Platform platform = driverPackage.manifest().platform(jvmTarget.code());
            if (platform == null) continue;
            dependencies.addAll(platform.dependencies());
        }
        return dependencies;
    }

    public static String readDatabasePassword(Scanner scanner, PrintStream errStream) {
        String password;
        Console console = System.console();
        if (console == null) {
            errStream.println("WARNING console could not be detected. falling back to standard input.");
            errStream.print("Database Password: ");
            password = scanner.nextLine();
        } else {
            password = new String(console.readPassword("Database Password: ", new Object[0]));
        }
        return password;
    }
}

