/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.validator;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.validator.HeaderValidator;
import io.ballerina.openapi.validator.ParameterValidator;
import io.ballerina.openapi.validator.RequestBodyValidator;
import io.ballerina.openapi.validator.ReturnTypeValidator;
import io.ballerina.openapi.validator.Validator;
import io.ballerina.openapi.validator.ValidatorContext;
import io.ballerina.openapi.validator.ValidatorUtils;
import io.ballerina.openapi.validator.error.CompilationError;
import io.ballerina.openapi.validator.model.Filter;
import io.ballerina.openapi.validator.model.OpenAPIPathSummary;
import io.ballerina.openapi.validator.model.ResourceMethod;
import io.ballerina.openapi.validator.model.ResourcePathSummary;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServiceValidator
implements Validator {
    private Filter filter;
    private SyntaxNodeAnalysisContext context;
    private OpenAPI openAPI;

    public void initialize(SyntaxNodeAnalysisContext context, OpenAPI openAPI, Filter filter) {
        this.context = context;
        this.openAPI = openAPI;
        this.filter = filter;
    }

    public OpenAPI getOpenAPI() {
        return this.openAPI;
    }

    @Override
    public void validate() {
        ServiceDeclarationNode serviceNode = (ServiceDeclarationNode)this.context.node();
        List<OpenAPIPathSummary> openAPIPathSummaries = ValidatorUtils.summarizeOpenAPI(this.openAPI, this.context, this.filter);
        NodeList members = serviceNode.members();
        ArrayList<FunctionDefinitionNode> resourceFunctions = new ArrayList<FunctionDefinitionNode>();
        for (Node next : members) {
            if (!(next instanceof FunctionDefinitionNode)) continue;
            resourceFunctions.add((FunctionDefinitionNode)next);
        }
        Map<String, ResourcePathSummary> resourcePathMap = ValidatorUtils.summarizeResources(resourceFunctions, this.context);
        List<OpenAPIPathSummary> updatedOASPaths = this.validateMissingBalResources(openAPIPathSummaries, resourcePathMap);
        Map<String, ResourcePathSummary> updatedResourcePath = this.validateUndefinedBalResources(openAPIPathSummaries, resourcePathMap);
        this.validateBalServiceWithOAS(updatedResourcePath, updatedOASPaths);
    }

    private List<OpenAPIPathSummary> validateMissingBalResources(List<OpenAPIPathSummary> operations, Map<String, ResourcePathSummary> resources) {
        boolean filterEnable = this.filter.getOperation() != null || this.filter.getTag() != null || this.filter.getExcludeTag() != null || this.filter.getExcludeOperation() != null;
        Iterator<OpenAPIPathSummary> openAPIPathIterator = operations.iterator();
        while (openAPIPathIterator.hasNext()) {
            OpenAPIPathSummary operationPath = openAPIPathIterator.next();
            if (!resources.containsKey(operationPath.getPath())) {
                if (!filterEnable) {
                    ValidatorUtils.reportDiagnostic(this.context, CompilationError.MISSING_RESOURCE_PATH, (Location)this.context.node().location(), this.filter.getKind(), ValidatorUtils.getNormalizedPath(operationPath.getPath()));
                }
                openAPIPathIterator.remove();
                continue;
            }
            ResourcePathSummary resourcePath = resources.get(operationPath.getPath());
            Map<String, ResourceMethod> resourceMethods = resourcePath.getMethods();
            Map<String, Operation> methods = operationPath.getOperations();
            for (Map.Entry<String, Operation> operation : methods.entrySet()) {
                if (resourceMethods.containsKey(operation.getKey().trim())) continue;
                if (!filterEnable) {
                    ValidatorUtils.reportDiagnostic(this.context, CompilationError.MISSING_RESOURCE_FUNCTION, (Location)this.context.node().location(), this.filter.getKind(), operation.getKey().trim(), ValidatorUtils.getNormalizedPath(operationPath.getPath()));
                }
                methods.remove(operation.getKey());
            }
        }
        return operations;
    }

    private Map<String, ResourcePathSummary> validateUndefinedBalResources(List<OpenAPIPathSummary> operations, Map<String, ResourcePathSummary> resourcePathMap) {
        boolean filterEnable = this.filter.getOperation() != null || this.filter.getTag() != null || this.filter.getExcludeTag() != null || this.filter.getExcludeOperation() != null;
        Iterator<Map.Entry<String, ResourcePathSummary>> resourcePathIter = resourcePathMap.entrySet().iterator();
        while (resourcePathIter.hasNext()) {
            Map.Entry<String, ResourcePathSummary> resourcePath = resourcePathIter.next();
            boolean isPathDocumented = false;
            for (OpenAPIPathSummary operationPath : operations) {
                if (!operationPath.getPath().equals(resourcePath.getKey())) continue;
                isPathDocumented = true;
                Set<Map.Entry<String, ResourceMethod>> methods = resourcePath.getValue().getMethods().entrySet();
                Iterator<Map.Entry<String, ResourceMethod>> methodsIter = methods.iterator();
                while (methodsIter.hasNext()) {
                    Map.Entry<String, ResourceMethod> method = methodsIter.next();
                    if (operationPath.getOperations().containsKey(method.getKey().trim())) continue;
                    if (!filterEnable) {
                        ValidatorUtils.reportDiagnostic(this.context, CompilationError.UNDEFINED_RESOURCE_FUNCTIONS, method.getValue().getLocation(), this.filter.getKind(), method.getKey(), ValidatorUtils.getNormalizedPath(resourcePath.getKey()));
                    }
                    methodsIter.remove();
                }
                break block1;
            }
            if (isPathDocumented) continue;
            if (!filterEnable) {
                ValidatorUtils.reportDiagnostic(this.context, CompilationError.UNDEFINED_RESOURCE_PATH, (Location)this.context.node().location(), this.filter.getKind(), ValidatorUtils.getNormalizedPath(resourcePath.getKey()));
            }
            resourcePathIter.remove();
        }
        return resourcePathMap;
    }

    private void validateBalServiceWithOAS(Map<String, ResourcePathSummary> resourcePaths, List<OpenAPIPathSummary> oasPaths) {
        Set<Map.Entry<String, ResourcePathSummary>> paths = resourcePaths.entrySet();
        for (Map.Entry<String, ResourcePathSummary> path : paths) {
            Map<String, ResourceMethod> methods = path.getValue().getMethods();
            OpenAPIPathSummary oasPath = null;
            for (OpenAPIPathSummary openAPIPathSummary : oasPaths) {
                if (!path.getKey().equals(openAPIPathSummary.getPath())) continue;
                oasPath = openAPIPathSummary;
                break;
            }
            for (Map.Entry entry : methods.entrySet()) {
                assert (oasPath != null);
                ValidatorContext validatorContext = new ValidatorContext(this.context, this.openAPI, path.getKey(), (String)entry.getKey(), this.filter.getKind(), ((ResourceMethod)entry.getValue()).getLocation());
                Map<String, Operation> operations = oasPath.getOperations();
                Operation oasOperation = operations.get(entry.getKey());
                List<Parameter> oasParameters = oasOperation.getParameters();
                ParameterValidator parameterValidator = new ParameterValidator(validatorContext, ((ResourceMethod)entry.getValue()).getParameters(), oasParameters);
                parameterValidator.validate();
                Map<String, Node> balHeaders = ((ResourceMethod)entry.getValue()).getHeaders();
                HeaderValidator headerValidator = new HeaderValidator(validatorContext, balHeaders, oasParameters);
                headerValidator.validate();
                RequestBodyValidator requestBodyValidator = new RequestBodyValidator(validatorContext, oasOperation.getRequestBody(), ((ResourceMethod)entry.getValue()).getBody());
                requestBodyValidator.validate();
                ReturnTypeDescriptorNode returnNode = ((ResourceMethod)entry.getValue()).getReturnNode();
                ApiResponses responses = oasOperation.getResponses();
                TypeDescriptorNode type = returnNode == null ? null : (TypeDescriptorNode)returnNode.type();
                ReturnTypeValidator returnTypeValidator = new ReturnTypeValidator(validatorContext, type, responses);
                returnTypeValidator.validate();
            }
        }
    }
}

