import ballerina/graphql;

type Profile record {
    string name;
    int age;
    Gender gender;
};

// Marks enum value as deprecated.
enum Gender {
    MALE,
    FEMALE,
    # # Deprecated
    # The `NON_BINARY` is deprecated. Use `OTHER` instead.
    @deprecated
    NON_BINARY,
    OTHER
}

service /graphql on new graphql:Listener(9090) {

    // Marks a field as deprecated.
    # # Deprecated
    # The `profileInfo` field is deprecated. Use `profile` instead.
    @deprecated
    resource function get profileInfo() returns Profile {
        return {
            name: "Walter White",
            age: 51,
            gender: MALE
        };
    }

    resource function get profile() returns Profile {
        return {
            name: "Walter White",
            age: 51,
            gender: MALE
        };
    }
}
