// Copyright (c) 2018 WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
//
// WSO2 Inc. licenses this file to you under the Apache License,
// Version 2.0 (the "License"); you may not use this file except
// in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

# Service validation code.
# + contract - OpenAPI contract link
# + tags - OpenAPI tags
# + operations - OpenAPI operations
# + excludeTags - Disable the OpenAPI validator for these tags
# + excludeOperations - Disable the OpenAPI validator for these operations
# + failOnErrors - Enable the OpenAPI validator
# + embed - Enable auto-inject of OpenAPI documentation to current service
# + title - Title for generated OpenAPI contract
# + version - Version for generated OpenAPI contract
# + description - A brief description of the API, outlining its purpose, features, and any other relevant details that help users understand what the API does and how to use it.
# + email - The email address to contact the API provider or support.
# + contactName - The full name of the person or organization responsible for the API.
# + contactURL - The URL to a web page with more information about the API, the provider, or support.
# + termsOfService - The URL to the terms of service for the API.
# + licenseName - The name of the license under which the API is provided.
# + licenseURL - The URL to the full text of the license.
public type ServiceInformation record {|
    string contract = "";
    string[]? tags = [];
    string[]? operations = [];
    string[]? excludeTags = [];
    string[]? excludeOperations = [];
    boolean failOnErrors = true;
    boolean embed = false;
    string title?;
    string version?;
    string description?;
    string email?;
    string contactName?;
    string contactURL?;
    string termsOfService?;
    string licenseName?;
    string licenseURL?;
|};

// # Client configurations code.
// # + tags - OpenAPI tags that filter the openapi operations which need to be generated as client method
// # + operations - OpenAPI operationIds that filter the openapi operations which need to be generated as client method
// # + nullable - This enables to generate all data types in the record with Ballerina nil support
// # + isResource - Select client methods as resources for generation
// # + license - License path for adding license headers
// public type ClientConfiguration record {|
//     string[]? tags = [];
//     string[]? operations = [];
//     boolean nullable = false;
//     boolean isResource = true;
//     string license = "// AUTO-GENERATED FILE. DO NOT MODIFY.\n\n " +
//                      "// This file is auto-generated by the Ballerina OpenAPI tool.\n";
// |};

# This annotation represents a record for storing resource meta information.
#
# + summary - A brief summary of the resource.
# + tags - Tags associated with the resource.
# + operationId - Unique identifier for the operation.
# + examples - This section contains detailed examples for responses and request bodies.
public type ResourceInformation record {|
    string summary?;
    string[] tags?;
    string operationId?;
    Examples examples?;
|};

# Represents an example of a response for a specific status code.
#
# + headers - The headers for the response.
# + examples - Detailed examples of the response content.
public type ResponseExample record {|
    map<string> headers?;
    map<map<record {|record {} value;|}|record {|string filePath;|}>> examples?;
|};

# Represents an example of a request body for a specific media type.
public type RequestExamples readonly & map<map<record {|record {} value;|}|record {|string filePath;|}>>;

# Represents examples for resource function.
#
# + response - Response examples
# + requestBody - Request examples
public type Examples readonly & record {|
    map<ResponseExample> response?;
    RequestExamples requestBody?;
|};

# Annotation for additional OpenAPI information of a Ballerina resource function.
public const annotation ResourceInformation ResourceInfo on object function;

# Annotation for additional OpenAPI information of a Ballerina service.
public annotation ServiceInformation ServiceInfo on service, type;

// # Annotation for additional OpenAPI configurations of a Ballerina client.
// public const annotation ClientConfiguration ClientConfig on source client;

# Represents an example value.
#
# + value - The example value.
public type ExampleValue readonly & record {|
    anydata value;
|};

# Represents a set of example values.
public type ExampleValues readonly & record {|
    ExampleValue...;
|};

# Annotation for an example value.
public const annotation ExampleValue Example on type, parameter, record field;

# Annotation for a set of example values.
public const annotation ExampleValues Examples on parameter;
