// Copyright (c) 2022, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import yaml.common;

# Represents a token generated by the Lexer.
#
# + token - YAML token type
# + value - Lexeme of the token. Empty string if not exists.  
# + indentation - Indentation info if exists
public type Token record {|
    YAMLToken token;
    string value = "";
    Indentation? indentation = ();
|};

# Represents indentation change caused by block scalars.
#
# + change - +1 indent increased, -1 indent decreased, 0 indent has not changed.  
# + collection - List of opened or closed collections.  
# + tokens - Tokens related to the mapping value.
public type Indentation record {|
    IndentChange change;
    common:Collection[] collection;
    YAMLToken[] tokens = [];
|};

# Direction of the indent change
public type IndentChange -1|0|1;

public enum YAMLToken {
    SEQUENCE_ENTRY = "-",
    MAPPING_KEY = "?",
    MAPPING_VALUE = ":",
    SEPARATOR = ",",
    SEQUENCE_START = "[",
    SEQUENCE_END = "]",
    MAPPING_START = "{",
    MAPPING_END = "}",
    DIRECTIVE = "%",
    ALIAS = "*",
    ANCHOR = "&",
    TAG_HANDLE = "<tag-handle>",
    TAG_PREFIX = "<tag-prefix>",
    TAG = "<tag>",
    DOT = ".",
    LITERAL = "|",
    FOLDED = ">",
    DECIMAL = "<integer>",
    SEPARATION_IN_LINE = "<separation-in-line>",
    DIRECTIVE_MARKER = "---",
    DOCUMENT_MARKER = "...",
    DOUBLE_QUOTE_DELIMITER = "\"",
    DOUBLE_QUOTE_CHAR = "<double-quoted-scalar>",
    SINGLE_QUOTE_DELIMITER = "'",
    SINGLE_QUOTE_CHAR = "<single-quoted-scalar>",
    PLANAR_CHAR = "<plain-scalar>",
    PRINTABLE_CHAR = "<printable-char>",
    INDENTATION_INDICATOR = "<indentation-indicator>",
    CHOMPING_INDICATOR = "<chomping-indicator>",
    EMPTY_LINE = "<empty-line>",
    EOL = "<end-of-line>",
    COMMENT = "<comment>",
    TRAILING_COMMENT = "<trailing-comment>",
    DUMMY = "<dummy>"
}
