/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.io.compiler.staticcodeanalyzer;

import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.projects.Document;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.scan.Reporter;
import io.ballerina.stdlib.io.compiler.Constants;
import io.ballerina.stdlib.io.compiler.staticcodeanalyzer.IORule;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class IOPathInjectionAnalyzer
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final Reporter reporter;

    public IOPathInjectionAnalyzer(Reporter reporter) {
        this.reporter = reporter;
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        Node node = context.node();
        if (!(node instanceof FunctionCallExpressionNode)) {
            return;
        }
        FunctionCallExpressionNode functionCall = (FunctionCallExpressionNode)node;
        Optional<NameReferenceNode> functionNameOpt = Optional.ofNullable(functionCall.functionName());
        if (functionNameOpt.isEmpty()) {
            return;
        }
        ExpressionNode functionName = (ExpressionNode)functionNameOpt.get();
        Document document = IOPathInjectionAnalyzer.getDocument(context);
        List<Object> importPrefix = new ArrayList();
        Node node2 = document.syntaxTree().rootNode();
        if (node2 instanceof ModulePartNode) {
            ModulePartNode modulePartNode = (ModulePartNode)node2;
            importPrefix = modulePartNode.imports().stream().filter(importDeclarationNode -> {
                ImportOrgNameNode importOrgNameNode = importDeclarationNode.orgName().orElse(null);
                return importOrgNameNode != null && "ballerina".equals(importOrgNameNode.orgName().text());
            }).filter(importDeclarationNode -> importDeclarationNode.moduleName().stream().anyMatch(moduleNameNode -> "io".equals(moduleNameNode.text()))).map(importDeclarationNode -> {
                ImportPrefixNode importPrefixNode = importDeclarationNode.prefix().orElse(null);
                return importPrefixNode != null ? importPrefixNode.prefix().text() : "io";
            }).toList();
        }
        if (functionName instanceof QualifiedNameReferenceNode) {
            QualifiedNameReferenceNode qualifiedName = (QualifiedNameReferenceNode)functionName;
            String moduleName = qualifiedName.modulePrefix().text();
            String functionNameStr = qualifiedName.identifier().text();
            if (importPrefix.contains(moduleName) && Constants.IO_FUNCTIONS.contains(functionNameStr) && !this.isSafePath(functionCall)) {
                NodeLocation location = functionCall.location();
                this.reporter.reportIssue(IOPathInjectionAnalyzer.getDocument(context), (Location)location, IORule.AVOID_PATH_TRAVERSAL.getId());
            }
        }
    }

    private boolean isSafePath(FunctionCallExpressionNode functionCall) {
        BinaryExpressionNode binaryExpression;
        SeparatedNodeList arguments = functionCall.arguments();
        if (arguments.isEmpty()) {
            return true;
        }
        FunctionArgumentNode firstArg = (FunctionArgumentNode)arguments.get(0);
        if (!(firstArg instanceof PositionalArgumentNode)) {
            return true;
        }
        ExpressionNode argument = ((PositionalArgumentNode)firstArg).expression();
        if (argument instanceof BinaryExpressionNode && (binaryExpression = (BinaryExpressionNode)argument).operator().kind() == SyntaxKind.PLUS_TOKEN) {
            return false;
        }
        if (argument instanceof SimpleNameReferenceNode) {
            SimpleNameReferenceNode variableRef = (SimpleNameReferenceNode)argument;
            return this.isVariableSafe(variableRef);
        }
        return true;
    }

    private boolean isVariableSafe(SimpleNameReferenceNode variableRef) {
        String variableName = variableRef.name().text();
        for (NonTerminalNode currentNode = variableRef.parent(); currentNode != null; currentNode = currentNode.parent()) {
            if (!(currentNode instanceof FunctionBodyBlockNode)) continue;
            FunctionBodyBlockNode functionBody = (FunctionBodyBlockNode)currentNode;
            return this.isVariableDeclaredSafely(functionBody, variableName, variableRef);
        }
        return true;
    }

    private boolean isVariableDeclaredSafely(FunctionBodyBlockNode functionBody, String variableName, SimpleNameReferenceNode variableRef) {
        for (StatementNode statement : functionBody.statements()) {
            VariableDeclarationNode varDecl;
            if (!(statement instanceof VariableDeclarationNode) || !this.isMatchingVariable(varDecl = (VariableDeclarationNode)statement, variableName)) continue;
            ExpressionNode initializer = varDecl.initializer().orElse(null);
            if (initializer == null || this.isConcatenationAssignment(initializer)) {
                return this.isFunctionParameter(variableRef);
            }
            if (initializer instanceof SimpleNameReferenceNode) {
                SimpleNameReferenceNode refNode = (SimpleNameReferenceNode)initializer;
                return this.isFunctionParameter(refNode);
            }
            return true;
        }
        return true;
    }

    private boolean isMatchingVariable(VariableDeclarationNode varDecl, String variableName) {
        CaptureBindingPatternNode bindingPattern;
        BindingPatternNode bindingPatternNode = varDecl.typedBindingPattern().bindingPattern();
        return bindingPatternNode instanceof CaptureBindingPatternNode && (bindingPattern = (CaptureBindingPatternNode)bindingPatternNode).variableName().text().equals(variableName);
    }

    private boolean isConcatenationAssignment(ExpressionNode initializer) {
        BinaryExpressionNode binaryExpr;
        return initializer instanceof BinaryExpressionNode && (binaryExpr = (BinaryExpressionNode)initializer).operator().kind() == SyntaxKind.PLUS_TOKEN;
    }

    private boolean isFunctionParameter(SimpleNameReferenceNode variableRef) {
        String paramName = variableRef.name().text();
        for (NonTerminalNode currentNode = variableRef.parent(); currentNode != null; currentNode = currentNode.parent()) {
            if (!(currentNode instanceof FunctionDefinitionNode)) continue;
            FunctionDefinitionNode functionDef = (FunctionDefinitionNode)currentNode;
            return functionDef.functionSignature().parameters().stream().filter(RequiredParameterNode.class::isInstance).map(RequiredParameterNode.class::cast).noneMatch(reqParam -> reqParam.paramName().map(name -> name.toString().equals(paramName) || this.isIndirectFunctionParameter(variableRef, (RequiredParameterNode)reqParam)).orElse(false));
        }
        return true;
    }

    private boolean isIndirectFunctionParameter(SimpleNameReferenceNode variableRef, RequiredParameterNode reqParam) {
        for (NonTerminalNode currentNode = variableRef.parent(); currentNode != null; currentNode = currentNode.parent()) {
            if (!(currentNode instanceof FunctionBodyBlockNode)) continue;
            FunctionBodyBlockNode functionBody = (FunctionBodyBlockNode)currentNode;
            return functionBody.statements().stream().filter(VariableDeclarationNode.class::isInstance).map(VariableDeclarationNode.class::cast).anyMatch(varDecl -> this.isAssignedToFunctionParameter((VariableDeclarationNode)varDecl, variableRef, reqParam));
        }
        return false;
    }

    private boolean isAssignedToFunctionParameter(VariableDeclarationNode varDecl, SimpleNameReferenceNode variableRef, RequiredParameterNode reqParam) {
        CaptureBindingPatternNode bindingPattern;
        BindingPatternNode bindingPatternNode = varDecl.typedBindingPattern().bindingPattern();
        if (bindingPatternNode instanceof CaptureBindingPatternNode && (bindingPattern = (CaptureBindingPatternNode)bindingPatternNode).variableName().text().equals(variableRef.name().text())) {
            return varDecl.initializer().map(initializer -> this.isInitializerAssignedToFunctionParameter((ExpressionNode)initializer, reqParam)).orElse(false);
        }
        return false;
    }

    private boolean isInitializerAssignedToFunctionParameter(ExpressionNode initializer, RequiredParameterNode reqParam) {
        BinaryExpressionNode binaryExpr;
        if (initializer instanceof SimpleNameReferenceNode) {
            SimpleNameReferenceNode initializerRef = (SimpleNameReferenceNode)initializer;
            return initializerRef.name().text().equals(((Token)reqParam.paramName().get()).text());
        }
        if (initializer instanceof BinaryExpressionNode && (binaryExpr = (BinaryExpressionNode)initializer).operator().kind() == SyntaxKind.PLUS_TOKEN) {
            return this.isIndirectFunctionParameterFromBinary(binaryExpr, reqParam);
        }
        return false;
    }

    private boolean isIndirectFunctionParameterFromBinary(BinaryExpressionNode binaryExpr, RequiredParameterNode reqParam) {
        SimpleNameReferenceNode rightRef;
        SimpleNameReferenceNode leftRef;
        Node node = binaryExpr.lhsExpr();
        if (node instanceof SimpleNameReferenceNode && (leftRef = (SimpleNameReferenceNode)node).name().text().equals(((Token)reqParam.paramName().get()).text())) {
            return true;
        }
        node = binaryExpr.rhsExpr();
        return node instanceof SimpleNameReferenceNode && (rightRef = (SimpleNameReferenceNode)node).name().text().equals(((Token)reqParam.paramName().get()).text());
    }

    public static Document getDocument(SyntaxNodeAnalysisContext context) {
        return context.currentPackage().module(context.moduleId()).document(context.documentId());
    }
}

