/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.centralconnector;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import io.ballerina.centralconnector.response.ConnectorApiResponse;
import io.ballerina.centralconnector.response.Function;
import io.ballerina.centralconnector.response.FunctionResponse;
import io.ballerina.centralconnector.response.FunctionsResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class GraphQlClient {
    private final Map<String, String> queryMap = new HashMap<String, String>();
    private final Gson gson = new GsonBuilder().registerTypeAdapter(FunctionsResponse.Module.class, (Object)new FunctionsModuleDeserializer()).registerTypeAdapter(FunctionResponse.Module.class, (Object)new FunctionModuleDeserializer()).registerTypeAdapter(ConnectorApiResponse.Module.class, (Object)new ConnectorApiModuleDeserializer()).create();
    private static final String GRAPHQL_API = "https://api.central.ballerina.io/2.0/graphql";
    private static final String QUERY_DIRECTORY = "graphql_queries";
    private static final String GET_FUNCTIONS_QUERY = "GetFunctions.graphql";
    private static final String GET_FUNCTION_QUERY = "GetFunction.graphql";
    private static final String GET_CONNECTION_QUERY = "GetConnector.graphql";

    public FunctionsResponse getFunctions(String org, String module, String version) {
        String queryTemplate = this.getQueryTemplate(GET_FUNCTIONS_QUERY);
        String queryBody = String.format(queryTemplate, org, module, version);
        String response = this.query(queryBody);
        return (FunctionsResponse)this.gson.fromJson(response, FunctionsResponse.class);
    }

    public FunctionResponse getFunction(String organization, String name, String version, String functionName) {
        String queryTemplate = this.getQueryTemplate(GET_FUNCTION_QUERY);
        String queryBody = String.format(queryTemplate, organization, name, version, functionName);
        String response = this.query(queryBody);
        return (FunctionResponse)this.gson.fromJson(response, FunctionResponse.class);
    }

    @Deprecated
    public ConnectorApiResponse getConnector(String organization, String name, String version, String clientName) {
        String queryTemplate = this.getQueryTemplate(GET_CONNECTION_QUERY);
        String queryBody = String.format(queryTemplate, organization, name, version, clientName);
        String response = this.query(queryBody);
        return (ConnectorApiResponse)this.gson.fromJson(response, ConnectorApiResponse.class);
    }

    private String query(String queryBody) {
        String query = String.format("{\"query\": \"%s\"}", queryBody);
        HttpURLConnection conn = null;
        try {
            String string;
            URL url = new URL(GRAPHQL_API);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = query.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            try {
                String responseLine;
                StringBuilder response = new StringBuilder();
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine.trim());
                }
                string = response.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            br.close();
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private String getQueryTemplate(String queryName) {
        String queryTemplate = this.queryMap.get(queryName);
        if (queryTemplate == null) {
            queryTemplate = this.readResourceFile(Path.of(QUERY_DIRECTORY, queryName).toString());
            this.queryMap.put(queryName, queryTemplate);
        }
        return queryTemplate;
    }

    private String readResourceFile(String resourcePath) {
        String string;
        InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
        if (resourceStream == null) {
            throw new IllegalArgumentException("Resource not found: " + resourcePath);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
        try {
            string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading resource: " + resourcePath, e);
            }
        }
        reader.close();
        return string;
    }

    private static boolean isJsonString(JsonElement modulesElement) {
        return modulesElement != null && modulesElement.isJsonPrimitive() && modulesElement.getAsJsonPrimitive().isString();
    }

    private static class FunctionsModuleDeserializer
    implements JsonDeserializer<FunctionsResponse.Module> {
        private FunctionsModuleDeserializer() {
        }

        public FunctionsResponse.Module deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonElement modulesElement = jsonObject.get("functions");
            if (GraphQlClient.isJsonString(modulesElement)) {
                String modulesString = modulesElement.getAsString();
                List functions = (List)new Gson().fromJson(modulesString, new FunctionListTypeToken().getType());
                return new FunctionsResponse.Module(functions);
            }
            return (FunctionsResponse.Module)new Gson().fromJson((JsonElement)jsonObject, FunctionsResponse.Module.class);
        }
    }

    private static class FunctionModuleDeserializer
    implements JsonDeserializer<FunctionResponse.Module> {
        private FunctionModuleDeserializer() {
        }

        public FunctionResponse.Module deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonElement modulesElement = jsonObject.get("functions");
            if (GraphQlClient.isJsonString(modulesElement)) {
                String modulesString = modulesElement.getAsString();
                Function function = (Function)new Gson().fromJson(modulesString, Function.class);
                return new FunctionResponse.Module(function);
            }
            return (FunctionResponse.Module)new Gson().fromJson((JsonElement)jsonObject, FunctionResponse.Module.class);
        }
    }

    private static class ConnectorApiModuleDeserializer
    implements JsonDeserializer<ConnectorApiResponse.Module> {
        private ConnectorApiModuleDeserializer() {
        }

        public ConnectorApiResponse.Module deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonElement modulesElement = jsonObject.get("clients");
            if (GraphQlClient.isJsonString(modulesElement)) {
                String modulesString = modulesElement.getAsString();
                return (ConnectorApiResponse.Module)new Gson().fromJson(modulesString, ConnectorApiResponse.Module.class);
            }
            return (ConnectorApiResponse.Module)new Gson().fromJson((JsonElement)jsonObject, ConnectorApiResponse.Module.class);
        }
    }

    private static class FunctionListTypeToken
    extends TypeToken<List<Function>> {
        private FunctionListTypeToken() {
        }
    }
}

