/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.centralconnector;

import io.ballerina.centralconnector.CentralAPI;
import io.ballerina.centralconnector.GraphQlClient;
import io.ballerina.centralconnector.RestClient;
import io.ballerina.centralconnector.response.ConnectorResponse;
import io.ballerina.centralconnector.response.ConnectorsResponse;
import io.ballerina.centralconnector.response.FunctionResponse;
import io.ballerina.centralconnector.response.FunctionsResponse;
import io.ballerina.centralconnector.response.PackageResponse;
import io.ballerina.centralconnector.response.SymbolResponse;
import java.util.Map;

public class RemoteCentral
implements CentralAPI {
    private final RestClient restClient = new RestClient();
    private final GraphQlClient graphQlClient = new GraphQlClient();

    public static RemoteCentral getInstance() {
        return Holder.INSTANCE;
    }

    private RemoteCentral() {
    }

    @Override
    public PackageResponse searchPackages(Map<String, String> queryMap) {
        return this.restClient.searchPackages(queryMap);
    }

    @Override
    public SymbolResponse searchSymbols(Map<String, String> queryMap) {
        return this.restClient.searchSymbols(queryMap);
    }

    @Override
    public FunctionsResponse functions(String organization, String name, String version) {
        return this.graphQlClient.getFunctions(organization, name, version);
    }

    @Override
    public FunctionResponse function(String organization, String name, String version, String functionName) {
        return this.graphQlClient.getFunction(organization, name, version, functionName);
    }

    @Override
    public ConnectorsResponse connectors(Map<String, String> queryMap) {
        return this.restClient.connectors(queryMap);
    }

    @Override
    public ConnectorResponse connector(String id) {
        return this.restClient.connector(id);
    }

    @Override
    public ConnectorResponse connector(String organization, String name, String version, String clientName) {
        return this.restClient.connector(organization, name, version, clientName);
    }

    @Override
    public String latestPackageVersion(String org, String name) {
        return this.restClient.latestPackageVersion(org, name);
    }

    private static class Holder {
        private static final RemoteCentral INSTANCE = new RemoteCentral();

        private Holder() {
        }
    }
}

