/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.xmldata;

import io.ballerina.lib.data.xmldata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.xmldata.utils.DiagnosticLog;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.FiniteType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeTags;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.ballerinalang.langlib.xml.CreateText;

public class FromString {
    private static final List<Integer> TYPE_PRIORITY_ORDER = List.of(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(14), Integer.valueOf(6), Integer.valueOf(15), Integer.valueOf(5));
    private static final List<Type> BASIC_JSON_MEMBER_TYPES = List.of(PredefinedTypes.TYPE_NULL, PredefinedTypes.TYPE_BOOLEAN, PredefinedTypes.TYPE_INT, PredefinedTypes.TYPE_FLOAT, PredefinedTypes.TYPE_DECIMAL, PredefinedTypes.TYPE_STRING);
    private static final UnionType JSON_TYPE_WITH_BASIC_TYPES = TypeCreator.createUnionType(BASIC_JSON_MEMBER_TYPES);

    public static Object fromStringWithType(BString string, BTypedesc typed) {
        Type expType = typed.getDescribingType();
        try {
            return FromString.fromStringWithType(string, expType);
        }
        catch (NumberFormatException e) {
            return FromString.returnError(string.getValue(), expType.toString());
        }
    }

    public static Object fromStringWithType(BString string, Type expType) {
        String value = string.getValue();
        int tag = expType.getTag();
        try {
            if (TypeTags.isStringTypeTag((int)tag)) {
                return string;
            }
            switch (tag) {
                case 1: {
                    return FromString.stringToInt(value);
                }
                case 2: {
                    return FromString.stringToByte(value);
                }
                case 3: {
                    return FromString.stringToFloat(value);
                }
                case 4: {
                    return FromString.stringToDecimal(value);
                }
                case 6: {
                    return FromString.stringToBoolean(value);
                }
                case 14: {
                    return FromString.stringToNull(value);
                }
                case 33: {
                    return FromString.stringToUnion(string, (UnionType)expType);
                }
                case 15: {
                    return FromString.stringToUnion(string, JSON_TYPE_WITH_BASIC_TYPES);
                }
                case 53: {
                    return FromString.fromStringWithType(string, ((ReferenceType)expType).getReferredType());
                }
                case 46: {
                    return FromString.stringToFiniteType(value, (FiniteType)expType);
                }
                case 21: {
                    return CreateText.createText((BString)string);
                }
            }
            return FromString.returnError(value, expType.toString());
        }
        catch (NumberFormatException e) {
            return FromString.returnError(value, expType.toString());
        }
    }

    private static Object stringToFiniteType(String value, FiniteType finiteType) {
        return finiteType.getValueSpace().stream().filter(finiteValue -> !(FromString.convertToSingletonValue(value, finiteValue) instanceof BError)).findFirst().orElseGet(() -> FromString.returnError(value, finiteType.toString()));
    }

    private static Object convertToSingletonValue(String str, Object singletonValue) {
        String singletonStr = String.valueOf(singletonValue);
        Type type = TypeUtils.getType((Object)singletonValue);
        if (singletonValue instanceof BDecimal) {
            BDecimal decimalValue = (BDecimal)singletonValue;
            BigDecimal bigDecimal = decimalValue.decimalValue();
            if (bigDecimal.compareTo(new BigDecimal(str)) == 0) {
                return FromString.fromStringWithType(StringUtils.fromString((String)str), type);
            }
            return FromString.returnError(str, singletonStr);
        }
        if (singletonValue instanceof Double) {
            Double doubleValue = (Double)singletonValue;
            if (doubleValue.compareTo(Double.valueOf(str)) == 0) {
                return FromString.fromStringWithType(StringUtils.fromString((String)str), type);
            }
            return FromString.returnError(str, singletonStr);
        }
        if (str.equals(singletonStr)) {
            return FromString.fromStringWithType(StringUtils.fromString((String)str), type);
        }
        return FromString.returnError(str, singletonStr);
    }

    private static Long stringToInt(String value) throws NumberFormatException {
        return Long.parseLong(value);
    }

    private static int stringToByte(String value) throws NumberFormatException {
        Long number = Long.parseLong(value);
        int intValue = number.intValue();
        if (FromString.isByteLiteral(intValue)) {
            return intValue;
        }
        throw new NumberFormatException();
    }

    private static boolean isByteLiteral(long longValue) {
        return longValue >= (long)RuntimeConstants.BBYTE_MIN_VALUE.intValue() && longValue <= (long)RuntimeConstants.BBYTE_MAX_VALUE.intValue();
    }

    private static Double stringToFloat(String value) throws NumberFormatException {
        if (FromString.hasFloatOrDecimalLiteralSuffix(value)) {
            throw new NumberFormatException();
        }
        return Double.parseDouble(value);
    }

    private static BDecimal stringToDecimal(String value) throws NumberFormatException {
        return ValueCreator.createDecimalValue((String)value);
    }

    private static Object stringToBoolean(String value) throws NumberFormatException {
        if ("true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value)) {
            return false;
        }
        return FromString.returnError(value, "boolean");
    }

    private static Object stringToNull(String value) throws NumberFormatException {
        if ("null".equalsIgnoreCase(value) || "()".equalsIgnoreCase(value)) {
            return null;
        }
        return FromString.returnError(value, "()");
    }

    private static Object stringToUnion(BString string, UnionType expType) throws NumberFormatException {
        ArrayList<Type> memberTypes = new ArrayList<Type>(expType.getMemberTypes());
        memberTypes.sort(Comparator.comparingInt(t -> TYPE_PRIORITY_ORDER.indexOf(TypeUtils.getReferredType((Type)t).getTag())));
        for (Type memberType : memberTypes) {
            try {
                Object result = FromString.fromStringWithType(string, memberType);
                if (result instanceof BError) continue;
                return result;
            }
            catch (Exception exception) {
            }
        }
        return FromString.returnError(string.getValue(), expType.toString());
    }

    private static boolean hasFloatOrDecimalLiteralSuffix(String value) {
        int length = value.length();
        if (length == 0) {
            return false;
        }
        switch (value.charAt(length - 1)) {
            case 'D': 
            case 'F': 
            case 'd': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    private static BError returnError(String string, String expType) {
        return DiagnosticLog.error(DiagnosticErrorCode.CANNOT_CONVERT_TO_EXPECTED_TYPE, PredefinedTypes.TYPE_STRING.getName(), string, expType);
    }
}

