/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.xmldata.utils;

import io.ballerina.lib.data.xmldata.utils.Constants;
import io.ballerina.lib.data.xmldata.utils.DataUtils;
import io.ballerina.lib.data.xmldata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.xmldata.utils.DiagnosticLog;
import io.ballerina.lib.data.xmldata.utils.xsd.ChoiceInfo;
import io.ballerina.lib.data.xmldata.utils.xsd.ElementInfo;
import io.ballerina.lib.data.xmldata.utils.xsd.ModelGroupInfo;
import io.ballerina.lib.data.xmldata.utils.xsd.SequenceInfo;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BXml;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.langlib.map.ToArray;
import org.ballerinalang.langlib.xml.Concat;
import org.ballerinalang.langlib.xml.CreateElement;
import org.ballerinalang.langlib.xml.CreateText;

public class ToXmlUtils {
    private static final BString XMLNS_NAMESPACE_URI = StringUtils.fromString((String)"http://www.w3.org/2000/xmlns/");
    private static final BString ATTRIBUTE_PREFIX = StringUtils.fromString((String)"attribute_");
    private static final BString XMLNS = StringUtils.fromString((String)"xmlns");

    public static Object fromRecordToXml(Object jsonValue, BMap<BString, Object> options, BTypedesc typed) {
        try {
            Type type = typed.getDescribingType();
            Type referredType = TypeUtils.getReferredType((Type)type);
            Object rootTag = options.get((Object)StringUtils.fromString((String)"rootTag"));
            BMap<BString, BString> allNamespaces = ToXmlUtils.getEmptyStringMap();
            BString rootTagBstring = StringUtils.fromString((String)(rootTag == null ? "" : rootTag.toString()));
            if (!ToXmlUtils.isSingleRecordMember(jsonValue)) {
                ToXmlUtils.addNamespaces(allNamespaces, ToXmlUtils.getNamespacesMap(jsonValue, options, ToXmlUtils.getEmptyStringMap()));
                return ToXmlUtils.getElementFromRecordMember(rootTag == null ? StringUtils.fromString((String)"root") : rootTagBstring, ToXmlUtils.traverseRecordAndGenerateXml(jsonValue, allNamespaces, ToXmlUtils.getEmptyStringMap(), options, null, referredType, false, false, null, null), allNamespaces, options, ToXmlUtils.getAttributesMap(jsonValue, options, allNamespaces, ToXmlUtils.getEmptyStringMap()));
            }
            BMap jMap = null;
            try {
                jMap = (BMap)ValueUtils.convert((Object)jsonValue, (Type)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_JSON));
            }
            catch (BError e) {
                return jsonValue == null ? ValueCreator.createXmlValue((String)"") : CreateText.createText((BString)StringUtils.fromString((String)jsonValue.toString()));
            }
            if (jMap.isEmpty()) {
                return ValueCreator.createXmlValue((String)"");
            }
            BString key = ((BString[])jMap.getKeys())[0];
            String jsonKey = key.getValue();
            HashMap<DataUtils.FieldAnnotationValue, String> elementNamesMap = DataUtils.getElementNameMap(referredType);
            ArrayList<String> sequenceFieldNames = ToXmlUtils.getSequenceFieldNames(referredType);
            HashMap<String, ModelGroupInfo> modelGroupRelatedFieldNames = ToXmlUtils.getModelGroupRelatedFieldNames(referredType, elementNamesMap);
            HashMap<String, ElementInfo> elementInfoRelatedFieldNames = ToXmlUtils.getElementInfoRelatedFieldNames(referredType);
            boolean isKeyContainsPrefix = jsonKey.contains(":");
            Object value = ToArray.toArray((BMap)jMap).getValues()[0];
            ToXmlUtils.addNamespaces(allNamespaces, ToXmlUtils.getNamespacesMap(value, options, ToXmlUtils.getEmptyStringMap()));
            String localJsonKeyPart = ToXmlUtils.getElementLocalKeyPart(isKeyContainsPrefix, jsonKey);
            DataUtils.FieldAnnotationValue jsonKeyFieldAnnotation = ToXmlUtils.getElementNamesMapKey(isKeyContainsPrefix, jsonKey, allNamespaces, localJsonKeyPart);
            String recordKey = elementNamesMap.getOrDefault(jsonKeyFieldAnnotation, localJsonKeyPart);
            boolean isSequenceField = sequenceFieldNames.contains(recordKey);
            boolean isContainsModelGroup = modelGroupRelatedFieldNames.containsKey(recordKey);
            ModelGroupInfo parentModelGroupInfo = modelGroupRelatedFieldNames.get(recordKey);
            ElementInfo elementInfo = elementInfoRelatedFieldNames.get(recordKey);
            if (value instanceof BArray) {
                return ToXmlUtils.getElementFromRecordMember(rootTag == null ? StringUtils.fromString((String)"root") : rootTagBstring, ToXmlUtils.traverseRecordAndGenerateXml(value, allNamespaces, ToXmlUtils.getEmptyStringMap(), options, key, ToXmlUtils.getChildElementType(referredType, recordKey), isSequenceField, isSequenceField, parentModelGroupInfo, elementInfo), allNamespaces, options, ToXmlUtils.getAttributesMap(value, options, allNamespaces, ToXmlUtils.getEmptyStringMap()));
            }
            if (key.equals(options.get((Object)Constants.TEXT_FIELD_NAME))) {
                if (rootTagBstring.equals((Object)StringUtils.fromString((String)""))) {
                    rootTagBstring = StringUtils.fromString((String)"root");
                }
                return CreateElement.createElement((BString)rootTagBstring, ToXmlUtils.getEmptyStringMap(), (BXml)CreateText.createText((BString)StringUtils.fromString((String)value.toString())));
            }
            BXml output = ToXmlUtils.getElementFromRecordMember(key, ToXmlUtils.traverseRecordAndGenerateXml(value, allNamespaces, ToXmlUtils.getEmptyStringMap(), options, null, ToXmlUtils.getChildElementType(referredType, recordKey), isSequenceField, isSequenceField, parentModelGroupInfo, elementInfo), allNamespaces, options, ToXmlUtils.getAttributesMap(value, options, allNamespaces, ToXmlUtils.getEmptyStringMap()));
            if (isContainsModelGroup) {
                output = output.children();
            }
            if (rootTag != null) {
                return CreateElement.createElement((BString)rootTagBstring, ToXmlUtils.getEmptyStringMap(), (BXml)output);
            }
            return output;
        }
        catch (Exception e) {
            return DiagnosticLog.createXmlError(e.getMessage());
        }
    }

    private static BMap<BString, BString> getEmptyStringMap() {
        return ValueCreator.createMapValue();
    }

    public static BXml traverseRecordAndGenerateXml(Object jNode, BMap<BString, BString> allNamespaces, BMap<BString, BString> parentNamespaces, BMap<BString, Object> options, Object keyObj, Type type, boolean isParentSequence, boolean isParentSequenceArray, ModelGroupInfo parentModelGroupInfo, ElementInfo parentElementInfo) throws BError {
        BXml xNode = ValueCreator.createXmlValue((String)"");
        String attributePrefix = options.get((Object)Constants.ATTRIBUTE_PREFIX).toString();
        Type referredType = TypeUtils.getReferredType((Type)type);
        HashMap<DataUtils.FieldAnnotationValue, String> elementNamesMap = DataUtils.getElementNameMap(referredType);
        HashMap<String, ModelGroupInfo> modelGroupRelatedFieldNames = ToXmlUtils.getModelGroupRelatedFieldNames(referredType, elementNamesMap);
        HashMap<String, ElementInfo> elementInfoRelatedFieldNames = ToXmlUtils.getElementInfoRelatedFieldNames(referredType);
        ArrayList<String> sequenceFieldNames = ToXmlUtils.getSequenceFieldNames(referredType);
        if (jNode instanceof BMap) {
            BMap jMap;
            BMap mapNode = jMap = (BMap)jNode;
            BString[] orderedRecordKeysIfXsdSequencePresent = DataUtils.getOrderedRecordKeysIfXsdSequencePresent((BMap<BString, Object>)mapNode, DataUtils.getXsdSequencePriorityOrder(referredType, isParentSequence));
            if (parentModelGroupInfo instanceof ChoiceInfo) {
                ToXmlUtils.validateChoiceFields(parentModelGroupInfo, jMap, elementInfoRelatedFieldNames, elementNamesMap, options, parentNamespaces);
            }
            for (BString k : orderedRecordKeysIfXsdSequencePresent) {
                BXml childElement;
                Object value = mapNode.get((Object)k);
                String jsonKey = k.getValue().trim();
                boolean isKeyContainsPrefix = jsonKey.contains(":");
                BMap<BString, BString> namespacesOfElem = ToXmlUtils.getNamespacesMap(value, options, parentNamespaces);
                String localJsonKeyPart = ToXmlUtils.getElementLocalKeyPart(isKeyContainsPrefix, jsonKey);
                DataUtils.FieldAnnotationValue jsonKeyFieldAnnotation = ToXmlUtils.getElementNamesMapKey(isKeyContainsPrefix, jsonKey, namespacesOfElem, localJsonKeyPart);
                String recordKey = elementNamesMap.getOrDefault(jsonKeyFieldAnnotation, localJsonKeyPart);
                boolean isContainsModelGroup = modelGroupRelatedFieldNames.containsKey(recordKey);
                ModelGroupInfo modelGroupInfo = modelGroupRelatedFieldNames.get(recordKey);
                ElementInfo elementInfo = elementInfoRelatedFieldNames.get(recordKey);
                boolean isSequenceField = sequenceFieldNames.contains(recordKey);
                if (jsonKey.startsWith(attributePrefix)) continue;
                if (jsonKey.equals(options.get((Object)Constants.TEXT_FIELD_NAME).toString())) {
                    xNode = Concat.concat((Object[])new Object[]{xNode, CreateText.createText((BString)StringUtils.fromString((String)value.toString()))});
                    continue;
                }
                ToXmlUtils.addNamespaces(allNamespaces, namespacesOfElem);
                if (value instanceof BArray) {
                    childElement = ToXmlUtils.traverseRecordAndGenerateXml(value, allNamespaces, namespacesOfElem, options, k, ToXmlUtils.getChildElementType(referredType, recordKey), isSequenceField, isSequenceField, modelGroupInfo, elementInfo);
                    xNode = Concat.concat((Object[])new Object[]{xNode, childElement});
                    continue;
                }
                childElement = ToXmlUtils.getElementFromRecordMember(k, ToXmlUtils.traverseRecordAndGenerateXml(value, allNamespaces, namespacesOfElem, options, null, ToXmlUtils.getChildElementType(referredType, recordKey), isSequenceField, isSequenceField, modelGroupInfo, elementInfo), allNamespaces, options, ToXmlUtils.getAttributesMap(value, options, allNamespaces, parentNamespaces));
                xNode = Concat.concat((Object[])new Object[]{xNode, !isContainsModelGroup || isParentSequenceArray ? childElement : childElement.children()});
            }
        } else if (jNode instanceof BArray) {
            BArray arrayNode = (BArray)jNode;
            int size = arrayNode.size();
            if (isParentSequenceArray && parentModelGroupInfo != null && parentModelGroupInfo instanceof SequenceInfo) {
                if ((long)size < parentModelGroupInfo.getMinOccurs()) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.ELEMENT_OCCURS_LESS_THAN_MIN_REQUIRED_TIMES, parentModelGroupInfo.getFieldName());
                }
                if ((long)size > parentModelGroupInfo.getMaxOccurs()) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.ELEMENT_OCCURS_MORE_THAN_MAX_ALLOWED_TIMES, parentModelGroupInfo.getFieldName());
                }
            } else {
                if (parentElementInfo != null && (long)size > parentElementInfo.maxOccurs) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.ELEMENT_OCCURS_MORE_THAN_MAX_ALLOWED_TIMES, parentElementInfo.fieldName);
                }
                if (parentElementInfo != null && (long)size < parentElementInfo.minOccurs) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.ELEMENT_OCCURS_LESS_THAN_MIN_REQUIRED_TIMES, parentElementInfo.fieldName);
                }
            }
            for (Object i : arrayNode.getValues()) {
                if (i == null) continue;
                String arrayEntryTagKey = "";
                if (keyObj instanceof BString) {
                    BString key = (BString)keyObj;
                    arrayEntryTagKey = key.getValue();
                } else if (!options.get((Object)Constants.ARRAY_ENTRY_TAG).toString().isEmpty()) {
                    arrayEntryTagKey = options.get((Object)Constants.ARRAY_ENTRY_TAG).toString();
                }
                BMap<BString, BString> namespacesOfElem = ToXmlUtils.getNamespacesMap(i, options, parentNamespaces);
                ToXmlUtils.addNamespaces(allNamespaces, namespacesOfElem);
                BXml childElement = options.get((Object)Constants.ARRAY_ENTRY_TAG).toString().isEmpty() ? ToXmlUtils.getElementFromRecordMember(StringUtils.fromString((String)arrayEntryTagKey), ToXmlUtils.traverseRecordAndGenerateXml(i, allNamespaces, namespacesOfElem, options, keyObj, ToXmlUtils.getChildElementType(referredType, null), isParentSequence, isParentSequenceArray, parentModelGroupInfo, parentElementInfo), allNamespaces, options, ToXmlUtils.getAttributesMap(i, options, allNamespaces, parentNamespaces)) : ToXmlUtils.getElementFromRecordMember(StringUtils.fromString((String)arrayEntryTagKey), ToXmlUtils.traverseRecordAndGenerateXml(i, allNamespaces, namespacesOfElem, options, null, ToXmlUtils.getChildElementType(referredType, null), isParentSequence, isParentSequenceArray, parentModelGroupInfo, parentElementInfo), allNamespaces, options, ToXmlUtils.getAttributesMap(i, options, allNamespaces, parentNamespaces));
                xNode = Concat.concat((Object[])new Object[]{xNode, isParentSequenceArray ? childElement.children() : childElement});
            }
        } else {
            xNode = CreateText.createText((BString)StringUtils.fromString((String)StringUtils.getStringValue((Object)jNode)));
        }
        return xNode;
    }

    private static void validateChoiceFields(ModelGroupInfo parentModelGroupInfo, BMap jMap, HashMap<String, ElementInfo> elementInfoRelatedFieldNames, HashMap<DataUtils.FieldAnnotationValue, String> elementNamesMap, BMap<BString, Object> options, BMap<BString, BString> parentNamespaces) {
        boolean isMeasurable = true;
        int occurences = 0;
        for (Object key : jMap.getKeys()) {
            String localJsonKeyPart;
            BMap<BString, BString> namespacesMap;
            String jsonKey = key.toString();
            Object value = jMap.get(key);
            boolean isKeyContainsPrefix = jsonKey.contains(":");
            DataUtils.FieldAnnotationValue jsonKeyFieldAnnotation = ToXmlUtils.getElementNamesMapKey(isKeyContainsPrefix, jsonKey, namespacesMap = ToXmlUtils.getNamespacesMap(value, options, parentNamespaces), localJsonKeyPart = ToXmlUtils.getElementLocalKeyPart(isKeyContainsPrefix, jsonKey));
            String recordKey = elementNamesMap.getOrDefault(jsonKeyFieldAnnotation, localJsonKeyPart);
            ElementInfo elementInfo = elementInfoRelatedFieldNames.get(recordKey);
            if (elementInfo != null && elementInfo.maxOccurs != 1L) {
                isMeasurable = false;
                break;
            }
            if (value instanceof BArray) {
                BArray array = (BArray)value;
                occurences += array.size();
                continue;
            }
            ++occurences;
        }
        if (isMeasurable && (long)occurences > parentModelGroupInfo.getMaxOccurs()) {
            throw DiagnosticLog.error(DiagnosticErrorCode.ELEMENT_OCCURS_MORE_THAN_MAX_ALLOWED_TIMES, parentModelGroupInfo.getFieldName());
        }
        if (isMeasurable && (long)occurences < parentModelGroupInfo.getMinOccurs()) {
            throw DiagnosticLog.error(DiagnosticErrorCode.ELEMENT_OCCURS_LESS_THAN_MIN_REQUIRED_TIMES, parentModelGroupInfo.getFieldName());
        }
    }

    private static DataUtils.FieldAnnotationValue getElementNamesMapKey(boolean isKeyContainsPrefix, String jsonKey, BMap<BString, BString> namespacesMap, String localJsonKeyPart) {
        if (isKeyContainsPrefix) {
            int jsonKeyIndex = jsonKey.indexOf(":");
            String prefix = jsonKey.substring(0, jsonKeyIndex);
            BString namespaceUrl = (BString)namespacesMap.get((Object)StringUtils.fromString((String)(ToXmlUtils.getXmlnsNameUrI() + prefix)));
            String namespaceUrlStr = namespaceUrl != null ? namespaceUrl.getValue() : null;
            return new DataUtils.FieldAnnotationValue(localJsonKeyPart, namespaceUrlStr);
        }
        return new DataUtils.FieldAnnotationValue(jsonKey, null);
    }

    private static String getElementLocalKeyPart(boolean isKeyContainsPrefix, String jsonKey) {
        return isKeyContainsPrefix ? jsonKey.substring(jsonKey.indexOf(":") + 1) : jsonKey;
    }

    private static HashMap<String, ModelGroupInfo> getModelGroupRelatedFieldNames(Type expType, HashMap<DataUtils.FieldAnnotationValue, String> elementNamesMap) {
        Type referedType = TypeUtils.getReferredType((Type)expType);
        if (referedType instanceof RecordType) {
            RecordType recordType = (RecordType)referedType;
            return DataUtils.getFieldNamesWithModelGroupAnnotations(recordType, elementNamesMap);
        }
        return new HashMap<String, ModelGroupInfo>();
    }

    private static HashMap<String, ElementInfo> getElementInfoRelatedFieldNames(Type expType) {
        Type referedType = TypeUtils.getReferredType((Type)expType);
        if (referedType instanceof RecordType) {
            RecordType recordType = (RecordType)referedType;
            return DataUtils.getFieldNamesWithElementGroupAnnotations(recordType);
        }
        return new HashMap<String, ElementInfo>();
    }

    private static ArrayList<String> getSequenceFieldNames(Type expType) {
        Type referedType = TypeUtils.getReferredType((Type)expType);
        if (referedType instanceof RecordType) {
            RecordType recordType = (RecordType)referedType;
            return DataUtils.getFieldNamesWithSequenceAnnotations(recordType);
        }
        return new ArrayList<String>();
    }

    private static Type getChildElementType(Type type, String recordKey) throws BError {
        try {
            if (type instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)type;
                return TypeUtils.getReferredType((Type)arrayType.getElementType());
            }
            if (type instanceof RecordType) {
                RecordType recordType = (RecordType)type;
                Map fields = recordType.getFields();
                if (fields.containsKey(recordKey)) {
                    return ((Field)fields.get(recordKey)).getFieldType();
                }
                Optional<String> fieldName = ToXmlUtils.getFieldFromRecordNameAnnotation(fields, recordKey);
                if (!fieldName.isEmpty() && fields.containsKey(fieldName.get())) {
                    return ((Field)fields.get(fieldName.get())).getFieldType();
                }
                Type restFieldType = recordType.getRestFieldType();
                if (restFieldType != null) {
                    return restFieldType;
                }
                assert (false);
                throw DiagnosticLog.createXmlError("Invalid xml provided");
            }
            return type;
        }
        catch (Exception e) {
            throw DiagnosticLog.createXmlError("Invalid xml provided");
        }
    }

    private static Optional<String> getFieldFromRecordNameAnnotation(Map<String, Field> fields, String recordKey) {
        for (Field field : fields.values()) {
            Type fieldType = TypeUtils.getReferredType((Type)field.getFieldType());
            if (!(fieldType instanceof RecordType)) continue;
            RecordType recordType = (RecordType)fieldType;
            for (Map.Entry annotation : recordType.getAnnotations().entrySet()) {
                String name;
                if (!DataUtils.isNameAnnotationKey(((BString)annotation.getKey()).getValue()) || !(name = ((BMap)annotation.getValue()).get((Object)Constants.VALUE).toString()).equals(recordKey)) continue;
                return Optional.of(field.getFieldName());
            }
        }
        return Optional.empty();
    }

    public static boolean isSingleRecordMember(Object node) {
        BArray arrayNode;
        if (node instanceof BArray && (arrayNode = (BArray)node).getElementType().getTag() == 15) {
            return false;
        }
        try {
            Object convertedValue = ValueUtils.convert((Object)node, (Type)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_ANYDATA));
            if (convertedValue instanceof BMap) {
                BMap mapNode = (BMap)convertedValue;
                return mapNode.size() <= 1;
            }
        }
        catch (BError e) {
            return true;
        }
        return true;
    }

    public static BXml getElementFromRecordMember(BString name, BXml children, BMap<BString, BString> namespaces, BMap<BString, Object> options, BMap<BString, BString> attributes) {
        BXml element;
        String attributePrefix = options.get((Object)Constants.ATTRIBUTE_PREFIX).toString();
        String userAttributePrefix = options.get((Object)Constants.USER_ATTRIBUTE_PREFIX).toString();
        String nameStr = name.getValue();
        int index = nameStr.indexOf(":");
        if (index != -1) {
            String prefix = nameStr.substring(0, index);
            String elementName = !userAttributePrefix.isEmpty() ? ToXmlUtils.removeUserAttributePrefix(StringUtils.fromString((String)nameStr), StringUtils.fromString((String)userAttributePrefix), index).getValue() : nameStr.substring(index + 1, nameStr.length());
            String namespaceUrl = ((BString)attributes.get((Object)StringUtils.fromString((String)(ToXmlUtils.getXmlnsNameUrI() + prefix)))).toString();
            if (namespaceUrl.isEmpty() && !(namespaceUrl = ((BString)namespaces.get((Object)StringUtils.fromString((String)(ToXmlUtils.getXmlnsNameUrI() + prefix)))).toString()).isEmpty()) {
                attributes.put((Object)StringUtils.fromString((String)(ToXmlUtils.getXmlnsNameUrI() + prefix)), (Object)StringUtils.fromString((String)namespaceUrl));
            }
            element = namespaceUrl.equals("") ? CreateElement.createElement((BString)StringUtils.fromString((String)elementName), attributes, (BXml)children) : CreateElement.createElement((BString)StringUtils.fromString((String)("{" + namespaceUrl + "}" + elementName)), attributes, (BXml)children);
        } else {
            if (nameStr.startsWith(attributePrefix)) {
                throw DiagnosticLog.createXmlError("attribute cannot be an object or array.");
            }
            BMap<BString, BString> newAttributes = attributes;
            if (newAttributes.containsKey((Object)StringUtils.fromString((String)ToXmlUtils.getXmlnsNameUrI()))) {
                String value = ((BString)newAttributes.get((Object)StringUtils.fromString((String)ToXmlUtils.getXmlnsNameUrI()))).toString();
                newAttributes.remove((Object)StringUtils.fromString((String)ToXmlUtils.getXmlnsNameUrI()));
                newAttributes.put((Object)XMLNS, (Object)StringUtils.fromString((String)value));
            }
            element = !userAttributePrefix.equals("") ? CreateElement.createElement((BString)ToXmlUtils.removeUserAttributePrefix(StringUtils.fromString((String)nameStr), StringUtils.fromString((String)userAttributePrefix), null), newAttributes, (BXml)children) : CreateElement.createElement((BString)StringUtils.fromString((String)nameStr), newAttributes, (BXml)children);
        }
        return element;
    }

    public static BString removeUserAttributePrefix(BString name, BString userAttributePrefix, Object index) {
        String userAttributePrefixStr;
        String nameStr = name.getValue();
        int usrAttIndex = nameStr.indexOf(userAttributePrefixStr = userAttributePrefix.getValue());
        if (usrAttIndex != -1) {
            return StringUtils.fromString((String)nameStr.substring(usrAttIndex + 1, nameStr.length()));
        }
        if (index instanceof Long) {
            Long indexNum = (Long)index;
            return StringUtils.fromString((String)nameStr.substring(indexNum.intValue() + 1, nameStr.length()));
        }
        return StringUtils.fromString((String)nameStr);
    }

    public static BMap<BString, BString> getAttributesMap(Object jsonTree, BMap<BString, Object> options, BMap<BString, BString> namespaces, BMap<BString, BString> parentNamespaces) {
        BMap attributes = (BMap)parentNamespaces.copy(new HashMap());
        try {
            BMap attr = (BMap)ValueUtils.convert((Object)jsonTree, (Type)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_JSON));
            String attributePrefix = options.get((Object)Constants.ATTRIBUTE_PREFIX).toString();
            for (Map.Entry entry : attr.entrySet()) {
                int index;
                String key = ((BString)entry.getKey()).toString();
                Object value = entry.getValue();
                if (!key.startsWith(attributePrefix)) continue;
                if (value instanceof BMap || value instanceof BArray) {
                    DiagnosticLog.createXmlError("attribute cannot be an object or array.");
                }
                if ((index = key.indexOf(":")) != -1) {
                    String suffix = key.substring(index + 1);
                    if (key.startsWith(attributePrefix + String.valueOf(XMLNS))) {
                        attributes.put((Object)StringUtils.fromString((String)(ToXmlUtils.getXmlnsNameUrI() + suffix)), (Object)StringUtils.fromString((String)StringUtils.getStringValue(value)));
                        continue;
                    }
                    Long startIndex = ToXmlUtils.getStartIndex(StringUtils.fromString((String)attributePrefix), StringUtils.fromString((String)options.get((Object)Constants.USER_ATTRIBUTE_PREFIX).toString()), StringUtils.fromString((String)key));
                    String prefix = key.substring(startIndex.intValue(), index);
                    BString namespaceUrl = (BString)namespaces.get((Object)StringUtils.fromString((String)(ToXmlUtils.getXmlnsNameUrI() + prefix)));
                    attributes.put((Object)StringUtils.fromString((String)("{" + String.valueOf(namespaceUrl) + "}" + suffix)), (Object)StringUtils.fromString((String)StringUtils.getStringValue(value)));
                    continue;
                }
                if (key.equals(attributePrefix + String.valueOf(XMLNS))) {
                    attributes.put((Object)XMLNS, (Object)StringUtils.fromString((String)StringUtils.getStringValue(value)));
                    continue;
                }
                Long startIndex = ToXmlUtils.getStartIndex(StringUtils.fromString((String)attributePrefix), StringUtils.fromString((String)options.get((Object)Constants.USER_ATTRIBUTE_PREFIX).toString()), StringUtils.fromString((String)key));
                attributes.put((Object)StringUtils.fromString((String)key.substring(startIndex.intValue())), (Object)StringUtils.fromString((String)StringUtils.getStringValue(value)));
            }
            return attributes;
        }
        catch (BError e) {
            return attributes;
        }
    }

    public static Long getStartIndex(BString attributePrefix, BString userAttributePrefix, BString key) {
        int location;
        String attributePrefixStr = attributePrefix.toString();
        String userAttributePrefixStr = userAttributePrefix.toString();
        String keyStr = key.toString();
        int startIndex = 1;
        if (!attributePrefixStr.equals(ATTRIBUTE_PREFIX.toString())) {
            return startIndex;
        }
        int n = location = userAttributePrefixStr.equals("") ? keyStr.indexOf("_") : keyStr.indexOf(userAttributePrefixStr);
        if (location != -1) {
            startIndex = location + 1;
        }
        return startIndex;
    }

    public static BMap<BString, BString> getNamespacesMap(Object jsonTree, BMap<BString, Object> options, BMap<BString, BString> parentNamespaces) {
        BMap namespaces = (BMap)parentNamespaces.copy(new HashMap());
        try {
            Object jsonTreeObject = ValueUtils.convert((Object)jsonTree, (Type)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_JSON));
            BMap attr = (BMap)jsonTreeObject;
            String attributePrefix = options.get((Object)Constants.ATTRIBUTE_PREFIX).toString();
            for (Map.Entry entry : attr.entrySet()) {
                BString key = (BString)entry.getKey();
                Object value = entry.getValue();
                if (!key.getValue().startsWith(attributePrefix)) continue;
                if (value instanceof BMap || value instanceof BArray) {
                    throw DiagnosticLog.createXmlError("attribute cannot be an object or array.");
                }
                if (!key.getValue().startsWith(attributePrefix + String.valueOf(XMLNS))) continue;
                int index = key.getValue().indexOf(":");
                if (index != -1) {
                    String prefix = key.getValue().substring(index + 1);
                    namespaces.put((Object)StringUtils.fromString((String)(ToXmlUtils.getXmlnsNameUrI() + prefix)), (Object)StringUtils.fromString((String)StringUtils.getStringValue(value)));
                    continue;
                }
                namespaces.put((Object)StringUtils.fromString((String)ToXmlUtils.getXmlnsNameUrI()), (Object)StringUtils.fromString((String)StringUtils.getStringValue(value)));
            }
            return namespaces;
        }
        catch (BError e) {
            return namespaces;
        }
    }

    private static String getXmlnsNameUrI() {
        return "{" + String.valueOf(XMLNS_NAMESPACE_URI) + "}";
    }

    public static void addNamespaces(BMap<BString, BString> allNamespaces, BMap<BString, BString> namespaces) {
        for (Map.Entry entry : namespaces.entrySet()) {
            allNamespaces.put((Object)((BString)entry.getKey()), (Object)((BString)entry.getValue()));
        }
    }
}

