/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.xmldata.utils;

import io.ballerina.lib.data.xmldata.utils.DataUtils;
import io.ballerina.lib.data.xmldata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.xmldata.utils.DiagnosticLog;
import io.ballerina.lib.data.xmldata.utils.QualifiedName;
import io.ballerina.lib.data.xmldata.utils.xsd.ChoiceInfo;
import io.ballerina.lib.data.xmldata.utils.xsd.ElementInfo;
import io.ballerina.lib.data.xmldata.utils.xsd.ModelGroupInfo;
import io.ballerina.lib.data.xmldata.utils.xsd.SequenceInfo;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import java.util.HashMap;
import java.util.Map;

public class XsdUtils {
    public static void initializeXsdInformation(RecordType recordType, DataUtils.XmlAnalyzerMetaData parserData) {
        BMap annotations = recordType.getAnnotations();
        for (BString annotationKey : (BString[])annotations.getKeys()) {
            String key = annotationKey.getValue();
            if (!key.contains("$field$.")) continue;
            String fieldName = key.split("\\$field\\$\\.")[1].replaceAll("\\\\", "");
            Map fieldAnnotation = (Map)annotations.get((Object)annotationKey);
            String xmlElementName = DataUtils.getModifiedName(fieldAnnotation, fieldName);
            for (BString fieldAnnotationKey : fieldAnnotation.keySet()) {
                String fieldAnnotationKeyStr = fieldAnnotationKey.getValue();
                if (!fieldAnnotationKeyStr.startsWith("ballerina/data.xmldata")) continue;
                XsdUtils.handleModuleXsdAnnotations(fieldAnnotation, fieldAnnotationKeyStr, fieldName, recordType, fieldAnnotationKey, xmlElementName, parserData);
            }
        }
    }

    public static void handleModuleXsdAnnotations(Map<BString, Object> fieldAnnotation, String fieldAnnotationKeyStr, String fieldName, RecordType recordType, BString fieldAnnotationKey, String xmlElementName, DataUtils.XmlAnalyzerMetaData parserData) {
        if (fieldAnnotationKeyStr.endsWith("Element")) {
            XsdUtils.handleModuleXsdElementAnnotation(fieldAnnotation, fieldAnnotationKey, fieldName, xmlElementName, parserData);
        } else if (fieldAnnotationKeyStr.endsWith("Sequence")) {
            XsdUtils.handleModuleXsdSequenceAnnotations(fieldAnnotation, fieldName, recordType, fieldAnnotationKey, parserData);
        } else if (fieldAnnotationKeyStr.endsWith("Choice")) {
            XsdUtils.handleModuleChoiceSequenceAnnotations(fieldAnnotation, fieldName, recordType, fieldAnnotationKey, parserData);
        }
    }

    public static void handleModuleXsdElementAnnotation(Map<BString, Object> fieldAnnotation, BString fieldAnnotationKey, String fieldName, String xmlElementName, DataUtils.XmlAnalyzerMetaData parserData) {
        BMap fieldAnnotationValue = (BMap)fieldAnnotation.get(fieldAnnotationKey);
        parserData.xmlElementInfo.peek().put(xmlElementName, new ElementInfo(xmlElementName, fieldName, (BMap<BString, Object>)fieldAnnotationValue));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void handleModuleXsdSequenceAnnotations(Map<BString, Object> fieldAnnotation, String fieldName, RecordType recordType, BString fieldAnnotationKey, DataUtils.XmlAnalyzerMetaData parserData) {
        BMap fieldAnnotationValue = (BMap)fieldAnnotation.get(fieldAnnotationKey);
        Type fieldType = TypeUtils.getReferredType((Type)((Field)recordType.getFields().get(fieldName)).getFieldType());
        if (fieldType instanceof RecordType) {
            RecordType recType = (RecordType)fieldType;
            parserData.xsdModelGroupInfo.peek().put(fieldName, new SequenceInfo(fieldName, (BMap<BString, Object>)fieldAnnotationValue, recType, parserData.xmlElementInfo));
            return;
        } else {
            if (!(fieldType instanceof ArrayType)) throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_SEQUENCE_ANNOTATION, fieldName, fieldType);
            ArrayType arrayType = (ArrayType)fieldType;
            Type elementType = TypeUtils.getReferredType((Type)arrayType.getElementType());
            if (!(elementType instanceof RecordType)) throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_SEQUENCE_ANNOTATION, fieldName, fieldType);
            RecordType recType = (RecordType)elementType;
            parserData.xsdModelGroupInfo.peek().put(fieldName, new SequenceInfo(fieldName, (BMap<BString, Object>)fieldAnnotationValue, recType, parserData.xmlElementInfo));
        }
    }

    public static void handleModuleChoiceSequenceAnnotations(Map<BString, Object> fieldAnnotation, String fieldName, RecordType recordType, BString fieldAnnotationKey, DataUtils.XmlAnalyzerMetaData parserData) {
        BMap fieldAnnotationValue = (BMap)fieldAnnotation.get(fieldAnnotationKey);
        Type fieldType = TypeUtils.getReferredType((Type)((Field)recordType.getFields().get(fieldName)).getFieldType());
        if (!(fieldType instanceof RecordType)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_CHOICE_ANNOTATION, fieldName, fieldType);
        }
        RecordType recType = (RecordType)fieldType;
        parserData.xsdModelGroupInfo.peek().put(fieldName, new ChoiceInfo(fieldName, (BMap<BString, Object>)fieldAnnotationValue, recType, parserData.xmlElementInfo));
    }

    public static void validateCurrentElementInfo(DataUtils.XmlAnalyzerMetaData xmlAnalyzerMetaData) {
        if (!xmlAnalyzerMetaData.xmlElementInfo.isEmpty()) {
            xmlAnalyzerMetaData.xmlElementInfo.peek().forEach((key, value) -> value.validate());
        }
    }

    public static void validateElementInfoStack(DataUtils.XmlAnalyzerMetaData xmlAnalyzerMetaData) {
        while (!xmlAnalyzerMetaData.xmlElementInfo.isEmpty()) {
            xmlAnalyzerMetaData.xmlElementInfo.pop().forEach((key, value) -> value.validate());
        }
    }

    public static void validateModelGroupInfoStack(DataUtils.XmlAnalyzerMetaData xmlAnalyzerMetaData) {
        while (!xmlAnalyzerMetaData.xsdModelGroupInfo.isEmpty()) {
            xmlAnalyzerMetaData.xsdModelGroupInfo.pop().forEach((key, value) -> value.validateMinOccurrences());
        }
    }

    public static void popXsdValidationStacks(DataUtils.XmlAnalyzerMetaData xmlAnalyzerMetaData) {
        xmlAnalyzerMetaData.xsdModelGroupInfo.pop().forEach((key, value) -> value.validateMinOccurrences());
        xmlAnalyzerMetaData.xmlElementInfo.pop();
    }

    public static void updateElementOccurrence(DataUtils.XmlAnalyzerMetaData xmlAnalyzerMetaData, QualifiedName elemQName) {
        HashMap<String, ElementInfo> elementInfo;
        if (!xmlAnalyzerMetaData.xmlElementInfo.isEmpty() && (elementInfo = xmlAnalyzerMetaData.xmlElementInfo.peek()).containsKey(elemQName.getLocalPart())) {
            elementInfo.get(elemQName.getLocalPart()).updateOccurrences();
        }
    }

    public static void validateModelGroupStack(DataUtils.XmlAnalyzerMetaData xmlAnalyzerMetaData, QualifiedName elemQName, boolean isStartElement) {
        String localPart = elemQName.getLocalPart();
        while (!xmlAnalyzerMetaData.modelGroupStack.isEmpty()) {
            ModelGroupInfo modelGroup = xmlAnalyzerMetaData.modelGroupStack.peek();
            if (!modelGroup.isElementContains(localPart) && !modelGroup.isMiddleOfModelGroup()) {
                XsdUtils.validateModelGroup(modelGroup, xmlAnalyzerMetaData);
                continue;
            }
            if (isStartElement && modelGroup.predictStartNewModelGroup(localPart)) {
                XsdUtils.validateModelGroup(modelGroup, xmlAnalyzerMetaData, false);
                return;
            }
            if (modelGroup.isElementContains(localPart)) {
                modelGroup.visit(localPart, isStartElement);
            }
            return;
        }
    }

    public static void validateModelGroup(ModelGroupInfo modelGroup, DataUtils.XmlAnalyzerMetaData xmlAnalyzerMetaData) {
        XsdUtils.validateModelGroup(modelGroup, xmlAnalyzerMetaData, true);
    }

    public static void validateModelGroup(ModelGroupInfo modelGroup, DataUtils.XmlAnalyzerMetaData xmlAnalyzerMetaData, boolean isTerminated) {
        modelGroup.validate();
        if (isTerminated) {
            modelGroup.validateMinOccurrences();
        }
        xmlAnalyzerMetaData.currentNode = (BMap)xmlAnalyzerMetaData.nodesStack.pop();
        xmlAnalyzerMetaData.modelGroupStack.pop();
        xmlAnalyzerMetaData.rootRecord = xmlAnalyzerMetaData.recordTypeStack.pop();
        XsdUtils.validateCurrentElementInfo(xmlAnalyzerMetaData);
        XsdUtils.popElementStacksForValidatingGroup(xmlAnalyzerMetaData);
    }

    public static void popElementStacksForValidatingGroup(DataUtils.XmlAnalyzerMetaData xmlAnalyzerMetaData) {
        DataUtils.popMappingTypeStacks(xmlAnalyzerMetaData);
        xmlAnalyzerMetaData.attributeHierarchy.pop();
        xmlAnalyzerMetaData.arrayIndexes.pop();
        xmlAnalyzerMetaData.xsdModelGroupInfo.pop().forEach((key, value) -> value.validateMinOccurrences());
        xmlAnalyzerMetaData.xmlElementInfo.pop();
    }
}

