/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.xmldata.xml;

import io.ballerina.lib.data.xmldata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.xmldata.utils.DiagnosticLog;
import io.ballerina.lib.data.xmldata.utils.ModuleUtils;
import io.ballerina.lib.data.xmldata.xml.XmlTraversal;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BXml;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XSDValidator {
    private static final String SOURCE_OPTIONS = "SourceOptions";
    private static final String CONTENT_FIELD = "#content";
    private static final BString ATTRIBUTE_PREFIX = StringUtils.fromString((String)"attributePrefix");
    private static final BString TEXT_FIELD_NAME = StringUtils.fromString((String)"textFieldName");

    XSDValidator() {
    }

    public static Object validate(BXml xml, Object xsd) throws ParserConfigurationException, IOException, SAXException {
        if (xsd instanceof BString) {
            return XSDValidator.validateXmlFromXsdFile(xsd.toString(), xml);
        }
        return XSDValidator.validateXsdFromXsdRecord((BTypedesc)xsd, xml);
    }

    private static Object validateXmlFromXsdFile(String xsdFilePath, BXml xml) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        dbFactory.setIgnoringComments(true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document document = dBuilder.parse(new InputSource(new StringReader(StringUtils.getStringValue((Object)xml))));
        DOMSource source = new DOMSource(document);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(new File(xsdFilePath));
        Validator validator = schema.newValidator();
        validator.validate(source);
        return null;
    }

    private static Object validateXsdFromXsdRecord(BTypedesc xsdRecord, BXml xml) {
        Object result = XmlTraversal.traverse(xml, XSDValidator.getDefaultSourceOptions(), xsdRecord);
        if (result instanceof BError) {
            BError e = (BError)((Object)result);
            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_XML, e.getMessage());
        }
        return null;
    }

    private static BMap<BString, Object> getDefaultSourceOptions() {
        BMap sourceOptions = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)SOURCE_OPTIONS);
        sourceOptions.put((Object)ATTRIBUTE_PREFIX, (Object)StringUtils.fromString((String)""));
        sourceOptions.put((Object)TEXT_FIELD_NAME, (Object)StringUtils.fromString((String)CONTENT_FIELD));
        return sourceOptions;
    }
}

