/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.xmldata.xpath;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.XmlUtils;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BXml;
import java.util.Optional;
import java.util.function.Function;
import net.sf.saxon.s9api.XdmValue;

interface ConvertibleBasicType<E> {
    public static final ConvertibleBasicType<Long> INT;
    public static final ConvertibleBasicType<Double> FLOAT;
    public static final ConvertibleBasicType<BDecimal> DECIMAL;
    public static final ConvertibleBasicType<BString> STRING;
    public static final ConvertibleBasicType<Boolean> BOOLEAN;
    public static final ConvertibleBasicType<Object> NIL;
    public static final ConvertibleBasicType<BXml> XML;

    public SemType basicType();

    public E convertToType(String var1);

    default public Optional<E> tryConvertToType(XdmValue xml) {
        try {
            return Optional.of(this.convertToType(xml));
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    default public E convertToType(XdmValue xml) {
        if (!2.$assertionsDisabled && xml.size() != 1) {
            throw new AssertionError();
        }
        return this.convertToType(xml.iterator().next().getStringValue());
    }

    default public Optional<E> tryConvertToType(String xmlString) {
        try {
            return Optional.of(this.convertToType(xmlString));
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    default public boolean isValidCandidate(Context cx, BTypedesc targetTd) {
        SemType ty = SemType.tryInto((Context)cx, (Type)targetTd.getDescribingType());
        return Core.containsBasicType((SemType)ty, (SemType)this.basicType());
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        INT = new BasicTypeHolder<Long>(Builder.getIntType(), Long::valueOf, "INT");
        FLOAT = new BasicTypeHolder<Double>(Builder.getFloatType(), Double::valueOf, "FLOAT");
        DECIMAL = new BasicTypeHolder<BDecimal>(Builder.getDecimalType(), ValueCreator::createDecimalValue, "DECIMAL");
        STRING = new BasicTypeHolder<BString>(Builder.getStringType(), StringUtils::fromString, "STRING");
        BOOLEAN = new BasicTypeHolder<Boolean>(Builder.getBooleanType(), repr -> {
            if (repr.equalsIgnoreCase("true")) {
                return true;
            }
            if (repr.equalsIgnoreCase("false")) {
                return false;
            }
            throw new IllegalArgumentException("Invalid boolean value: " + repr);
        }, "BOOLEAN");
        NIL = new BasicTypeHolder<Object>(Builder.getNilType(), repr -> {
            if (!2.$assertionsDisabled && !repr.isEmpty()) {
                throw new AssertionError();
            }
            return null;
        }, "NIL");
        XML = new ConvertibleBasicType<BXml>(){

            @Override
            public SemType basicType() {
                return Builder.getXmlType();
            }

            @Override
            public BXml convertToType(String xmlString) {
                return XmlUtils.parse((String)xmlString);
            }

            @Override
            public BXml convertToType(XdmValue xml) {
                return this.convertToType(xml.toString().trim());
            }

            public String toString() {
                return "ConvertibleBasicType[XML]";
            }
        };
    }

    public record BasicTypeHolder<E>(SemType basicType, Function<String, E> convertFn, String name) implements ConvertibleBasicType<E>
    {
        @Override
        public String toString() {
            return "ConvertibleBasicType[" + this.name + "]";
        }

        @Override
        public E convertToType(String xmlString) {
            return this.convertFn.apply(xmlString);
        }
    }
}

