/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.common;

import io.ballerina.lib.data.yaml.common.Types;

public abstract class YamlEvent {
    private final EventKind kind;
    private String anchor = null;
    private String tag = null;

    public YamlEvent(EventKind kind) {
        this.kind = kind;
    }

    public EventKind getKind() {
        return this.kind;
    }

    public abstract YamlEvent clone();

    public String getAnchor() {
        return this.anchor;
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public static enum EventKind {
        ALIAS_EVENT,
        SCALAR_EVENT,
        START_EVENT,
        END_EVENT,
        DOCUMENT_MARKER_EVENT;

    }

    public static class DocumentMarkerEvent
    extends YamlEvent {
        private final boolean explicit;

        public DocumentMarkerEvent(boolean explicit) {
            super(EventKind.DOCUMENT_MARKER_EVENT);
            this.explicit = explicit;
        }

        public boolean isExplicit() {
            return this.explicit;
        }

        @Override
        public YamlEvent clone() {
            DocumentMarkerEvent documentMarkerEvent = new DocumentMarkerEvent(this.explicit);
            documentMarkerEvent.setAnchor(this.getAnchor());
            documentMarkerEvent.setTag(this.getTag());
            return documentMarkerEvent;
        }
    }

    public static class EndEvent
    extends YamlEvent {
        private final Types.Collection endType;

        public EndEvent(Types.Collection endType) {
            super(EventKind.END_EVENT);
            this.endType = endType;
        }

        public Types.Collection getEndType() {
            return this.endType;
        }

        @Override
        public YamlEvent clone() {
            EndEvent endEvent = new EndEvent(this.endType);
            endEvent.setAnchor(this.getAnchor());
            endEvent.setTag(this.getTag());
            return endEvent;
        }
    }

    public static class StartEvent
    extends YamlEvent {
        private final Types.Collection startType;
        private boolean flowStyle = false;
        private boolean implicit = false;

        public StartEvent(Types.Collection startType) {
            super(EventKind.START_EVENT);
            this.startType = startType;
        }

        public StartEvent(Types.Collection startType, boolean flowStyle, boolean implicit) {
            super(EventKind.START_EVENT);
            this.startType = startType;
            this.flowStyle = flowStyle;
            this.implicit = implicit;
        }

        public Types.Collection getStartType() {
            return this.startType;
        }

        public boolean isFlowStyle() {
            return this.flowStyle;
        }

        public boolean isImplicit() {
            return this.implicit;
        }

        @Override
        public YamlEvent clone() {
            StartEvent startEvent = new StartEvent(this.startType, this.flowStyle, this.implicit);
            startEvent.setAnchor(this.getAnchor());
            startEvent.setTag(this.getTag());
            return startEvent;
        }
    }

    public static class ScalarEvent
    extends YamlEvent {
        private final String value;

        public ScalarEvent() {
            super(EventKind.SCALAR_EVENT);
            this.value = null;
        }

        public ScalarEvent(String value) {
            super(EventKind.SCALAR_EVENT);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public YamlEvent clone() {
            ScalarEvent scalarEvent = new ScalarEvent(this.value);
            scalarEvent.setAnchor(this.getAnchor());
            scalarEvent.setTag(this.getTag());
            return scalarEvent;
        }
    }

    public static class AliasEvent
    extends YamlEvent {
        private final String alias;

        public AliasEvent(String alias) {
            super(EventKind.ALIAS_EVENT);
            this.alias = alias;
        }

        public String getAlias() {
            return this.alias;
        }

        @Override
        public YamlEvent clone() {
            AliasEvent aliasEvent = new AliasEvent(this.alias);
            aliasEvent.setAnchor(this.getAnchor());
            aliasEvent.setTag(this.getTag());
            return aliasEvent;
        }
    }
}

