/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.lexer;

import io.ballerina.lib.data.yaml.common.Types;
import io.ballerina.lib.data.yaml.lexer.LexerState;
import io.ballerina.lib.data.yaml.lexer.Scanner;
import io.ballerina.lib.data.yaml.lexer.Token;
import io.ballerina.lib.data.yaml.lexer.Utils;
import io.ballerina.lib.data.yaml.utils.Error;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IndentUtils {
    private IndentUtils() {
    }

    public static void assertIndent(LexerState lexerState) throws Error.YamlParserException {
        IndentUtils.assertIndent(lexerState, 0, false);
    }

    public static void assertIndent(LexerState lexerState, int offset) throws Error.YamlParserException {
        IndentUtils.assertIndent(lexerState, offset, false);
    }

    public static void assertIndent(LexerState lexerState, int offset, boolean captureIndentationBreak) throws Error.YamlParserException {
        if (lexerState.getColumn() < lexerState.getIndent() + offset) {
            if (captureIndentationBreak) {
                lexerState.setIndentationBreak(true);
                return;
            }
            throw new Error.YamlParserException("invalid indentation", lexerState.getIndent(), lexerState.getColumn());
        }
    }

    public static boolean isTabInIndent(LexerState lexerState, int upperLimit) {
        int tabInWhitespace = lexerState.getTabInWhitespace();
        return lexerState.getIndent() > -1 && tabInWhitespace > -1 && tabInWhitespace <= upperLimit;
    }

    public static void handleMappingValueIndent(LexerState lexerState, Token.TokenType outputToken) throws Error.YamlParserException {
        IndentUtils.handleMappingValueIndent(lexerState, outputToken, null);
    }

    public static void handleMappingValueIndent(LexerState lexerState, Token.TokenType outputToken, Scanner.Scan scan) throws Error.YamlParserException {
        lexerState.setIndentationBreak(false);
        boolean enforceMapping = lexerState.getEnforceMapping();
        lexerState.setEnforceMapping(false);
        boolean notSufficientIndent = false;
        if (scan == null) {
            lexerState.forward();
            lexerState.tokenize(outputToken);
            notSufficientIndent = lexerState.getColumn() < lexerState.getIndentStartIndex();
        } else {
            try {
                IndentUtils.assertIndent(lexerState, 1);
            }
            catch (Error.YamlParserException ex) {
                notSufficientIndent = true;
            }
            lexerState.updateStartIndex();
            Scanner.iterate(lexerState, scan, outputToken);
        }
        if (lexerState.isFlowCollection()) {
            return;
        }
        int numWhitespace = 0;
        while (Utils.WHITE_SPACE_PATTERN.pattern(lexerState.peek(numWhitespace))) {
            ++numWhitespace;
        }
        if (notSufficientIndent) {
            if (lexerState.peek(numWhitespace) == 58 && !lexerState.isFlowCollection()) {
                lexerState.forward(numWhitespace);
                lexerState.setIndentation(IndentUtils.handleIndent(lexerState, lexerState.getIndentStartIndex()));
                return;
            }
            throw new Error.YamlParserException("insufficient indentation for a scalar", lexerState.getLine(), lexerState.getColumn());
        }
        if (lexerState.peek(numWhitespace) == 58 && !lexerState.isFlowCollection()) {
            lexerState.forward(numWhitespace);
            lexerState.setIndentation(IndentUtils.handleIndent(lexerState, lexerState.getIndentStartIndex()));
            return;
        }
        if (enforceMapping) {
            throw new Error.YamlParserException("insufficient indentation for a scalar", lexerState.getLine(), lexerState.getColumn());
        }
    }

    public static Indentation handleIndent(LexerState sm) throws Error.YamlParserException {
        return IndentUtils.handleIndent(sm, null);
    }

    public static Indentation handleIndent(LexerState sm, Integer mapIndex) throws Error.YamlParserException {
        int indent2;
        int indentsSize;
        Types.Collection collection;
        int startIndex;
        int n = startIndex = mapIndex == null ? sm.getColumn() - 1 : mapIndex;
        if (mapIndex != null) {
            sm.setKeyDefinedForLine(true);
        }
        if (IndentUtils.isTabInIndent(sm, startIndex)) {
            throw new Error.YamlParserException("cannot have tab as an indentation", sm.getLine(), sm.getColumn());
        }
        Types.Collection collection2 = collection = mapIndex == null ? Types.Collection.SEQUENCE : Types.Collection.MAPPING;
        if (sm.getIndent() == startIndex) {
            List<Types.Collection> existingIndentType = sm.getIndents().stream().filter(indent -> indent.column() == startIndex).map(Indent::collection).toList();
            if (collection == Types.Collection.MAPPING && existingIndentType.contains((Object)Types.Collection.SEQUENCE)) {
                if (existingIndentType.contains((Object)Types.Collection.MAPPING)) {
                    return new Indentation(Indentation.IndentationChange.INDENT_DECREASE, new ArrayList<Types.Collection>(Collections.singleton(sm.getIndents().pop().collection())), sm.getClonedTokensForMappingValue());
                }
                throw new Error.YamlParserException("block mapping cannot have the same indent as a block sequence", sm.getLine(), sm.getColumn());
            }
            if (collection == Types.Collection.SEQUENCE && existingIndentType.contains((Object)Types.Collection.MAPPING)) {
                if (existingIndentType.contains((Object)Types.Collection.SEQUENCE)) {
                    return new Indentation(Indentation.IndentationChange.INDENT_NO_CHANGE, new ArrayList<Types.Collection>(), sm.getClonedTokensForMappingValue());
                }
                sm.getIndents().push(new Indent(startIndex, Types.Collection.SEQUENCE));
                return new Indentation(Indentation.IndentationChange.INDENT_INCREASE, new ArrayList<Types.Collection>(Collections.singleton(Types.Collection.SEQUENCE)), sm.getClonedTokensForMappingValue());
            }
            return new Indentation(Indentation.IndentationChange.INDENT_NO_CHANGE, new ArrayList<Types.Collection>(), sm.getClonedTokensForMappingValue());
        }
        if (sm.getIndent() < startIndex) {
            sm.getIndents().push(new Indent(startIndex, collection));
            sm.setIndent(startIndex);
            return new Indentation(Indentation.IndentationChange.INDENT_INCREASE, new ArrayList<Types.Collection>(Collections.singleton(collection)), sm.getClonedTokensForMappingValue());
        }
        if (sm.getIndent() > startIndex) {
            List<Types.Collection> existingIndentType = sm.getIndents().stream().filter(indent -> indent.column() == startIndex).map(Indent::collection).toList();
            if (collection == Types.Collection.MAPPING && existingIndentType.contains((Object)Types.Collection.SEQUENCE) && !existingIndentType.contains((Object)Types.Collection.MAPPING)) {
                throw new Error.YamlParserException("block mapping cannot have the same indent as a block sequence", sm.getLine(), sm.getColumn());
            }
        }
        Indent removedIndent = null;
        ArrayList<Types.Collection> returnCollection = new ArrayList<Types.Collection>();
        for (indentsSize = sm.getIndents().size(); sm.getIndent() > startIndex && indentsSize > 0; --indentsSize) {
            removedIndent = sm.getIndents().pop();
            sm.setIndent(removedIndent.column());
            returnCollection.add(removedIndent.collection());
        }
        if (indentsSize > 0 && removedIndent != null) {
            Indent removedSecondIndent = sm.getIndents().pop();
            if (removedSecondIndent.column() == startIndex && collection == Types.Collection.MAPPING) {
                returnCollection.add(removedIndent.collection());
            } else {
                sm.getIndents().add(removedSecondIndent);
            }
        }
        if ((indent2 = sm.getIndent()) == startIndex) {
            sm.getIndents().push(new Indent(indent2, collection));
            int returnCollectionSize = returnCollection.size();
            if (returnCollectionSize > 1) {
                returnCollection.remove(returnCollectionSize - 1);
                return new Indentation(Indentation.IndentationChange.INDENT_DECREASE, returnCollection, sm.getClonedTokensForMappingValue());
            }
        }
        throw new Error.YamlParserException("invalid indentation", sm.getLine(), sm.getColumn());
    }

    public record Indentation(IndentationChange change, List<Types.Collection> collection, List<Token.TokenType> tokens) {

        public static enum IndentationChange {
            INDENT_INCREASE(1),
            INDENT_NO_CHANGE(0),
            INDENT_DECREASE(-1);


            private IndentationChange(int i) {
            }
        }
    }

    public record Indent(int column, Types.Collection collection) {
    }
}

