/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.lexer;

import io.ballerina.lib.data.yaml.lexer.LexerState;
import java.util.List;

public class Utils {
    public static final Pattern PRINTABLE_PATTERN = new PrintablePattern();
    public static final Pattern JSON_PATTERN = new JsonPattern();
    public static final Pattern BOM_PATTERN = new BomPattern();
    public static final Pattern LINE_BREAK_PATTERN = new LineBreakPattern();
    public static final Pattern WHITE_SPACE_PATTERN = new WhiteSpacePattern();
    public static final Pattern DECIMAL_PATTERN = new DecimalPattern();
    public static final Pattern HEXA_DECIMAL_PATTERN = new HexaDecimalPattern();
    public static final Pattern WORD_PATTERN = new WordPattern();
    public static final Pattern FLOW_INDICATOR_PATTERN = new FlowIndicatorPattern();
    public static final Pattern INDICATOR_PATTERN = new IndicatorPattern();
    public static final Pattern URI_PATTERN = new UriPattern();

    private Utils() {
    }

    public static boolean matchPattern(LexerState sm, List<Pattern> inclusionPatterns) {
        return Utils.matchPattern(sm, inclusionPatterns, List.of(), 0);
    }

    public static boolean matchPattern(LexerState sm, List<Pattern> inclusionPatterns, int offset) {
        return Utils.matchPattern(sm, inclusionPatterns, List.of(), offset);
    }

    public static boolean matchPattern(LexerState sm, List<Pattern> inclusionPatterns, List<Pattern> exclusionPatterns) {
        return Utils.matchPattern(sm, inclusionPatterns, exclusionPatterns, 0);
    }

    public static boolean matchPattern(LexerState sm, List<Pattern> inclusionPatterns, List<Pattern> exclusionPatterns, int offset) {
        int peek = sm.peek(offset);
        if (peek == -1) {
            return false;
        }
        for (Pattern pattern : exclusionPatterns) {
            if (!pattern.pattern(peek)) continue;
            return false;
        }
        for (Pattern pattern : inclusionPatterns) {
            if (!pattern.pattern(peek)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlainSafe(LexerState sm) {
        return Utils.matchPattern(sm, List.of(PRINTABLE_PATTERN), List.of(LINE_BREAK_PATTERN, BOM_PATTERN, WHITE_SPACE_PATTERN, INDICATOR_PATTERN));
    }

    public static boolean isTagChar(LexerState sm) {
        return Utils.matchPattern(sm, List.of(URI_PATTERN, WORD_PATTERN, new CharPattern('%')), List.of(new CharPattern('!'), FLOW_INDICATOR_PATTERN));
    }

    public static boolean checkCharacters(LexerState sm, List<Character> expectedChars) {
        return expectedChars.contains(Character.valueOf((char)sm.peek()));
    }

    public static boolean isComment(LexerState sm) {
        return sm.peek() == 35;
    }

    public static boolean isMarker(LexerState sm, boolean directive) {
        int directiveCodePoint;
        int n = directiveCodePoint = directive ? 45 : 46;
        if (sm.peek() == directiveCodePoint && sm.peek(1) == directiveCodePoint && sm.peek(2) == directiveCodePoint) {
            if (WHITE_SPACE_PATTERN.pattern(sm.peek(3)) || LINE_BREAK_PATTERN.pattern(sm.peek(3))) {
                sm.forward(2);
                return true;
            }
            if (sm.peek(3) == -1) {
                sm.forward(2);
                sm.forward();
                return true;
            }
        }
        return false;
    }

    public static boolean discernPlanarFromIndicator(LexerState sm) {
        return Utils.discernPlanarFromIndicator(sm, 1);
    }

    public static boolean discernPlanarFromIndicator(LexerState sm, int offset) {
        if (sm.isFlowCollection()) {
            return Utils.matchPattern(sm, List.of(PRINTABLE_PATTERN), List.of(LINE_BREAK_PATTERN, BOM_PATTERN, WHITE_SPACE_PATTERN, FLOW_INDICATOR_PATTERN), offset);
        }
        return Utils.matchPattern(sm, List.of(PRINTABLE_PATTERN), List.of(LINE_BREAK_PATTERN, BOM_PATTERN, WHITE_SPACE_PATTERN), offset);
    }

    public static String getWhitespace(LexerState sm) {
        StringBuilder whitespace = new StringBuilder();
        while (true) {
            if (sm.peek() == 32) {
                whitespace.append(" ");
            } else {
                if (sm.peek() != 9) break;
                sm.updateFirstTabIndex();
                whitespace.append("\t");
            }
            sm.forward();
        }
        return whitespace.toString();
    }

    public static boolean isNewLine(LexerState sm) {
        return sm.peek() == 10 || sm.peek() == 13 && sm.peek(1) == 10;
    }

    static interface Pattern {
        public boolean pattern(int var1);
    }

    public static class CharPattern
    implements Pattern {
        private final char value;

        public CharPattern(char value) {
            this.value = value;
        }

        @Override
        public boolean pattern(int codePoint) {
            return this.value == codePoint;
        }
    }

    public static class PrintablePattern
    implements Pattern {
        @Override
        public boolean pattern(int codePoint) {
            return codePoint >= 32 && codePoint <= 126 || codePoint >= 160 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF || codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint == 133;
        }
    }

    public static class JsonPattern
    implements Pattern {
        @Override
        public boolean pattern(int codePoint) {
            return codePoint >= 32 || codePoint == 9;
        }
    }

    public static class BomPattern
    implements Pattern {
        @Override
        public boolean pattern(int codePoint) {
            return codePoint == 65279;
        }
    }

    public static class LineBreakPattern
    implements Pattern {
        @Override
        public boolean pattern(int codePoint) {
            return codePoint == 10 || codePoint == 13;
        }
    }

    public static class WhiteSpacePattern
    implements Pattern {
        @Override
        public boolean pattern(int codePoint) {
            return codePoint == 32 || codePoint == 9;
        }
    }

    public static class DecimalPattern
    implements Pattern {
        @Override
        public boolean pattern(int codePoint) {
            return codePoint >= 48 && codePoint <= 57;
        }
    }

    public static class HexaDecimalPattern
    implements Pattern {
        @Override
        public boolean pattern(int codePoint) {
            return codePoint >= 48 && codePoint <= 57 || codePoint >= 65 && codePoint <= 70 || codePoint >= 97 && codePoint <= 102;
        }
    }

    public static class WordPattern
    implements Pattern {
        @Override
        public boolean pattern(int codePoint) {
            return codePoint >= 97 && codePoint <= 122 || codePoint >= 65 && codePoint <= 90 || DECIMAL_PATTERN.pattern(codePoint) || codePoint == 45;
        }
    }

    public static class FlowIndicatorPattern
    implements Pattern {
        @Override
        public boolean pattern(int codePoint) {
            return codePoint == 44 || codePoint == 91 || codePoint == 93 || codePoint == 123 || codePoint == 125;
        }
    }

    public static class IndicatorPattern
    implements Pattern {
        @Override
        public boolean pattern(int codePoint) {
            return "-?:,[]{}#&*!|>'\"%@`".contains(Character.toString(codePoint));
        }
    }

    public static class UriPattern
    implements Pattern {
        @Override
        public boolean pattern(int codePoint) {
            return "#;/?:@&=+$,_.!~*'()[]".contains(Character.toString(codePoint));
        }
    }
}

