/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.parser;

import io.ballerina.lib.data.yaml.lexer.LexerState;
import io.ballerina.lib.data.yaml.lexer.Token;
import io.ballerina.lib.data.yaml.parser.ParserState;
import io.ballerina.lib.data.yaml.parser.YamlParser;
import io.ballerina.lib.data.yaml.utils.Error;
import java.util.List;

public class Directive {
    private Directive() {
    }

    public static void yamlDirective(ParserState state) throws Error.YamlParserException {
        if (state.getYamlVersion() != null) {
            throw new Error.YamlParserException("YAML document version is already defined", state.getLine(), state.getColumn());
        }
        YamlParser.getNextToken(state, List.of(Token.TokenType.SEPARATION_IN_LINE));
        state.updateLexerState(LexerState.LEXER_DIRECTIVE);
        YamlParser.getNextToken(state, List.of(Token.TokenType.DECIMAL));
        Object lexemeBuffer = state.getCurrentToken().getValue();
        YamlParser.getNextToken(state, List.of(Token.TokenType.DOT));
        lexemeBuffer = (String)lexemeBuffer + ".";
        YamlParser.getNextToken(state, List.of(Token.TokenType.DECIMAL));
        lexemeBuffer = (String)lexemeBuffer + state.getCurrentToken().getValue();
        float yamlVersion = Float.parseFloat((String)lexemeBuffer);
        if ((double)yamlVersion != 1.2 && ((double)yamlVersion >= 2.0 || (double)yamlVersion < 1.0)) {
            throw new Error.YamlParserException("incompatible yaml version for the 1.2 parser", state.getLine(), state.getColumn());
        }
        state.setYamlVersion(Float.valueOf(yamlVersion));
    }

    public static void tagDirective(ParserState state) throws Error.YamlParserException {
        YamlParser.getNextToken(state, List.of(Token.TokenType.SEPARATION_IN_LINE));
        state.updateLexerState(LexerState.LEXER_TAG_HANDLE_STATE);
        YamlParser.getNextToken(state, List.of(Token.TokenType.TAG_HANDLE));
        String tagHandle = state.getCurrentToken().getValue();
        YamlParser.getNextToken(state, List.of(Token.TokenType.SEPARATION_IN_LINE));
        if (state.getCustomTagHandles().containsKey(tagHandle)) {
            throw new Error.YamlParserException("duplicate tag handle", state.getLine(), state.getColumn());
        }
        state.updateLexerState(LexerState.LEXER_TAG_PREFIX_STATE);
        YamlParser.getNextToken(state, List.of(Token.TokenType.TAG_PREFIX));
        String tagPrefix = state.getCurrentToken().getValue();
        if (!tagPrefix.equals("tag:yaml.org,2002:")) {
            throw new Error.YamlParserException("custom tags not supported", state.getLine(), state.getColumn());
        }
        state.getCustomTagHandles().put(tagHandle, tagPrefix);
    }

    public static void reservedDirective(ParserState state) throws Error.YamlParserException {
        StringBuilder reservedDirective = new StringBuilder(state.getCurrentToken().getValue());
        state.updateLexerState(LexerState.LEXER_RESERVED_DIRECTIVE);
        YamlParser.getNextToken(state, true);
        while (state.getBufferedToken().getType() == Token.TokenType.SEPARATION_IN_LINE) {
            YamlParser.getNextToken(state);
            YamlParser.getNextToken(state, true);
            YamlParser.getNextToken(state);
            reservedDirective.append(" ").append(state.getCurrentToken().getValue());
            YamlParser.getNextToken(state, true);
        }
        state.getReservedDirectives().add(reservedDirective.toString());
    }
}

