/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.parser;

import io.ballerina.lib.data.yaml.common.Types;
import io.ballerina.lib.data.yaml.common.YamlEvent;
import io.ballerina.lib.data.yaml.lexer.CharacterReader;
import io.ballerina.lib.data.yaml.lexer.LexerState;
import io.ballerina.lib.data.yaml.lexer.Token;
import io.ballerina.lib.data.yaml.utils.Error;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParserState {
    public static final Token DUMMY_TOKEN = new Token(Token.TokenType.DUMMY);
    private final LexerState lexerState;
    private Token currentToken = DUMMY_TOKEN;
    private Token bufferedToken = DUMMY_TOKEN;
    private final List<YamlEvent> eventBuffer = new ArrayList<YamlEvent>();
    private int lineIndex = -1;
    private boolean explicitDoc = false;
    private Float yamlVersion = null;
    private Map<String, String> customTagHandles = new HashMap<String, String>();
    private boolean explicitKey = false;
    private int lastExplicitKeyLine = -1;
    private boolean expectBlockSequenceValue = false;
    private boolean tagPropertiesInLine = false;
    private boolean indentationProcessed = false;
    private int lastKeyLine = -1;
    private boolean emptyKey = false;
    private final List<String> reservedDirectives = new ArrayList<String>();

    public ParserState(Reader reader) {
        this.lexerState = new LexerState(new CharacterReader(reader));
        try {
            this.initLexer();
        }
        catch (Exception e) {
            this.eventBuffer.add(new YamlEvent.EndEvent(Types.Collection.STREAM));
        }
    }

    public int getLineIndex() {
        return this.lineIndex;
    }

    public void updateLexerState(LexerState.State state) {
        this.lexerState.updateLexerState(state);
    }

    public void setBufferedToken(Token token) {
        this.bufferedToken = token;
    }

    public Token getBufferedToken() {
        return this.bufferedToken;
    }

    public Token getCurrentToken() {
        return this.currentToken;
    }

    public void setCurrentToken(Token currentToken) {
        this.currentToken = currentToken;
    }

    public LexerState getLexerState() {
        return this.lexerState;
    }

    public List<YamlEvent> getEventBuffer() {
        return this.eventBuffer;
    }

    public boolean isExplicitDoc() {
        return this.explicitDoc;
    }

    public void setExplicitDoc(boolean explicitDoc) {
        this.explicitDoc = explicitDoc;
    }

    public Float getYamlVersion() {
        return this.yamlVersion;
    }

    public void setYamlVersion(Float yamlVersion) {
        this.yamlVersion = yamlVersion;
    }

    public Map<String, String> getCustomTagHandles() {
        return this.customTagHandles;
    }

    public void setCustomTagHandles(Map<String, String> customTagHandles) {
        this.customTagHandles = customTagHandles;
    }

    public boolean isExplicitKey() {
        return this.explicitKey;
    }

    public void setExplicitKey(boolean explicitKey) {
        this.explicitKey = explicitKey;
    }

    public int getLastExplicitKeyLine() {
        return this.lastExplicitKeyLine;
    }

    public void setLastExplicitKeyLine(int lastExplicitKeyLine) {
        this.lastExplicitKeyLine = lastExplicitKeyLine;
    }

    public boolean isExpectBlockSequenceValue() {
        return this.expectBlockSequenceValue;
    }

    public boolean isTagPropertiesInLine() {
        return this.tagPropertiesInLine;
    }

    public void setTagPropertiesInLine(boolean tagPropertiesInLine) {
        this.tagPropertiesInLine = tagPropertiesInLine;
    }

    public void setExpectBlockSequenceValue(boolean expectBlockSequenceValue) {
        this.expectBlockSequenceValue = expectBlockSequenceValue;
    }

    public boolean isIndentationProcessed() {
        return this.indentationProcessed;
    }

    public void setIndentationProcessed(boolean indentationProcessed) {
        this.indentationProcessed = indentationProcessed;
    }

    public int getLastKeyLine() {
        return this.lastKeyLine;
    }

    public void setLastKeyLine(int lastKeyLine) {
        this.lastKeyLine = lastKeyLine;
    }

    public boolean isEmptyKey() {
        return this.emptyKey;
    }

    public void setEmptyKey(boolean emptyKey) {
        this.emptyKey = emptyKey;
    }

    public List<String> getReservedDirectives() {
        return this.reservedDirectives;
    }

    public int getLine() {
        return this.lexerState.getLine();
    }

    public int getColumn() {
        return this.lexerState.getColumn();
    }

    public void initLexer() throws Error.YamlParserException {
        ++this.lineIndex;
        this.explicitDoc = false;
        this.expectBlockSequenceValue = false;
        this.tagPropertiesInLine = false;
        this.lexerState.updateNewLineProps();
        if (this.getLexerState().isEndOfStream()) {
            throw new Error.YamlParserException("END of stream reached", this.lexerState.getLine(), this.lexerState.getColumn());
        }
    }
}

