/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.serializer;

import io.ballerina.lib.data.yaml.common.Types;
import io.ballerina.lib.data.yaml.common.YamlEvent;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BValue;
import java.util.ArrayList;
import java.util.List;

public class Serializer {
    private Serializer() {
    }

    public static void serialize(SerializerState state, Object data) {
        Serializer.serialize(state, data, 0, null);
    }

    public static void serialize(SerializerState state, Object value, int depthLevel, String excludeTag) {
        if (value instanceof BValue) {
            int typeTag = ((BValue)value).getType().getTag();
            if (typeTag == 32 || typeTag == 44) {
                Serializer.serializeSequence(state, (BArray)value, depthLevel);
                return;
            }
            if (typeTag == 27 || typeTag == 24) {
                Serializer.serializeMapping(state, (BMap<BString, Object>)((BMap)value), depthLevel);
                return;
            }
        }
        Serializer.serializeString(state, value);
    }

    private static void serializeString(SerializerState state, Object data) {
        Object value = data.toString();
        value = ((String)value).contains("\n") ? state.delimiter + ((String)value).replaceAll("\n", "\\n") + state.delimiter : (state.forceQuotes ? state.delimiter + (String)value + state.delimiter : value);
        YamlEvent.ScalarEvent scalarEvent = new YamlEvent.ScalarEvent((String)value);
        scalarEvent.setTag("tag:yaml.org,2002:str");
        state.events.add(scalarEvent);
    }

    private static void serializeSequence(SerializerState state, BArray data, int depthLevel) {
        if (state.isStream) {
            state.isStream = false;
            for (int i = 0; i < data.size(); ++i) {
                Serializer.serialize(state, data.get((long)i), depthLevel + 1, "tag:yaml.org,2002:seq");
            }
        } else {
            YamlEvent.StartEvent startEvent = new YamlEvent.StartEvent(Types.Collection.SEQUENCE, state.flowStyle, false);
            startEvent.setTag("tag:yaml.org,2002:seq");
            state.events.add(startEvent);
            for (int i = 0; i < data.size(); ++i) {
                Serializer.serialize(state, data.get((long)i), depthLevel + 1, "tag:yaml.org,2002:seq");
            }
            state.events.add(new YamlEvent.EndEvent(Types.Collection.SEQUENCE));
        }
    }

    private static void serializeMapping(SerializerState state, BMap<BString, Object> bMap, int depthLevel) {
        BString[] keys;
        state.events.add(new YamlEvent.StartEvent(Types.Collection.MAPPING, state.flowStyle, false));
        for (BString key : keys = (BString[])bMap.getKeys()) {
            Serializer.serialize(state, key, depthLevel, "tag:yaml.org,2002:map");
            Serializer.serialize(state, bMap.get((Object)key), depthLevel + 1, "tag:yaml.org,2002:map");
        }
        state.events.add(new YamlEvent.EndEvent(Types.Collection.MAPPING));
    }

    public static class SerializerState {
        List<YamlEvent> events = new ArrayList<YamlEvent>();
        final char delimiter;
        final boolean forceQuotes;
        final boolean flowStyle;
        final int blockLevel;
        boolean isStream;

        public SerializerState(char delimiter, boolean forceQuotes, int blockLevel, boolean flowStyle, boolean isStream) {
            this.delimiter = delimiter;
            this.forceQuotes = forceQuotes;
            this.blockLevel = blockLevel;
            this.flowStyle = flowStyle;
            this.isStream = isStream;
        }

        public List<YamlEvent> getEvents() {
            return this.events;
        }
    }
}

