/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.utils;

import io.ballerina.lib.data.yaml.common.Types;
import io.ballerina.lib.data.yaml.utils.Constants;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;

public class OptionsUtils {
    private OptionsUtils() {
    }

    public static WriteConfig resolveWriteOptions(BMap<BString, Object> options) {
        Long indentationPolicy = (Long)options.get((Object)Constants.INDENTATION_POLICY);
        Long blockLevel = (Long)options.get((Object)Constants.BLOCK_LEVEL);
        Boolean canonical = (Boolean)options.get((Object)Constants.CANONICAL);
        Boolean useSingleQuotes = (Boolean)options.get((Object)Constants.USE_SINGLE_QUOTES);
        Boolean forceQuotes = (Boolean)options.get((Object)Constants.FORCE_QUOTES);
        BString schema = (BString)options.get((Object)Constants.SCHEMA);
        Boolean isStream = (Boolean)options.get((Object)Constants.IS_STREAM);
        Boolean flowStyle = (Boolean)options.get((Object)Constants.FLOW_STYLE);
        return new WriteConfig(Math.toIntExact(indentationPolicy), Math.toIntExact(blockLevel), canonical, useSingleQuotes, forceQuotes, Types.YAMLSchema.valueOf(schema.getValue()), isStream, flowStyle);
    }

    public static ReadConfig resolveReadConfig(BMap<BString, Object> options) {
        BString schema = (BString)options.get((Object)Constants.SCHEMA);
        Boolean allowAnchorRedefinition = (Boolean)options.get((Object)Constants.ALLOW_ANCHOR_REDEFINITION);
        Boolean allowMapEntryRedefinition = (Boolean)options.get((Object)Constants.ALLOW_MAP_ENTRY_REDEFINITION);
        Object allowDataProjection = options.get((Object)Constants.ALLOW_DATA_PROJECTION);
        if (allowDataProjection instanceof Boolean) {
            return new ReadConfig(Types.YAMLSchema.valueOf(schema.getValue()), allowAnchorRedefinition, allowMapEntryRedefinition, false, false, false, false);
        }
        Boolean nilAsOptionalField = (Boolean)((BMap)allowDataProjection).get((Object)Constants.NIL_AS_OPTIONAL_FIELD);
        Boolean absentAsNilableType = (Boolean)((BMap)allowDataProjection).get((Object)Constants.ABSENT_AS_NILABLE_TYPE);
        Boolean enableYamlStreamReorder = (Boolean)((BMap)allowDataProjection).get((Object)Constants.ENABLE_YAML_STREAM_REORDER);
        return new ReadConfig(Types.YAMLSchema.valueOf(schema.getValue()), allowAnchorRedefinition, allowMapEntryRedefinition, true, nilAsOptionalField, absentAsNilableType, enableYamlStreamReorder);
    }

    public record WriteConfig(int indentationPolicy, int blockLevel, boolean canonical, boolean useSingleQuotes, boolean forceQuotes, Types.YAMLSchema schema, boolean isStream, boolean flowStyle) {
    }

    public record ReadConfig(Types.YAMLSchema schema, boolean allowAnchorRedefinition, boolean allowMapEntryRedefinition, boolean allowDataProjection, boolean nilAsOptionalField, boolean absentAsNilableType, boolean enableYamlStreamReorder) {
    }
}

