/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import io.ballerina.compiler.api.ModuleID;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.util.Name;

public class BallerinaModuleID
implements ModuleID {
    private static final String ANON_ORG = "$anon";
    private final PackageID moduleID;
    private Name prefix;

    public BallerinaModuleID(PackageID moduleID) {
        this.moduleID = moduleID;
    }

    public BallerinaModuleID(PackageID moduleID, Name prefix) {
        this.moduleID = moduleID;
        this.prefix = prefix;
    }

    @Override
    public String orgName() {
        return this.moduleID.getOrgName().getValue();
    }

    @Override
    public String packageName() {
        return this.moduleID.getPkgName().getValue();
    }

    @Override
    public String moduleName() {
        return this.moduleID.getNameComps().stream().map(Name::getValue).collect(Collectors.joining("."));
    }

    @Override
    public String version() {
        return this.moduleID.getPackageVersion().getValue();
    }

    @Override
    public String modulePrefix() {
        if (this.prefix != null) {
            return this.prefix.getValue();
        }
        List<Name> nameComps = this.moduleID.getNameComps();
        this.prefix = nameComps.get(nameComps.size() - 1);
        return this.prefix.getValue();
    }

    public String toString() {
        if (ANON_ORG.equals(this.orgName())) {
            return ".";
        }
        return this.orgName() + "/" + this.moduleName() + ":" + this.version();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BallerinaModuleID target = (BallerinaModuleID)obj;
        return this.moduleID.equals(target.moduleID);
    }

    public int hashCode() {
        return this.moduleID.hashCode();
    }

    @Override
    public boolean isTestable() {
        return this.moduleID.isTestPkg;
    }
}

