/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.impl.BallerinaTypeBuilder;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.impl.util.FieldMap;
import io.ballerina.compiler.api.impl.util.SymbolUtils;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.projects.Document;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.parser.BLangNodeBuilder;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeResolver;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class BallerinaTypes
extends Types {
    private final TypeResolver typeResolver;

    public BallerinaTypes(BLangPackage bLangPackage, CompilerContext context) {
        super(bLangPackage, context);
        context.put(TYPES_KEY, this);
        this.typeResolver = TypeResolver.getInstance(context);
    }

    @Override
    public Optional<TypeSymbol> getType(Document document, String text) {
        Optional<BLangCompilationUnit> compilationUnit = SymbolUtils.getCompilationUnit(this.bLangPackage, document);
        if (compilationUnit.isEmpty()) {
            return Optional.empty();
        }
        SymbolEnv pkgEnv = this.symbolTable.pkgEnvMap.get(this.bLangPackage.symbol);
        return this.getType(text, pkgEnv, compilationUnit.get().getName());
    }

    @Override
    public Optional<TypeSymbol> getType(Document document, String text, Map<String, BLangPackage> importModules) {
        Optional<BLangCompilationUnit> compilationUnit = SymbolUtils.getCompilationUnit(this.bLangPackage, document);
        if (compilationUnit.isEmpty()) {
            return Optional.empty();
        }
        SymbolEnv pkgEnv = this.symbolTable.pkgEnvMap.get(this.bLangPackage.symbol);
        Name compUnitName = Names.fromString(compilationUnit.get().getName());
        importModules.forEach((prefix, importPackage) -> {
            importPackage.symbol.compUnit = compUnitName;
            pkgEnv.scope.define(Names.fromString(prefix), importPackage.symbol);
        });
        return this.getType(text, pkgEnv, compUnitName.getValue());
    }

    @Override
    public Optional<Symbol> getTypeByName(String org, String moduleName, String version, String typeDefName) {
        if (org == null || moduleName == null || version == null || typeDefName == null) {
            throw new IllegalArgumentException("Null parameters are not allowed. Found parameter values are org: " + org + " moduleName: " + moduleName + ", version: " + version + ", and typeDefName: " + typeDefName);
        }
        PackageID packageID = new PackageID(Names.fromString(org), Names.fromString(moduleName), Names.fromString(version));
        BPackageSymbol packageSymbol = this.packageCache.getSymbol(packageID);
        if (packageSymbol == null) {
            return Optional.empty();
        }
        SymbolEnv pkgEnv = this.symbolTable.pkgEnvMap.get(packageSymbol);
        Scope.ScopeEntry entry = pkgEnv.scope.lookup(Names.fromString(typeDefName));
        if (this.isValidTypeDef(entry.symbol)) {
            return Optional.of(this.symbolFactory.getBCompiledSymbol(entry.symbol, typeDefName));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Map<String, Symbol>> typesInModule(String org, String moduleName, String version) {
        if (org == null || moduleName == null || version == null) {
            throw new IllegalArgumentException("Null parameters are not allowed. Found parameter values are org: " + org + " moduleName: " + moduleName + ", and version: " + version);
        }
        PackageID packageID = new PackageID(Names.fromString(org), Names.fromString(moduleName), Names.fromString(version));
        BPackageSymbol packageSymbol = this.packageCache.getSymbol(packageID);
        if (packageSymbol == null) {
            return Optional.empty();
        }
        SymbolEnv pkgEnv = this.symbolTable.pkgEnvMap.get(packageSymbol);
        Scope pkgEnvScope = pkgEnv.scope;
        if (pkgEnvScope == null || pkgEnvScope.entries == null) {
            return Optional.empty();
        }
        FieldMap<String, Symbol> typeDefSymbols = new FieldMap<String, Symbol>();
        for (Scope.ScopeEntry scopeEntry : pkgEnvScope.entries.values()) {
            BSymbol bSymbol = scopeEntry.symbol;
            if (!this.isValidTypeDef(bSymbol)) continue;
            String typeDefName = bSymbol.getOriginalName().getValue();
            typeDefSymbols.put(typeDefName, this.symbolFactory.getBCompiledSymbol(bSymbol, typeDefName));
        }
        return Optional.of(Collections.unmodifiableMap(typeDefSymbols));
    }

    @Override
    public TypeBuilder builder() {
        return new BallerinaTypeBuilder(this.context);
    }

    private Optional<TypeSymbol> getType(String text, SymbolEnv pkgEnv, String compUnitName) {
        BType resolvedType;
        TypeDescriptorNode typeDescriptorNode = NodeParser.parseTypeDescriptor((String)text);
        if (typeDescriptorNode == null || typeDescriptorNode.hasDiagnostics()) {
            return Optional.empty();
        }
        BLangNodeBuilder bLangNodeBuilder = new BLangNodeBuilder(this.context, this.bLangPackage.packageID, compUnitName);
        BLangNode bLangNode = (BLangNode)typeDescriptorNode.apply((NodeTransformer)bLangNodeBuilder);
        if (bLangNode.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)bLangNode;
            BSymbol symbolOfVarRef = this.typeResolver.getSymbolOfVarRef(simpleVarRef.pos, pkgEnv, Names.fromString(simpleVarRef.pkgAlias.value), Names.fromString(simpleVarRef.variableName.value));
            resolvedType = symbolOfVarRef.type;
        } else if (bLangNode instanceof BLangType) {
            BLangType bLangType = (BLangType)bLangNode;
            try {
                this.typeResolver.resolveTypeDesc(bLangType, pkgEnv);
                resolvedType = bLangType.getBType();
            }
            catch (Throwable ignored) {
                return Optional.empty();
            }
        } else {
            return Optional.empty();
        }
        if (resolvedType.getKind() == TypeKind.OTHER) {
            return Optional.empty();
        }
        return Optional.of(TypesFactory.getInstance(this.context).getTypeDescriptor(resolvedType));
    }

    private boolean isValidTypeDef(BSymbol bSymbol) {
        return bSymbol != null && bSymbol.getOrigin() != SymbolOrigin.VIRTUAL && (bSymbol.getKind() == SymbolKind.TYPE_DEF || bSymbol.getKind() == SymbolKind.CONSTANT || bSymbol.getKind() == SymbolKind.ENUM || Symbols.isFlagOn(bSymbol.flags, 0x10000000L));
    }
}

