/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import io.ballerina.compiler.syntax.tree.AnnotAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.AnnotationDeclarationNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BracedExpressionNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ByteArrayLiteralNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ClientResourceAccessActionNode;
import io.ballerina.compiler.syntax.tree.ComputedResourceAccessSegmentNode;
import io.ballerina.compiler.syntax.tree.ConditionalExpressionNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.EnumMemberNode;
import io.ballerina.compiler.syntax.tree.ErrorConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.IndexedExpressionNode;
import io.ballerina.compiler.syntax.tree.LetExpressionNode;
import io.ballerina.compiler.syntax.tree.LetVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleXMLNamespaceDeclarationNode;
import io.ballerina.compiler.syntax.tree.NamedWorkerDeclarationNode;
import io.ballerina.compiler.syntax.tree.NilLiteralNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.OptionalFieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.QueryExpressionNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ResourcePathParameterNode;
import io.ballerina.compiler.syntax.tree.RestParameterNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SpreadFieldNode;
import io.ballerina.compiler.syntax.tree.StartActionNode;
import io.ballerina.compiler.syntax.tree.TableConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TransactionalExpressionNode;
import io.ballerina.compiler.syntax.tree.TrapExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeCastExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import io.ballerina.compiler.syntax.tree.TypeReferenceTypeDescNode;
import io.ballerina.compiler.syntax.tree.TypeTestExpressionNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.TypeofExpressionNode;
import io.ballerina.compiler.syntax.tree.UnaryExpressionNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.WaitActionNode;
import io.ballerina.compiler.syntax.tree.WildcardBindingPatternNode;
import io.ballerina.compiler.syntax.tree.XMLFilterExpressionNode;
import io.ballerina.compiler.syntax.tree.XMLNamespaceDeclarationNode;
import io.ballerina.compiler.syntax.tree.XMLStepExpressionNode;
import io.ballerina.tools.diagnostics.Location;
import java.util.Optional;

public class SyntaxNodeToLocationMapper
extends NodeTransformer<Optional<Location>> {
    public Optional<Location> transform(AnnotationNode annotationNode) {
        return (Optional)annotationNode.annotReference().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(AnnotationDeclarationNode annotationDeclarationNode) {
        return (Optional)annotationDeclarationNode.annotationTag().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(ClassDefinitionNode classDefinitionNode) {
        return (Optional)classDefinitionNode.className().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(ConstantDeclarationNode constantDeclarationNode) {
        return (Optional)constantDeclarationNode.variableName().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(EnumDeclarationNode enumDeclarationNode) {
        return (Optional)enumDeclarationNode.identifier().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(EnumMemberNode enumMemberNode) {
        return Optional.of(enumMemberNode.identifier().location());
    }

    public Optional<Location> transform(RecordFieldNode recordFieldNode) {
        return (Optional)recordFieldNode.fieldName().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(RecordFieldWithDefaultValueNode recordFieldWithDefaultValueNode) {
        return (Optional)recordFieldWithDefaultValueNode.fieldName().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(ObjectFieldNode objectFieldNode) {
        return (Optional)objectFieldNode.fieldName().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(FunctionDefinitionNode functionDefinitionNode) {
        return (Optional)functionDefinitionNode.functionName().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(DefaultableParameterNode defaultableParameterNode) {
        if (defaultableParameterNode.paramName().isEmpty()) {
            return Optional.empty();
        }
        return (Optional)((Token)defaultableParameterNode.paramName().get()).apply((NodeTransformer)this);
    }

    public Optional<Location> transform(RequiredParameterNode requiredParameterNode) {
        if (requiredParameterNode.paramName().isEmpty()) {
            return Optional.empty();
        }
        return (Optional)((Token)requiredParameterNode.paramName().get()).apply((NodeTransformer)this);
    }

    public Optional<Location> transform(RestParameterNode restParameterNode) {
        if (restParameterNode.paramName().isEmpty()) {
            return Optional.empty();
        }
        return (Optional)((Token)restParameterNode.paramName().get()).apply((NodeTransformer)this);
    }

    public Optional<Location> transform(ClientResourceAccessActionNode clientResourceAccessActionNode) {
        if (clientResourceAccessActionNode.methodName().isEmpty()) {
            return Optional.of(clientResourceAccessActionNode.slashToken().location());
        }
        return Optional.of(((SimpleNameReferenceNode)clientResourceAccessActionNode.methodName().get()).location());
    }

    public Optional<Location> transform(ComputedResourceAccessSegmentNode computedResourceAccessSegmentNode) {
        return (Optional)computedResourceAccessSegmentNode.expression().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(ResourcePathParameterNode resourcePathParameterNode) {
        if (resourcePathParameterNode.paramName().isEmpty()) {
            return Optional.empty();
        }
        return (Optional)((Token)resourcePathParameterNode.paramName().get()).apply((NodeTransformer)this);
    }

    public Optional<Location> transform(FunctionCallExpressionNode functionCallExpressionNode) {
        return (Optional)functionCallExpressionNode.functionName().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(MethodDeclarationNode methodDeclarationNode) {
        return (Optional)methodDeclarationNode.methodName().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(MethodCallExpressionNode methodCallExpressionNode) {
        return (Optional)methodCallExpressionNode.methodName().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(RemoteMethodCallActionNode remoteMethodCallActionNode) {
        return (Optional)remoteMethodCallActionNode.methodName().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(ImportDeclarationNode importDeclarationNode) {
        if (importDeclarationNode.prefix().isPresent()) {
            return (Optional)((ImportPrefixNode)importDeclarationNode.prefix().get()).apply((NodeTransformer)this);
        }
        return (Optional)((IdentifierToken)importDeclarationNode.moduleName().get(importDeclarationNode.moduleName().size() - 1)).apply((NodeTransformer)this);
    }

    public Optional<Location> transform(ImportPrefixNode importPrefixNode) {
        return (Optional)importPrefixNode.prefix().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(QualifiedNameReferenceNode qualifiedNameReferenceNode) {
        return (Optional)qualifiedNameReferenceNode.identifier().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(SimpleNameReferenceNode simpleNameReferenceNode) {
        return (Optional)simpleNameReferenceNode.name().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(StartActionNode startActionNode) {
        return Optional.of(startActionNode.location());
    }

    public Optional<Location> transform(WaitActionNode waitActionNode) {
        return Optional.of(waitActionNode.location());
    }

    public Optional<Location> transform(TypeDefinitionNode typeDefinitionNode) {
        return (Optional)typeDefinitionNode.typeName().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(VariableDeclarationNode variableDeclarationNode) {
        return (Optional)variableDeclarationNode.typedBindingPattern().bindingPattern().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(ModuleVariableDeclarationNode moduleVariableDeclarationNode) {
        return (Optional)moduleVariableDeclarationNode.typedBindingPattern().bindingPattern().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(LetVariableDeclarationNode letVariableDeclarationNode) {
        return (Optional)letVariableDeclarationNode.typedBindingPattern().bindingPattern().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(TypedBindingPatternNode typedBindingPatternNode) {
        return (Optional)typedBindingPatternNode.bindingPattern().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(CaptureBindingPatternNode captureBindingPatternNode) {
        return (Optional)captureBindingPatternNode.variableName().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(WildcardBindingPatternNode wildcardBindingPatternNode) {
        return (Optional)wildcardBindingPatternNode.underscoreToken().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(NamedWorkerDeclarationNode namedWorkerDeclarationNode) {
        return (Optional)namedWorkerDeclarationNode.workerName().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(XMLNamespaceDeclarationNode xmlNamespaceDeclarationNode) {
        if (xmlNamespaceDeclarationNode.namespacePrefix().isEmpty()) {
            return Optional.empty();
        }
        return (Optional)((IdentifierToken)xmlNamespaceDeclarationNode.namespacePrefix().get()).apply((NodeTransformer)this);
    }

    public Optional<Location> transform(ModuleXMLNamespaceDeclarationNode moduleXMLNamespaceDeclarationNode) {
        if (moduleXMLNamespaceDeclarationNode.namespacePrefix().isEmpty()) {
            return Optional.empty();
        }
        return (Optional)((IdentifierToken)moduleXMLNamespaceDeclarationNode.namespacePrefix().get()).apply((NodeTransformer)this);
    }

    public Optional<Location> transform(TypeReferenceTypeDescNode typeReferenceTypeDescNode) {
        return (Optional)typeReferenceTypeDescNode.typeRef().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(TypeReferenceNode typeReferenceNode) {
        return (Optional)typeReferenceNode.typeName().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(ServiceDeclarationNode serviceDeclarationNode) {
        if (serviceDeclarationNode.qualifiers().isEmpty()) {
            return Optional.of(serviceDeclarationNode.serviceKeyword().location());
        }
        return (Optional)((Token)serviceDeclarationNode.qualifiers().get(0)).apply((NodeTransformer)this);
    }

    public Optional<Location> transform(Token token) {
        return Optional.of(token.location());
    }

    public Optional<Location> transform(IdentifierToken identifier) {
        return Optional.of(identifier.location());
    }

    public Optional<Location> transform(NilLiteralNode nilLiteralNode) {
        return Optional.of(nilLiteralNode.location());
    }

    public Optional<Location> transform(BasicLiteralNode basicLiteralNode) {
        return (Optional)basicLiteralNode.literalToken().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(ByteArrayLiteralNode byteArrayLiteralNode) {
        return Optional.of(byteArrayLiteralNode.location());
    }

    public Optional<Location> transform(TemplateExpressionNode templateExpressionNode) {
        return Optional.of(templateExpressionNode.location());
    }

    public Optional<Location> transform(ListConstructorExpressionNode listConstructorExpressionNode) {
        return Optional.of(listConstructorExpressionNode.location());
    }

    public Optional<Location> transform(TableConstructorExpressionNode tableConstructorExpressionNode) {
        return Optional.of(tableConstructorExpressionNode.location());
    }

    public Optional<Location> transform(MappingConstructorExpressionNode mappingConstructorExpressionNode) {
        return Optional.of(mappingConstructorExpressionNode.location());
    }

    public Optional<Location> transform(ObjectConstructorExpressionNode objectConstructorExpressionNode) {
        return Optional.of(objectConstructorExpressionNode.location());
    }

    public Optional<Location> transform(ExplicitNewExpressionNode explicitNewExpressionNode) {
        return Optional.of(explicitNewExpressionNode.location());
    }

    public Optional<Location> transform(ImplicitNewExpressionNode implicitNewExpressionNode) {
        return Optional.of(implicitNewExpressionNode.location());
    }

    public Optional<Location> transform(BuiltinSimpleNameReferenceNode builtinSimpleNameReferenceNode) {
        return (Optional)builtinSimpleNameReferenceNode.name().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(FieldAccessExpressionNode fieldAccessExpressionNode) {
        return Optional.of(fieldAccessExpressionNode.location());
    }

    public Optional<Location> transform(OptionalFieldAccessExpressionNode optionalFieldAccessExpressionNode) {
        return Optional.of(optionalFieldAccessExpressionNode.location());
    }

    public Optional<Location> transform(AnnotAccessExpressionNode annotAccessExpressionNode) {
        return Optional.of(annotAccessExpressionNode.location());
    }

    public Optional<Location> transform(IndexedExpressionNode indexedExpressionNode) {
        return Optional.of(indexedExpressionNode.location());
    }

    public Optional<Location> transform(ErrorConstructorExpressionNode errorConstructorExpressionNode) {
        return Optional.of(errorConstructorExpressionNode.location());
    }

    public Optional<Location> transform(ExplicitAnonymousFunctionExpressionNode explicitAnonymousFunctionExpressionNode) {
        return Optional.of(explicitAnonymousFunctionExpressionNode.location());
    }

    public Optional<Location> transform(ImplicitAnonymousFunctionExpressionNode implicitAnonymousFunctionExpressionNode) {
        return Optional.of(implicitAnonymousFunctionExpressionNode.location());
    }

    public Optional<Location> transform(LetExpressionNode letExpressionNode) {
        return Optional.of(letExpressionNode.location());
    }

    public Optional<Location> transform(TypeCastExpressionNode typeCastExpressionNode) {
        return Optional.of(typeCastExpressionNode.location());
    }

    public Optional<Location> transform(TypeofExpressionNode typeofExpressionNode) {
        return Optional.of(typeofExpressionNode.location());
    }

    public Optional<Location> transform(UnaryExpressionNode unaryExpressionNode) {
        return Optional.of(unaryExpressionNode.location());
    }

    public Optional<Location> transform(TypeTestExpressionNode typeTestExpressionNode) {
        return Optional.of(typeTestExpressionNode.location());
    }

    public Optional<Location> transform(BinaryExpressionNode binaryExpressionNode) {
        return Optional.of(binaryExpressionNode.location());
    }

    public Optional<Location> transform(ConditionalExpressionNode conditionalExpressionNode) {
        return Optional.of(conditionalExpressionNode.location());
    }

    public Optional<Location> transform(CheckExpressionNode checkExpressionNode) {
        return Optional.of(checkExpressionNode.location());
    }

    public Optional<Location> transform(TrapExpressionNode trapExpressionNode) {
        return Optional.of(trapExpressionNode.location());
    }

    public Optional<Location> transform(QueryExpressionNode queryExpressionNode) {
        return Optional.of(queryExpressionNode.location());
    }

    public Optional<Location> transform(XMLFilterExpressionNode xmlFilterExpressionNode) {
        return Optional.of(xmlFilterExpressionNode.location());
    }

    public Optional<Location> transform(XMLStepExpressionNode xmlStepExpressionNode) {
        return Optional.of(xmlStepExpressionNode.location());
    }

    public Optional<Location> transform(TransactionalExpressionNode transactionalExpressionNode) {
        return Optional.of(transactionalExpressionNode.location());
    }

    public Optional<Location> transform(BracedExpressionNode bracedExpressionNode) {
        return (Optional)bracedExpressionNode.expression().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(PositionalArgumentNode positionalArgumentNode) {
        return (Optional)positionalArgumentNode.expression().apply((NodeTransformer)this);
    }

    public Optional<Location> transform(SpecificFieldNode specificFieldNode) {
        return Optional.of(specificFieldNode.location());
    }

    public Optional<Location> transform(SpreadFieldNode spreadFieldNode) {
        return Optional.of(spreadFieldNode.location());
    }

    protected Optional<Location> transformSyntaxNode(Node node) {
        return Optional.empty();
    }
}

