/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.impl.LangLibrary;
import io.ballerina.compiler.api.impl.symbols.BallerinaClassSymbol;
import io.ballerina.compiler.api.impl.util.SymbolUtils;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public abstract class AbstractTypeSymbol
implements TypeSymbol {
    protected final CompilerContext context;
    protected List<FunctionSymbol> langLibFunctions;
    private final TypeDescKind typeDescKind;
    private final BType bType;

    public AbstractTypeSymbol(CompilerContext context, TypeDescKind typeDescKind, BType bType) {
        this.context = context;
        this.typeDescKind = typeDescKind;
        this.bType = bType;
    }

    @Override
    public TypeDescKind typeKind() {
        return this.typeDescKind;
    }

    @Override
    public Optional<String> getName() {
        return Optional.empty();
    }

    @Override
    public Optional<ModuleSymbol> getModule() {
        return Optional.empty();
    }

    @Override
    public abstract String signature();

    @Override
    public SymbolKind kind() {
        return SymbolKind.TYPE;
    }

    @Override
    public Location location() {
        return null;
    }

    @Override
    public Optional<Location> getLocation() {
        return Optional.empty();
    }

    @Override
    public List<FunctionSymbol> langLibMethods() {
        if (this.langLibFunctions == null) {
            LangLibrary langLibrary = LangLibrary.getInstance(this.context);
            List<FunctionSymbol> functions = langLibrary.getMethods(this.getBType());
            this.langLibFunctions = this.filterLangLibMethods(functions, this.getBType());
        }
        return this.langLibFunctions;
    }

    @Override
    public boolean assignableTo(TypeSymbol targetType) {
        Types types = Types.getInstance(this.context);
        return types.isAssignable(this.bType, this.getTargetBType(targetType));
    }

    @Override
    public boolean subtypeOf(TypeSymbol targetType) {
        Types types = Types.getInstance(this.context);
        return types.isAssignable(this.bType, this.getTargetBType(targetType));
    }

    @Override
    public boolean nameEquals(String name) {
        Optional<String> symbolName = this.getName();
        if (symbolName.isEmpty() || name == null) {
            return false;
        }
        String symName = symbolName.get();
        if (name.equals(symName)) {
            return true;
        }
        return SymbolUtils.unescapeUnicode(name).equals(SymbolUtils.unescapeUnicode(symName));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeSymbol)) {
            return false;
        }
        Types types = Types.getInstance(this.context);
        return types.isSameTypeIncludingTags(this.bType, ((AbstractTypeSymbol)obj).getBType());
    }

    public int hashCode() {
        return this.bType.hashCode();
    }

    public BType getBType() {
        return this.bType;
    }

    protected List<FunctionSymbol> filterLangLibMethods(List<FunctionSymbol> functions, BType internalType) {
        Types types = Types.getInstance(this.context);
        ArrayList<FunctionSymbol> filteredFunctions = new ArrayList<FunctionSymbol>();
        for (FunctionSymbol function : functions) {
            List<ParameterSymbol> functionParams = function.typeDescriptor().params().get();
            if (functionParams.isEmpty()) {
                Optional<ParameterSymbol> restParamOptional = function.typeDescriptor().restParam();
                if (!restParamOptional.isPresent()) continue;
                BArrayType restArrayType = (BArrayType)((AbstractTypeSymbol)restParamOptional.get().typeDescriptor()).getBType();
                if (!types.isAssignable(internalType, restArrayType.eType)) continue;
                filteredFunctions.add(function);
                continue;
            }
            ParameterSymbol firstParam = functionParams.get(0);
            BType firstParamType = ((AbstractTypeSymbol)firstParam.typeDescriptor()).getBType();
            if (!types.isAssignable(internalType, firstParamType)) continue;
            filteredFunctions.add(function);
        }
        return filteredFunctions;
    }

    private BType getTargetBType(TypeSymbol typeSymbol) {
        if (typeSymbol.kind() == SymbolKind.TYPE) {
            return ((AbstractTypeSymbol)typeSymbol).getBType();
        }
        return ((BallerinaClassSymbol)typeSymbol).getBType();
    }
}

