/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.symbols.BallerinaObjectFieldSymbol;
import io.ballerina.compiler.api.symbols.ClassFieldSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.SymbolKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaClassFieldSymbol
extends BallerinaObjectFieldSymbol
implements ClassFieldSymbol {
    public BallerinaClassFieldSymbol(CompilerContext context, BField bField) {
        super(context, bField, SymbolKind.CLASS_FIELD);
    }

    @Override
    public boolean hasDefaultValue() {
        return this.bField.symbol.isDefaultable;
    }

    @Override
    public List<Qualifier> qualifiers() {
        if (this.qualifiers != null) {
            return this.qualifiers;
        }
        long symFlags = this.bField.symbol.flags;
        ArrayList<Qualifier> quals = new ArrayList<Qualifier>();
        if (Symbols.isFlagOn(symFlags, 1L)) {
            quals.add(Qualifier.PUBLIC);
        } else if (Symbols.isFlagOn(symFlags, 1024L)) {
            quals.add(Qualifier.PRIVATE);
        }
        if (Symbols.isFlagOn(symFlags, 4L)) {
            quals.add(Qualifier.FINAL);
        }
        this.qualifiers = Collections.unmodifiableList(quals);
        return this.qualifiers;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

