/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaClassFieldSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.impl.util.FieldMap;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ClassFieldSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaClassSymbol
extends BallerinaSymbol
implements ClassSymbol {
    private final ObjectTypeSymbol typeDescriptor;
    private final List<Qualifier> qualifiers;
    private final List<AnnotationSymbol> annots;
    private final List<AnnotationAttachmentSymbol> annotAttachments;
    private final boolean deprecated;
    private final BClassSymbol internalSymbol;
    private final CompilerContext context;
    private final Documentation docAttachment;
    private MethodSymbol initMethod;
    private Map<String, ClassFieldSymbol> classFields;

    protected BallerinaClassSymbol(CompilerContext context, String name, List<Qualifier> qualifiers, List<AnnotationSymbol> annots, List<AnnotationAttachmentSymbol> annotAttachments, ObjectTypeSymbol typeDescriptor, BClassSymbol classSymbol) {
        super(name, SymbolKind.CLASS, classSymbol, context);
        this.qualifiers = Collections.unmodifiableList(qualifiers);
        this.annots = Collections.unmodifiableList(annots);
        this.annotAttachments = Collections.unmodifiableList(annotAttachments);
        this.docAttachment = this.getDocAttachment(classSymbol);
        this.typeDescriptor = typeDescriptor;
        this.deprecated = Symbols.isFlagOn(classSymbol.flags, 16L);
        this.internalSymbol = classSymbol;
        this.context = context;
    }

    @Override
    public Map<String, ClassFieldSymbol> fieldDescriptors() {
        if (this.classFields != null) {
            return this.classFields;
        }
        FieldMap<String, BallerinaClassFieldSymbol> fields = new FieldMap<String, BallerinaClassFieldSymbol>();
        BObjectType type = (BObjectType)this.getBType();
        for (BField field : type.fields.values()) {
            fields.put(field.symbol.getOriginalName().value, new BallerinaClassFieldSymbol(this.context, field));
        }
        this.classFields = Collections.unmodifiableMap(fields);
        return this.classFields;
    }

    @Override
    public Map<String, MethodSymbol> methods() {
        return this.typeDescriptor.methods();
    }

    @Override
    public Optional<MethodSymbol> initMethod() {
        if (this.initMethod == null && this.internalSymbol.initializerFunc != null) {
            SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
            this.initMethod = symbolFactory.createMethodSymbol(this.internalSymbol.initializerFunc.symbol, this.internalSymbol.initializerFunc.symbol.getOriginalName().value);
        }
        return Optional.ofNullable(this.initMethod);
    }

    @Override
    public List<TypeSymbol> typeInclusions() {
        return this.typeDescriptor.typeInclusions();
    }

    @Override
    public List<AnnotationSymbol> annotations() {
        return this.annots;
    }

    @Override
    public List<AnnotationAttachmentSymbol> annotAttachments() {
        return this.annotAttachments;
    }

    @Override
    public Optional<Documentation> documentation() {
        return Optional.ofNullable(this.docAttachment);
    }

    @Override
    public TypeDescKind typeKind() {
        return TypeDescKind.OBJECT;
    }

    @Override
    public String signature() {
        if (this.getName().get().startsWith("$anonType$")) {
            return this.typeDescriptor.signature();
        }
        return this.getName().get();
    }

    @Override
    public List<FunctionSymbol> langLibMethods() {
        return this.typeDescriptor.langLibMethods();
    }

    @Override
    public boolean assignableTo(TypeSymbol targetType) {
        Types types = Types.getInstance(this.context);
        return types.isAssignable(this.internalSymbol.type, this.getTargetBType(targetType));
    }

    @Override
    public boolean subtypeOf(TypeSymbol targetType) {
        Types types = Types.getInstance(this.context);
        return types.isAssignable(this.internalSymbol.type, this.getTargetBType(targetType));
    }

    @Override
    public boolean deprecated() {
        return this.deprecated;
    }

    @Override
    public List<Qualifier> qualifiers() {
        return this.qualifiers;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }

    BType getBType() {
        return this.internalSymbol.type;
    }

    private BType getTargetBType(TypeSymbol typeSymbol) {
        if (typeSymbol.kind() == SymbolKind.TYPE) {
            return ((AbstractTypeSymbol)typeSymbol).getBType();
        }
        return ((BallerinaClassSymbol)typeSymbol).getBType();
    }

    public static class ClassSymbolBuilder
    extends BallerinaSymbol.SymbolBuilder<ClassSymbolBuilder> {
        protected List<Qualifier> qualifiers = new ArrayList<Qualifier>();
        protected List<AnnotationSymbol> annots = new ArrayList<AnnotationSymbol>();
        protected List<AnnotationAttachmentSymbol> annotAttachments = new ArrayList<AnnotationAttachmentSymbol>();
        protected ObjectTypeSymbol typeDescriptor;

        public ClassSymbolBuilder(CompilerContext context, String name, BSymbol symbol) {
            super(name, SymbolKind.CLASS, symbol, context);
        }

        public ClassSymbolBuilder withTypeDescriptor(ObjectTypeSymbol typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public ClassSymbolBuilder withQualifier(Qualifier qualifier) {
            this.qualifiers.add(qualifier);
            return this;
        }

        public ClassSymbolBuilder withAnnotation(AnnotationSymbol annot) {
            this.annots.add(annot);
            return this;
        }

        public ClassSymbolBuilder withAnnotationAttachment(AnnotationAttachmentSymbol annotAttachment) {
            this.annotAttachments.add(annotAttachment);
            return this;
        }

        @Override
        public BallerinaClassSymbol build() {
            return new BallerinaClassSymbol(this.context, this.name, this.qualifiers, this.annots, this.annotAttachments, this.typeDescriptor, (BClassSymbol)this.bSymbol);
        }
    }
}

