/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.symbols.BallerinaVariableSymbol;
import io.ballerina.compiler.api.impl.values.BallerinaConstantValue;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaConstantSymbol
extends BallerinaVariableSymbol
implements ConstantSymbol {
    private final BallerinaConstantValue constValue;
    private final TypeSymbol broaderType;

    private BallerinaConstantSymbol(String name, List<Qualifier> qualifiers, List<AnnotationSymbol> annots, List<AnnotationAttachmentSymbol> annotAttachments, TypeSymbol typeDescriptor, TypeSymbol broaderType, BallerinaConstantValue constValue, BSymbol bSymbol, CompilerContext context) {
        super(name, Symbols.isFlagOn(bSymbol.flags, 0x20000000000L) ? SymbolKind.ENUM_MEMBER : SymbolKind.CONSTANT, qualifiers, annots, annotAttachments, typeDescriptor, bSymbol, context);
        this.constValue = constValue;
        this.broaderType = broaderType;
    }

    @Override
    public Object constValue() {
        return this.constValue;
    }

    @Override
    public Optional<String> resolvedValue() {
        if (this.constValue == null) {
            return Optional.empty();
        }
        return Optional.of(this.stringValueOf(this.constValue));
    }

    @Override
    public TypeSymbol broaderTypeDescriptor() {
        return this.broaderType;
    }

    @Override
    public TypeDescKind typeKind() {
        return TypeDescKind.SINGLETON;
    }

    @Override
    public String signature() {
        return this.getInternalSymbol().name.value;
    }

    @Override
    public List<FunctionSymbol> langLibMethods() {
        return this.typeDescriptor().langLibMethods();
    }

    @Override
    public boolean assignableTo(TypeSymbol targetType) {
        return this.typeDescriptor().subtypeOf(targetType);
    }

    @Override
    public boolean subtypeOf(TypeSymbol targetType) {
        return this.typeDescriptor().subtypeOf(targetType);
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }

    private String stringValueOf(BallerinaConstantValue value) {
        if (value == null) {
            return null;
        }
        Object object = value.value();
        if (object instanceof BallerinaConstantValue) {
            BallerinaConstantValue ballerinaConstantValue = (BallerinaConstantValue)object;
            return this.stringValueOf(ballerinaConstantValue);
        }
        object = value.value();
        if (object instanceof HashMap) {
            HashMap map = (HashMap)object;
            StringJoiner joiner = new StringJoiner(", ", "{", "}");
            map.forEach((k, v) -> {
                StringBuilder builder = new StringBuilder();
                builder.append(k).append(": ");
                if (v instanceof BallerinaConstantValue) {
                    BallerinaConstantValue ballerinaConstantValue = (BallerinaConstantValue)v;
                    builder.append(this.stringValueOf(ballerinaConstantValue));
                } else {
                    builder.append(this.toStringVal(v, value.valueType()));
                }
                joiner.add(builder.toString());
            });
            return joiner.toString();
        }
        return this.toStringVal(value.value(), value.valueType());
    }

    private String toStringVal(Object obj, TypeSymbol valType) {
        if (obj instanceof String && valType.typeKind() == TypeDescKind.STRING) {
            return String.format("\"%s\"", obj);
        }
        return String.valueOf(obj);
    }

    @Override
    public TypeSymbol originalType() {
        return this.broaderTypeDescriptor();
    }

    public static class ConstantSymbolBuilder
    extends BallerinaVariableSymbol.VariableSymbolBuilder {
        private BallerinaConstantValue constantValue;
        private TypeSymbol broaderType;

        public ConstantSymbolBuilder(String name, BSymbol symbol, CompilerContext context) {
            super(name, symbol, context);
        }

        @Override
        public BallerinaConstantSymbol build() {
            return new BallerinaConstantSymbol(this.name, this.qualifiers, this.annots, this.annotAttachments, this.typeDescriptor, this.broaderType, this.constantValue, this.bSymbol, this.context);
        }

        public ConstantSymbolBuilder withConstValue(BallerinaConstantValue constValue) {
            this.constantValue = constValue;
            return this;
        }

        @Override
        public ConstantSymbolBuilder withTypeDescriptor(TypeSymbol typeDescriptor) {
            super.withTypeDescriptor(typeDescriptor);
            return this;
        }

        public ConstantSymbolBuilder withBroaderTypeDescriptor(TypeSymbol typeDescriptor) {
            this.broaderType = typeDescriptor;
            return this;
        }
    }
}

