/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaMapTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.ErrorTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class BallerinaErrorTypeSymbol
extends AbstractTypeSymbol
implements ErrorTypeSymbol {
    private static final String ANON_ORG = "$anon";
    private TypeSymbol detail;
    private String signature;
    private ModuleSymbol module;
    private boolean moduleEvaluated;

    public BallerinaErrorTypeSymbol(CompilerContext context, BErrorType errorType) {
        super(context, TypeDescKind.ERROR, errorType);
    }

    @Override
    public TypeSymbol detailTypeDescriptor() {
        if (this.detail == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            this.detail = typesFactory.getTypeDescriptor(((BErrorType)this.getBType()).getDetailType());
        }
        return this.detail;
    }

    @Override
    public Optional<ModuleSymbol> getModule() {
        if (this.module != null || this.moduleEvaluated) {
            return Optional.ofNullable(this.module);
        }
        this.moduleEvaluated = true;
        BSymbol symbol = this.getBType().tsymbol.owner;
        while (symbol != null && !(symbol instanceof BPackageSymbol)) {
            symbol = symbol.owner;
        }
        if (symbol == null) {
            return Optional.empty();
        }
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        this.module = symbolFactory.createModuleSymbol((BPackageSymbol)symbol, symbol.name.value);
        return Optional.of(this.module);
    }

    @Override
    public String signature() {
        if (this.signature != null) {
            return this.signature;
        }
        Object definitionName = "error";
        if (!this.isDefaultDetailTypeDesc()) {
            definitionName = (String)definitionName + "<" + this.detailTypeDescriptor().signature() + ">";
        }
        if (this.getModule().isEmpty()) {
            this.signature = definitionName;
            return this.signature;
        }
        ModuleID moduleID = this.getModule().get().id();
        this.signature = "lang.annotations".equals(moduleID.moduleName()) && "ballerina".equals(moduleID.orgName()) ? definitionName : (!this.isAnonOrg(moduleID) ? moduleID.orgName() + String.valueOf(Names.ORG_NAME_SEPARATOR) + moduleID.moduleName() + String.valueOf(Names.VERSION_SEPARATOR) + moduleID.version() + ":" + (String)definitionName : definitionName);
        return this.signature;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }

    private boolean isDefaultDetailTypeDesc() {
        BallerinaMapTypeSymbol mapTypeSymbol;
        Optional<String> name;
        if (this.detailTypeDescriptor().typeKind() == TypeDescKind.MAP && (name = (mapTypeSymbol = (BallerinaMapTypeSymbol)this.detailTypeDescriptor()).typeParam().getName()).isPresent()) {
            if (name.get().equals("Cloneable") && mapTypeSymbol.typeParam().getModule().isPresent()) {
                ModuleID moduleID = mapTypeSymbol.typeParam().getModule().get().id();
                return moduleID.orgName().equals("ballerina") && moduleID.packageName().equals("lang.value");
            }
            return name.get().equals("__Cloneable");
        }
        return false;
    }

    private boolean isAnonOrg(ModuleID moduleID) {
        return ANON_ORG.equals(moduleID.orgName());
    }
}

