/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.LangLibrary;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaIntersectionTypeSymbol
extends AbstractTypeSymbol
implements IntersectionTypeSymbol {
    private List<TypeSymbol> memberTypes;
    private TypeSymbol effectiveType;
    private String signature;

    public BallerinaIntersectionTypeSymbol(CompilerContext context, BIntersectionType intersectionType) {
        super(context, TypeDescKind.INTERSECTION, intersectionType);
    }

    @Override
    public List<TypeSymbol> memberTypeDescriptors() {
        if (this.memberTypes != null) {
            return this.memberTypes;
        }
        ArrayList<TypeSymbol> members = new ArrayList<TypeSymbol>();
        TypesFactory typesFactory = TypesFactory.getInstance(this.context);
        for (BType memberType : ((BIntersectionType)this.getBType()).getConstituentTypes()) {
            members.add(typesFactory.getTypeDescriptor(memberType));
        }
        this.memberTypes = Collections.unmodifiableList(members);
        return this.memberTypes;
    }

    @Override
    public TypeSymbol effectiveTypeDescriptor() {
        BType effectiveType;
        if (this.effectiveType != null) {
            return this.effectiveType;
        }
        TypesFactory typesFactory = TypesFactory.getInstance(this.context);
        this.effectiveType = typesFactory.getTypeDescriptor(effectiveType, (effectiveType = ((BIntersectionType)this.getBType()).effectiveType) != null ? effectiveType.tsymbol : null, false, false, true);
        return this.effectiveType;
    }

    @Override
    public List<FunctionSymbol> langLibMethods() {
        if (this.langLibFunctions == null) {
            if (this.effectiveTypeDescriptor().typeKind() == TypeDescKind.OBJECT) {
                this.langLibFunctions = this.effectiveTypeDescriptor().langLibMethods();
            } else if (this.effectiveTypeDescriptor().typeKind() == TypeDescKind.TYPE_REFERENCE) {
                TypeReferenceTypeSymbol typeRef = (TypeReferenceTypeSymbol)this.effectiveTypeDescriptor();
                this.langLibFunctions = typeRef.typeDescriptor().langLibMethods();
            } else {
                LangLibrary langLibrary = LangLibrary.getInstance(this.context);
                List<FunctionSymbol> functions = langLibrary.getMethods(((AbstractTypeSymbol)this.effectiveTypeDescriptor()).getBType());
                this.langLibFunctions = this.filterLangLibMethods(functions, this.getBType());
            }
        }
        return this.langLibFunctions;
    }

    @Override
    public String signature() {
        if (this.signature != null) {
            return this.signature;
        }
        List<TypeSymbol> memberTypes = this.memberTypeDescriptors();
        StringJoiner joiner = new StringJoiner(" & ");
        memberTypes.forEach(typeDescriptor -> joiner.add(typeDescriptor.signature()));
        this.signature = joiner.toString();
        return this.signature;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

