/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.BallerinaModuleID;
import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.BallerinaClassSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaConstantSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaEnumSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaFunctionSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.EnumSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BEnumSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;

public class BallerinaModule
extends BallerinaSymbol
implements ModuleSymbol {
    private final BPackageSymbol packageSymbol;
    private List<TypeDefinitionSymbol> typeDefs;
    private List<ClassSymbol> classes;
    private List<FunctionSymbol> functions;
    private List<ConstantSymbol> constants;
    private List<EnumSymbol> enums;
    private List<Symbol> allSymbols;
    private ModuleID id;

    protected BallerinaModule(CompilerContext context, String name, BPackageSymbol packageSymbol) {
        super(name, SymbolKind.MODULE, packageSymbol, context);
        this.packageSymbol = packageSymbol;
    }

    @Override
    public Optional<ModuleSymbol> getModule() {
        return Optional.of(this);
    }

    @Override
    public ModuleID id() {
        if (this.id != null) {
            return this.id;
        }
        BallerinaModuleID moduleID = this.packageSymbol.importPrefix != null ? new BallerinaModuleID(this.packageSymbol.pkgID, this.packageSymbol.importPrefix) : new BallerinaModuleID(this.packageSymbol.pkgID);
        this.id = moduleID;
        return this.id;
    }

    @Override
    public List<FunctionSymbol> functions() {
        if (this.functions != null) {
            return this.functions;
        }
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        ArrayList<BallerinaFunctionSymbol> functions = new ArrayList<BallerinaFunctionSymbol>();
        for (Map.Entry<Name, Scope.ScopeEntry> entry : this.packageSymbol.scope.entries.entrySet()) {
            Scope.ScopeEntry scopeEntry = entry.getValue();
            if (scopeEntry.symbol == null || scopeEntry.symbol.kind != org.ballerinalang.model.symbols.SymbolKind.FUNCTION || !Symbols.isFlagOn(scopeEntry.symbol.flags, 1L) || scopeEntry.symbol.origin != SymbolOrigin.SOURCE && scopeEntry.symbol.origin != SymbolOrigin.COMPILED_SOURCE) continue;
            String funcName = scopeEntry.symbol.getOriginalName().getValue();
            functions.add(symbolFactory.createFunctionSymbol((BInvokableSymbol)scopeEntry.symbol, funcName));
        }
        this.functions = Collections.unmodifiableList(functions);
        return this.functions;
    }

    @Override
    public List<TypeDefinitionSymbol> typeDefinitions() {
        if (this.typeDefs == null) {
            this.typeDefs = this.allSymbols().stream().filter(symbol -> symbol.kind() == SymbolKind.TYPE_DEFINITION).map(symbol -> (TypeDefinitionSymbol)symbol).toList();
        }
        return this.typeDefs;
    }

    @Override
    public List<ClassSymbol> classes() {
        if (this.classes != null) {
            return this.classes;
        }
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        ArrayList<BallerinaClassSymbol> classes = new ArrayList<BallerinaClassSymbol>();
        for (Map.Entry<Name, Scope.ScopeEntry> entry : this.packageSymbol.scope.entries.entrySet()) {
            Scope.ScopeEntry scopeEntry = entry.getValue();
            if (!(scopeEntry.symbol instanceof BClassSymbol) || (scopeEntry.symbol.flags & 1L) != 1L) continue;
            String constName = scopeEntry.symbol.getOriginalName().getValue();
            classes.add(symbolFactory.createClassSymbol((BClassSymbol)scopeEntry.symbol, constName));
        }
        this.classes = Collections.unmodifiableList(classes);
        return this.classes;
    }

    @Override
    public List<ConstantSymbol> constants() {
        if (this.constants != null) {
            return this.constants;
        }
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        ArrayList<BallerinaConstantSymbol> constants = new ArrayList<BallerinaConstantSymbol>();
        for (Map.Entry<Name, Scope.ScopeEntry> entry : this.packageSymbol.scope.entries.entrySet()) {
            Scope.ScopeEntry scopeEntry = entry.getValue();
            if (!(scopeEntry.symbol instanceof BConstantSymbol) || (scopeEntry.symbol.flags & 1L) != 1L) continue;
            String constName = scopeEntry.symbol.getOriginalName().getValue();
            constants.add(symbolFactory.createConstantSymbol((BConstantSymbol)scopeEntry.symbol, constName));
        }
        this.constants = Collections.unmodifiableList(constants);
        return this.constants;
    }

    @Override
    public List<EnumSymbol> enums() {
        if (this.enums != null) {
            return this.enums;
        }
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        ArrayList<BallerinaEnumSymbol> enums = new ArrayList<BallerinaEnumSymbol>();
        for (Map.Entry<Name, Scope.ScopeEntry> entry : this.packageSymbol.scope.entries.entrySet()) {
            Scope.ScopeEntry scopeEntry = entry.getValue();
            if (!(scopeEntry.symbol instanceof BEnumSymbol) || !Symbols.isFlagOn(scopeEntry.symbol.flags, 1L)) continue;
            String constName = scopeEntry.symbol.getOriginalName().getValue();
            enums.add(symbolFactory.createEnumSymbol((BEnumSymbol)scopeEntry.symbol, constName));
        }
        this.enums = Collections.unmodifiableList(enums);
        return this.enums;
    }

    @Override
    public List<Symbol> allSymbols() {
        if (this.allSymbols == null) {
            SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
            ArrayList<Symbol> symbols = new ArrayList<Symbol>();
            for (Map.Entry<Name, Scope.ScopeEntry> entry : this.packageSymbol.scope.entries.entrySet()) {
                Scope.ScopeEntry scopeEntry = entry.getValue();
                if (!Symbols.isFlagOn(scopeEntry.symbol.flags, 1L) || scopeEntry.symbol.origin != SymbolOrigin.COMPILED_SOURCE && scopeEntry.symbol.origin != SymbolOrigin.SOURCE && scopeEntry.symbol.origin != SymbolOrigin.BUILTIN) continue;
                symbols.add(symbolFactory.getBCompiledSymbol(scopeEntry.symbol, scopeEntry.symbol.getOriginalName().getValue()));
            }
            this.allSymbols = Collections.unmodifiableList(symbols);
        }
        return this.allSymbols;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModuleSymbol)) {
            return false;
        }
        ModuleSymbol symbol = (ModuleSymbol)obj;
        return this.id().equals(symbol.id());
    }

    @Override
    public int hashCode() {
        return this.id().hashCode();
    }

    public static class ModuleSymbolBuilder
    extends BallerinaSymbol.SymbolBuilder<ModuleSymbolBuilder> {
        public ModuleSymbolBuilder(CompilerContext context, String name, BPackageSymbol packageSymbol) {
            super(name, SymbolKind.MODULE, packageSymbol, context);
            this.context = context;
        }

        @Override
        public BallerinaModule build() {
            if (this.bSymbol == null) {
                throw new AssertionError((Object)"Package Symbol cannot be null");
            }
            return new BallerinaModule(this.context, this.name, (BPackageSymbol)this.bSymbol);
        }
    }
}

