/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.symbols.AbstractStructuredTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaRecordFieldSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.impl.util.FieldMap;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaRecordTypeSymbol
extends AbstractStructuredTypeSymbol
implements RecordTypeSymbol {
    private Map<String, RecordFieldSymbol> fieldSymbols;
    private TypeSymbol restTypeDesc;
    private List<TypeSymbol> typeInclusions;

    public BallerinaRecordTypeSymbol(CompilerContext context, BRecordType recordType) {
        super(context, TypeDescKind.RECORD, recordType);
    }

    @Override
    public Map<String, RecordFieldSymbol> fieldDescriptors() {
        if (this.fieldSymbols != null) {
            return this.fieldSymbols;
        }
        FieldMap<String, BallerinaRecordFieldSymbol> fields = new FieldMap<String, BallerinaRecordFieldSymbol>();
        BRecordType type = (BRecordType)this.getBType();
        for (BField field : type.fields.values()) {
            fields.put(field.symbol.getOriginalName().value, new BallerinaRecordFieldSymbol(this.context, field));
        }
        this.fieldSymbols = Collections.unmodifiableMap(fields);
        return this.fieldSymbols;
    }

    @Override
    public Optional<TypeSymbol> restTypeDescriptor() {
        if (this.restTypeDesc == null) {
            BType restFieldType = ((BRecordType)this.getBType()).restFieldType;
            if (restFieldType.tag != 24) {
                TypesFactory typesFactory = TypesFactory.getInstance(this.context);
                this.restTypeDesc = typesFactory.getTypeDescriptor(restFieldType);
            }
        }
        return Optional.ofNullable(this.restTypeDesc);
    }

    @Override
    public List<TypeSymbol> typeInclusions() {
        if (this.typeInclusions == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            List inclusions = ((BRecordType)this.getBType()).typeInclusions;
            ArrayList<TypeSymbol> typeRefs = new ArrayList<TypeSymbol>();
            for (BType inclusion : inclusions) {
                TypeSymbol type = typesFactory.getTypeDescriptor(inclusion);
                if (type == null) continue;
                typeRefs.add(type);
            }
            this.typeInclusions = Collections.unmodifiableList(typeRefs);
        }
        return this.typeInclusions;
    }

    @Override
    public String signature() {
        StringJoiner joiner = new StringJoiner(" ", "{|", "|}");
        for (RecordFieldSymbol fieldSymbol : this.fieldDescriptors().values()) {
            String ballerinaFieldSignature = fieldSymbol.signature() + ";";
            joiner.add(ballerinaFieldSignature);
        }
        this.restTypeDescriptor().ifPresent(typeDescriptor -> joiner.add(typeDescriptor.signature() + "...;"));
        return "record " + joiner.toString();
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

