/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.StreamTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaStreamTypeSymbol
extends AbstractTypeSymbol
implements StreamTypeSymbol {
    private TypeSymbol typeParameter;
    private TypeSymbol completionValueTypeParameter;
    private String signature;

    public BallerinaStreamTypeSymbol(CompilerContext context, BStreamType streamType) {
        super(context, TypeDescKind.STREAM, streamType);
    }

    @Override
    public TypeSymbol typeParameter() {
        if (this.typeParameter == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            this.typeParameter = typesFactory.getTypeDescriptor(((BStreamType)this.getBType()).constraint);
        }
        return this.typeParameter;
    }

    @Override
    public TypeSymbol completionValueTypeParameter() {
        if (this.completionValueTypeParameter == null) {
            BType completionType = ((BStreamType)this.getBType()).completionType;
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            this.completionValueTypeParameter = typesFactory.getTypeDescriptor(completionType);
        }
        return this.completionValueTypeParameter;
    }

    @Override
    public String signature() {
        if (this.signature == null) {
            StringBuilder sigBuilder = new StringBuilder("stream<");
            sigBuilder.append(this.typeParameter().signature());
            if (this.completionValueTypeParameter().typeKind() != TypeDescKind.NIL) {
                sigBuilder.append(", ").append(this.completionValueTypeParameter().signature());
            }
            sigBuilder.append('>');
            this.signature = sigBuilder.toString();
        }
        return this.signature;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

