/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.BallerinaDocumentation;
import io.ballerina.compiler.api.impl.util.SymbolUtils;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextRange;
import java.util.Objects;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaSymbol
implements Symbol {
    protected final CompilerContext context;
    private final String name;
    private final SymbolKind symbolKind;
    private final Location position;
    private final BSymbol internalSymbol;
    private ModuleSymbol module;
    private boolean moduleEvaluated;

    protected BallerinaSymbol(String name, SymbolKind symbolKind, BSymbol symbol, CompilerContext context) {
        this.name = name;
        this.symbolKind = symbolKind;
        this.context = context;
        if (symbol == null) {
            throw new IllegalArgumentException("'symbol' cannot be null");
        }
        this.internalSymbol = symbol;
        LineRange lineRange = symbol.pos.lineRange();
        TextRange textRange = symbol.pos.textRange();
        this.position = new BLangDiagnosticLocation(lineRange.fileName(), lineRange.startLine().line(), lineRange.endLine().line(), lineRange.startLine().offset(), lineRange.endLine().offset(), textRange.startOffset(), textRange.length());
    }

    @Override
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    public Optional<ModuleSymbol> getModule() {
        if (this.module != null || this.moduleEvaluated) {
            return Optional.ofNullable(this.module);
        }
        this.moduleEvaluated = true;
        BSymbol symbol = this.internalSymbol.owner;
        while (symbol != null && !(symbol instanceof BPackageSymbol)) {
            symbol = symbol.owner;
        }
        if (symbol == null) {
            return Optional.empty();
        }
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        this.module = symbolFactory.createModuleSymbol((BPackageSymbol)symbol, symbol.name.value);
        return Optional.of(this.module);
    }

    @Override
    public SymbolKind kind() {
        return this.symbolKind;
    }

    @Override
    public Location location() {
        return this.position;
    }

    @Override
    public Optional<Location> getLocation() {
        return Optional.ofNullable(this.position);
    }

    @Override
    public boolean nameEquals(String name) {
        Optional<String> symbolName = this.getName();
        if (symbolName.isEmpty() || name == null) {
            return false;
        }
        String symName = symbolName.get();
        if (name.equals(symName)) {
            return true;
        }
        return SymbolUtils.unescapeUnicode(name).equals(SymbolUtils.unescapeUnicode(symName));
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Symbol)) {
            return false;
        }
        Symbol symbol = (Symbol)obj;
        return this.nameEquals(symbol.getName().orElse(null)) && this.isSameModule(this.getModule(), symbol.getModule()) && this.isSameLocation(this.getLocation(), symbol.getLocation()) && this.kind().equals((Object)symbol.kind());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName().orElse(null), this.getModule().orElse(null), this.kind(), this.getLocation().isPresent() ? this.getLocation().get().lineRange() : null});
    }

    public BSymbol getInternalSymbol() {
        return this.internalSymbol;
    }

    Documentation getDocAttachment(BSymbol symbol) {
        return symbol == null ? null : new BallerinaDocumentation(symbol.markdownDocumentation);
    }

    protected boolean isSameModule(Optional<ModuleSymbol> mod1, Optional<ModuleSymbol> mod2) {
        if (mod1.isEmpty() || mod2.isEmpty()) {
            return false;
        }
        return mod1.get().id().equals(mod2.get().id());
    }

    protected boolean isSameLocation(Optional<Location> loc1, Optional<Location> loc2) {
        if (loc1.isEmpty() || loc2.isEmpty()) {
            return false;
        }
        return loc1.get().lineRange().equals((Object)loc2.get().lineRange());
    }

    protected static abstract class SymbolBuilder<T extends SymbolBuilder<T>> {
        protected String name;
        protected SymbolKind ballerinaSymbolKind;
        protected BSymbol bSymbol;
        protected CompilerContext context;

        public SymbolBuilder(String name, SymbolKind symbolKind, BSymbol bSymbol, CompilerContext context) {
            this.name = name;
            this.ballerinaSymbolKind = symbolKind;
            this.bSymbol = bSymbol;
            this.context = context;
        }

        public abstract BallerinaSymbol build();
    }
}

