/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.AbstractStructuredTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.MemberTypeSymbol;
import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaTupleTypeSymbol
extends AbstractStructuredTypeSymbol
implements TupleTypeSymbol {
    private List<TypeSymbol> memberTypes;
    private List<MemberTypeSymbol> tupleMembers;
    private TypeSymbol restTypeDesc;

    public BallerinaTupleTypeSymbol(CompilerContext context, BTupleType tupleType) {
        super(context, TypeDescKind.TUPLE, tupleType);
    }

    @Override
    public List<TypeSymbol> memberTypeDescriptors() {
        if (this.memberTypes == null) {
            ArrayList<TypeSymbol> types = new ArrayList<TypeSymbol>();
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            for (BType tupleMemberType : ((BTupleType)this.getBType()).getTupleTypes()) {
                types.add(typesFactory.getTypeDescriptor(tupleMemberType));
            }
            this.memberTypes = Collections.unmodifiableList(types);
        }
        return this.memberTypes;
    }

    @Override
    public List<MemberTypeSymbol> members() {
        if (this.tupleMembers != null) {
            return this.tupleMembers;
        }
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        this.tupleMembers = new ArrayList<MemberTypeSymbol>();
        for (BTupleMember tupMember : ((BTupleType)this.getBType()).getMembers()) {
            this.tupleMembers.add(symbolFactory.createTupleMember(tupMember.symbol));
        }
        return this.tupleMembers;
    }

    @Override
    public Optional<TypeSymbol> restTypeDescriptor() {
        if (this.restTypeDesc == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            this.restTypeDesc = typesFactory.getTypeDescriptor(((BTupleType)this.getBType()).restType);
        }
        return Optional.ofNullable(this.restTypeDesc);
    }

    @Override
    public String signature() {
        BTupleType tupleType = (BTupleType)this.getBType();
        if (tupleType.isCyclic && tupleType.tsymbol != null && !tupleType.tsymbol.getName().getValue().isEmpty()) {
            return tupleType.tsymbol.getName().getValue();
        }
        if (tupleType.resolvingToString) {
            return "...";
        }
        StringJoiner joiner = new StringJoiner(", ");
        tupleType.resolvingToString = true;
        for (TypeSymbol typeDescriptorImpl : this.memberTypeDescriptors()) {
            String typeDescriptorSignature = typeDescriptorImpl.signature();
            joiner.add(typeDescriptorSignature);
        }
        tupleType.resolvingToString = false;
        if (this.restTypeDescriptor().isPresent()) {
            joiner.add(this.restTypeDescriptor().get().signature() + "...");
        }
        return "[" + joiner.toString() + "]";
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

