/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaTypeDefinitionSymbol
extends BallerinaSymbol
implements TypeDefinitionSymbol {
    private final List<Qualifier> qualifiers;
    private final TypeSymbol typeDescriptor;
    private final Documentation docAttachment;
    private final boolean deprecated;
    private final boolean readonly;
    private final List<AnnotationSymbol> annots;
    private final List<AnnotationAttachmentSymbol> annotAttachments;

    protected BallerinaTypeDefinitionSymbol(String name, List<Qualifier> qualifiers, List<AnnotationSymbol> annots, List<AnnotationAttachmentSymbol> annotAttachments, TypeSymbol typeDescriptor, BSymbol bSymbol, CompilerContext context) {
        super(name, SymbolKind.TYPE_DEFINITION, bSymbol, context);
        this.qualifiers = Collections.unmodifiableList(qualifiers);
        this.typeDescriptor = typeDescriptor;
        this.docAttachment = this.getDocAttachment(bSymbol);
        this.deprecated = Symbols.isFlagOn(bSymbol.flags, 16L);
        this.readonly = Symbols.isFlagOn(bSymbol.flags, 32L);
        this.annots = Collections.unmodifiableList(annots);
        this.annotAttachments = Collections.unmodifiableList(annotAttachments);
    }

    @Override
    public String moduleQualifiedName() {
        return this.getModule().get().id().modulePrefix() + ":" + this.getName().get();
    }

    @Override
    public List<Qualifier> qualifiers() {
        return this.qualifiers;
    }

    @Override
    public TypeSymbol typeDescriptor() {
        return this.typeDescriptor;
    }

    @Override
    public boolean deprecated() {
        return this.deprecated;
    }

    @Override
    public boolean readonly() {
        return this.readonly;
    }

    @Override
    public List<AnnotationSymbol> annotations() {
        return this.annots;
    }

    @Override
    public List<AnnotationAttachmentSymbol> annotAttachments() {
        return this.annotAttachments;
    }

    @Override
    public Optional<Documentation> documentation() {
        return Optional.ofNullable(this.docAttachment);
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }

    public static class TypeDefSymbolBuilder
    extends BallerinaSymbol.SymbolBuilder<TypeDefSymbolBuilder> {
        protected List<Qualifier> qualifiers = new ArrayList<Qualifier>();
        protected List<AnnotationSymbol> annots = new ArrayList<AnnotationSymbol>();
        protected List<AnnotationAttachmentSymbol> annotAttachments = new ArrayList<AnnotationAttachmentSymbol>();
        protected TypeSymbol typeDescriptor;

        public TypeDefSymbolBuilder(String name, BSymbol symbol, CompilerContext context) {
            super(name, SymbolKind.TYPE_DEFINITION, symbol, context);
        }

        public TypeDefSymbolBuilder withTypeDescriptor(TypeSymbol typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public TypeDefSymbolBuilder withQualifier(Qualifier qualifier) {
            this.qualifiers.add(qualifier);
            return this;
        }

        public TypeDefSymbolBuilder withAnnotation(AnnotationSymbol annot) {
            this.annots.add(annot);
            return this;
        }

        public TypeDefSymbolBuilder withAnnotationAttachment(AnnotationAttachmentSymbol annotAttachment) {
            this.annotAttachments.add(annotAttachment);
            return this;
        }

        @Override
        public BallerinaTypeDefinitionSymbol build() {
            return new BallerinaTypeDefinitionSymbol(this.name, this.qualifiers, this.annots, this.annotAttachments, this.typeDescriptor, this.bSymbol, this.context);
        }
    }
}

