/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class BallerinaTypeReferenceTypeSymbol
extends AbstractTypeSymbol
implements TypeReferenceTypeSymbol {
    private static final String ANON_ORG = "$anon";
    private final String definitionName;
    private TypeSymbol typeDescriptorImpl;
    private Location location;
    private String signature;
    private ModuleSymbol module;
    private Symbol definition;
    private boolean moduleEvaluated;
    private final boolean fromIntersectionType;
    public BSymbol tSymbol;
    public BType referredType;

    public BallerinaTypeReferenceTypeSymbol(CompilerContext context, BType bType, BSymbol tSymbol, boolean fromIntersectionType) {
        super(context, TypeDescKind.TYPE_REFERENCE, bType);
        this.referredType = this.getReferredType(bType);
        this.definitionName = tSymbol.getOriginalName().getValue();
        this.tSymbol = tSymbol;
        this.fromIntersectionType = fromIntersectionType;
        this.location = tSymbol.pos;
    }

    @Override
    public TypeSymbol typeDescriptor() {
        if (this.typeDescriptorImpl == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            this.typeDescriptorImpl = typesFactory.getTypeDescriptor(this.referredType, this.referredType.tsymbol, true, !this.fromIntersectionType, false);
        }
        return this.typeDescriptorImpl;
    }

    @Override
    public List<FunctionSymbol> langLibMethods() {
        return this.typeDescriptor().langLibMethods();
    }

    @Override
    public String name() {
        return this.definitionName;
    }

    @Override
    public Symbol definition() {
        if (this.definition != null) {
            return this.definition;
        }
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        BType bType = this.getBType();
        BType referredType = this.getReferredType(bType);
        if (referredType.tag == 52 || bType.tag == 52) {
            this.definition = symbolFactory.getBCompiledSymbol(((BParameterizedType)this.tSymbol.type).paramSymbol, this.name());
        } else if (referredType.tag == 22 || referredType.tsymbol.origin == SymbolOrigin.VIRTUAL) {
            this.definition = symbolFactory.getBCompiledSymbol(bType.tsymbol, referredType.tsymbol.getName().getValue());
        } else {
            Name name = Names.fromString(this.name());
            Scope.ScopeEntry scopeEntry = this.tSymbol.owner.scope.lookup(name);
            if (scopeEntry.symbol == null) {
                scopeEntry = this.tSymbol.owner.scope.lookup(this.tSymbol.getName());
            }
            this.definition = symbolFactory.getBCompiledSymbol(scopeEntry.symbol, this.name());
        }
        return this.definition;
    }

    @Override
    public Optional<String> getName() {
        return Optional.of(this.definitionName);
    }

    @Override
    public Optional<ModuleSymbol> getModule() {
        if (this.module != null || this.moduleEvaluated) {
            return Optional.ofNullable(this.module);
        }
        this.moduleEvaluated = true;
        Symbol definition = this.definition();
        if (definition.getModule().isEmpty()) {
            return Optional.empty();
        }
        this.module = definition.getModule().get();
        return Optional.of(this.module);
    }

    @Override
    public Location location() {
        if (this.location == null) {
            BType type = this.getBType();
            if (type.tsymbol != null) {
                this.location = type.tsymbol.pos;
            }
        }
        return this.location;
    }

    @Override
    public Optional<Location> getLocation() {
        return Optional.of(this.location);
    }

    @Override
    public String signature() {
        if (this.signature != null) {
            return this.signature;
        }
        ModuleID moduleID = this.getModule().get().id();
        this.signature = moduleID == null || moduleID.moduleName().equals("lang.annotations") && moduleID.orgName().equals("ballerina") || this.getBType().tag == 52 ? this.definitionName : (moduleID.moduleName().equals("lang.xml") && moduleID.orgName().equals("ballerina") ? "xml:" + this.definitionName : (!this.isAnonOrg(moduleID) ? moduleID.orgName() + String.valueOf(Names.ORG_NAME_SEPARATOR) + moduleID.moduleName() + String.valueOf(Names.VERSION_SEPARATOR) + moduleID.version() + ":" + this.definitionName : this.definitionName));
        return this.signature;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }

    private boolean isAnonOrg(ModuleID moduleID) {
        return ANON_ORG.equals(moduleID.orgName());
    }

    private BType getReferredType(BType type) {
        if (type == null) {
            return null;
        }
        if (type.tag == 14) {
            return ((BTypeReferenceType)type).referredType;
        }
        if (type.tag == 52) {
            return ((BParameterizedType)type).paramValueType;
        }
        return type;
    }
}

