/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaSingletonTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.Core;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.BooleanSubtype;
import io.ballerina.types.subtypedata.DecimalSubtype;
import io.ballerina.types.subtypedata.FloatSubtype;
import io.ballerina.types.subtypedata.IntSubtype;
import io.ballerina.types.subtypedata.StringSubtype;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.SemNamedType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class BallerinaUnionTypeSymbol
extends AbstractTypeSymbol
implements UnionTypeSymbol {
    private static final String CLONEABLE = "Cloneable";
    private static final String CLONEABLE_TYPE = "CloneableType";
    private static final Pattern pCloneableType = Pattern.compile("CloneableType");
    private List<TypeSymbol> memberTypes;
    private List<TypeSymbol> originalMemberTypes;
    private String signature;
    private SymbolTable symTable;

    public BallerinaUnionTypeSymbol(CompilerContext context, BUnionType unionType) {
        super(context, TypeDescKind.UNION, unionType);
        this.symTable = SymbolTable.getInstance(context);
    }

    public BallerinaUnionTypeSymbol(CompilerContext context, BFiniteType finiteType) {
        super(context, TypeDescKind.UNION, finiteType);
        this.symTable = SymbolTable.getInstance(context);
    }

    @Override
    public List<TypeSymbol> memberTypeDescriptors() {
        if (this.memberTypes == null) {
            ArrayList<TypeSymbol> members = new ArrayList<TypeSymbol>();
            if (this.getBType().tag == 21) {
                TypesFactory typesFactory = TypesFactory.getInstance(this.context);
                for (BType memberType : ((BUnionType)this.getBType()).getMemberTypes()) {
                    if (memberType.tag == 14 || memberType.getKind() != TypeKind.FINITE) {
                        members.add(typesFactory.getTypeDescriptor(memberType));
                        continue;
                    }
                    this.updateMembersForBFiniteType(members, (BFiniteType)memberType);
                }
            } else {
                this.updateMembersForBFiniteType(members, (BFiniteType)this.getBType());
            }
            this.memberTypes = Collections.unmodifiableList(members);
        }
        return this.memberTypes;
    }

    private void updateMembersForBFiniteType(List<TypeSymbol> members, BFiniteType bFiniteType) {
        for (SemNamedType semNamedType : bFiniteType.valueSpace) {
            String value;
            BType broadType;
            SemType s = semNamedType.semType();
            BFiniteType ft = BFiniteType.newSingletonBFiniteType(null, s);
            if (PredefinedType.NIL.equals((Object)s)) {
                members.add(new BallerinaSingletonTypeSymbol(this.context, this.symTable.nilType, Names.NIL_VALUE.value, ft));
                continue;
            }
            ComplexSemType cs = (ComplexSemType)s;
            if (SemTypes.isSubtypeSimple((SemType)s, (BasicTypeBitSet)PredefinedType.BOOLEAN)) {
                broadType = this.symTable.booleanType;
                boolean boolVal = (Boolean)BooleanSubtype.booleanSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)cs, (BasicTypeCode)BasicTypeCode.BT_BOOLEAN)).get();
                value = boolVal ? Names.TRUE.value : Names.FALSE.value;
            } else if (SemTypes.isSubtypeSimple((SemType)s, (BasicTypeBitSet)PredefinedType.INT)) {
                broadType = this.symTable.intType;
                long longVal = (Long)IntSubtype.intSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)cs, (BasicTypeCode)BasicTypeCode.BT_INT)).get();
                value = Long.toString(longVal);
            } else if (SemTypes.isSubtypeSimple((SemType)s, (BasicTypeBitSet)PredefinedType.FLOAT)) {
                broadType = this.symTable.floatType;
                double doubleVal = (Double)FloatSubtype.floatSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)cs, (BasicTypeCode)BasicTypeCode.BT_FLOAT)).get();
                value = Double.toString(doubleVal);
            } else if (SemTypes.isSubtypeSimple((SemType)s, (BasicTypeBitSet)PredefinedType.DECIMAL)) {
                broadType = this.symTable.decimalType;
                BigDecimal bVal = (BigDecimal)DecimalSubtype.decimalSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)cs, (BasicTypeCode)BasicTypeCode.BT_DECIMAL)).get();
                value = bVal.toPlainString();
            } else if (SemTypes.isSubtypeSimple((SemType)s, (BasicTypeBitSet)PredefinedType.STRING)) {
                broadType = this.symTable.stringType;
                value = (String)StringSubtype.stringSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)cs, (BasicTypeCode)BasicTypeCode.BT_STRING)).get();
            } else {
                throw new IllegalStateException("Unexpected value space type: " + String.valueOf(s));
            }
            members.add(new BallerinaSingletonTypeSymbol(this.context, broadType, value, ft));
        }
    }

    @Override
    public List<TypeSymbol> userSpecifiedMemberTypes() {
        if (this.originalMemberTypes == null) {
            ArrayList<TypeSymbol> members = new ArrayList<TypeSymbol>();
            if (this.getBType().tag == 21) {
                TypesFactory typesFactory = TypesFactory.getInstance(this.context);
                for (BType memberType : ((BUnionType)this.getBType()).getOriginalMemberTypes()) {
                    members.add(typesFactory.getTypeDescriptor(memberType));
                }
            } else {
                this.updateMembersForBFiniteType(members, (BFiniteType)this.getBType());
            }
            this.originalMemberTypes = Collections.unmodifiableList(members);
        }
        return this.originalMemberTypes;
    }

    @Override
    public String signature() {
        if (this.signature != null) {
            return this.signature;
        }
        BType type = this.getBType();
        if (type.tag == 21) {
            this.signature = this.getSignatureForUnion(type);
        } else if (type.tag == 33) {
            this.signature = this.getSignatureForFiniteType();
        } else {
            throw new IllegalStateException("Invalid type kind: " + type.getClass().getName());
        }
        return this.signature;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }

    private String getSignatureForUnion(BType type) {
        BUnionType unionType = (BUnionType)type;
        if (unionType.isCyclic && unionType.tsymbol != null && !unionType.tsymbol.getName().getValue().isEmpty()) {
            String typeStr = unionType.tsymbol.getName().getValue();
            if (Symbols.isFlagOn(unionType.getFlags(), 0x200000L) && pCloneableType.matcher(typeStr).matches()) {
                typeStr = CLONEABLE;
            }
            return typeStr;
        }
        if (unionType.resolvingToString) {
            return "...";
        }
        List<TypeSymbol> memberTypes = this.userSpecifiedMemberTypes();
        if (this.containsTwoElements(memberTypes) && this.containsNil(memberTypes)) {
            TypeSymbol member1 = memberTypes.get(0);
            return member1.typeKind() == TypeDescKind.NIL ? this.getSignatureForIntersectionType(memberTypes.get(1)) + "?" : this.getSignatureForIntersectionType(member1) + "?";
        }
        StringJoiner joiner = new StringJoiner("|");
        unionType.resolvingToString = true;
        for (TypeSymbol typeDescriptor : memberTypes) {
            if (typeDescriptor.typeKind() == TypeDescKind.FUNCTION && !memberTypes.get(memberTypes.size() - 1).equals(typeDescriptor)) {
                joiner.add("(" + typeDescriptor.signature() + ")");
                continue;
            }
            joiner.add(this.getSignatureForIntersectionType(typeDescriptor));
        }
        unionType.resolvingToString = false;
        return joiner.toString();
    }

    private String getSignatureForFiniteType() {
        List<TypeSymbol> memberTypes = this.userSpecifiedMemberTypes();
        StringJoiner joiner = new StringJoiner("|");
        for (TypeSymbol typeDescriptor : memberTypes) {
            joiner.add(typeDescriptor.signature());
        }
        return joiner.toString();
    }

    private String getSignatureForIntersectionType(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() != TypeDescKind.INTERSECTION) {
            return typeSymbol.signature();
        }
        return "(" + typeSymbol.signature() + ")";
    }

    private boolean containsNil(List<TypeSymbol> types) {
        for (TypeSymbol type : types) {
            if (type.typeKind() != TypeDescKind.NIL) continue;
            return true;
        }
        return false;
    }

    private boolean containsTwoElements(List<TypeSymbol> types) {
        if (types.size() == 2) {
            for (TypeSymbol type : types) {
                BType internalType = ((AbstractTypeSymbol)type).getBType();
                if (internalType.tag != 33 || !Core.singleShape((SemType)internalType.semType()).isEmpty()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Optional<Location> getLocation() {
        return Optional.of(this.getBType().tsymbol.pos);
    }
}

