/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.XMLTypeSymbol;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaXMLTypeSymbol
extends AbstractTypeSymbol
implements XMLTypeSymbol {
    private TypeSymbol typeParameter;
    private String typeName;
    private String signature;

    public BallerinaXMLTypeSymbol(CompilerContext context, BXMLType xmlType) {
        super(context, TypeDescKind.XML, xmlType);
    }

    @Override
    public Optional<TypeSymbol> typeParameter() {
        if (this.typeParameter == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            BType constraintType = ((BXMLType)this.getBType()).constraint;
            if (constraintType != null) {
                this.typeParameter = typesFactory.getTypeDescriptor(constraintType, constraintType.tsymbol, true);
            }
        }
        return Optional.ofNullable(this.typeParameter);
    }

    @Override
    public Optional<String> getName() {
        if (this.typeName == null) {
            BXMLType xmlType = (BXMLType)this.getBType();
            SymbolTable symbolTable = SymbolTable.getInstance(this.context);
            this.typeName = xmlType == symbolTable.xmlType || this.typeParameter().isEmpty() ? "xml" : "xml<" + this.typeParameter().get().getName().orElse("") + ">";
        }
        return Optional.of(this.typeName);
    }

    @Override
    public String signature() {
        if (this.signature == null) {
            BXMLType xmlType = (BXMLType)this.getBType();
            SymbolTable symbolTable = SymbolTable.getInstance(this.context);
            this.signature = xmlType == symbolTable.xmlType || this.typeParameter().isEmpty() ? "xml" : "xml<" + this.typeParameter().get().signature() + ">";
        }
        return this.signature;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

