/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.type.builders;

import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.ErrorTypeSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class BallerinaErrorTypeBuilder
implements TypeBuilder.ERROR {
    private final TypesFactory typesFactory;
    private final SymbolTable symTable;
    private TypeSymbol typeParam;

    public BallerinaErrorTypeBuilder(CompilerContext context) {
        this.typesFactory = TypesFactory.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
    }

    @Override
    public TypeBuilder.ERROR withTypeParam(TypeSymbol typeParam) {
        this.typeParam = typeParam;
        return this;
    }

    @Override
    public ErrorTypeSymbol build() {
        BErrorTypeSymbol errorTSymbol = new BErrorTypeSymbol(294940L, 1L, Names.ERROR, this.symTable.rootPkgSymbol.pkgID, this.symTable.errorType, this.symTable.rootPkgSymbol, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
        BErrorType errorType = new BErrorType(this.symTable.typeEnv(), (BTypeSymbol)errorTSymbol, this.getBType(this.typeParam));
        errorTSymbol.type = errorType;
        ErrorTypeSymbol errorTypeSymbol = (ErrorTypeSymbol)this.typesFactory.getTypeDescriptor(errorType);
        this.typeParam = null;
        return errorTypeSymbol;
    }

    private BType getBType(TypeSymbol typeSymbol) {
        if (typeSymbol == null) {
            return this.symTable.errorType.detailType;
        }
        if (this.isValidTypeParam(typeSymbol)) {
            return ((AbstractTypeSymbol)typeSymbol).getBType();
        }
        throw new IllegalArgumentException("Valid error detail mapping should be provided");
    }

    private boolean isValidTypeParam(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() == TypeDescKind.RECORD) {
            RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)typeSymbol;
            boolean hasString = false;
            boolean hasError = false;
            for (RecordFieldSymbol recordFieldSymbol : recordTypeSymbol.fieldDescriptors().values()) {
                if (recordFieldSymbol.typeDescriptor().typeKind() == TypeDescKind.STRING && (recordFieldSymbol.isOptional() || recordFieldSymbol.hasDefaultValue())) {
                    hasString = true;
                }
                if (recordFieldSymbol.typeDescriptor().typeKind() == TypeDescKind.ERROR && recordFieldSymbol.isOptional()) {
                    hasError = true;
                }
                if (!hasString || !hasError) continue;
                return true;
            }
        }
        return false;
    }
}

