/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.type.builders;

import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.ballerinalang.model.elements.Flag;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.Flags;

public class BallerinaRecordTypeBuilder
implements TypeBuilder.RECORD {
    private final TypesFactory typesFactory;
    private final SymbolTable symTable;
    private TypeSymbol restField;
    private final List<TypeBuilder.RECORD.RECORD_FIELD> recordFieldList = new ArrayList<TypeBuilder.RECORD.RECORD_FIELD>();
    private final List<TypeReferenceTypeSymbol> typeInclusions = new ArrayList<TypeReferenceTypeSymbol>();

    public BallerinaRecordTypeBuilder(CompilerContext context) {
        this.typesFactory = TypesFactory.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
    }

    @Override
    public TypeBuilder.RECORD.RECORD_FIELD fields() {
        return new RecordFieldDataHolder();
    }

    @Override
    public TypeBuilder.RECORD withFields(TypeBuilder.RECORD.RECORD_FIELD ... fields) {
        this.recordFieldList.clear();
        this.recordFieldList.addAll(Arrays.asList(fields));
        return this;
    }

    @Override
    public TypeBuilder.RECORD withRestField(TypeSymbol restType) {
        this.restField = restType;
        return this;
    }

    @Override
    public TypeBuilder.RECORD withTypeInclusions(TypeReferenceTypeSymbol ... typeInclusions) {
        this.typeInclusions.clear();
        this.typeInclusions.addAll(Arrays.asList(typeInclusions));
        return this;
    }

    @Override
    public RecordTypeSymbol build() {
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(1L, Names.EMPTY, this.symTable.rootPkgSymbol.pkgID, null, this.symTable.rootPkgSymbol, this.symTable.builtinPos, this.symTable.rootPkgSymbol.origin);
        BRecordType recordType = new BRecordType(this.symTable.typeEnv(), (BTypeSymbol)recordSymbol);
        recordSymbol.type = recordType;
        recordType.typeInclusions = this.getTypeInclusions(this.typeInclusions);
        recordType.restFieldType = this.restField == null ? this.symTable.noType : this.getBType(this.restField);
        recordType.fields = this.getFields(this.recordFieldList, recordSymbol);
        RecordTypeSymbol recordFieldSymbol = (RecordTypeSymbol)this.typesFactory.getTypeDescriptor(recordType);
        this.typeInclusions.clear();
        this.restField = null;
        this.recordFieldList.clear();
        return recordFieldSymbol;
    }

    private LinkedHashMap<String, BField> getFields(List<TypeBuilder.RECORD.RECORD_FIELD> recordFieldList, BRecordTypeSymbol ownerRecordSymbol) {
        LinkedHashMap<String, BField> fieldList = new LinkedHashMap<String, BField>();
        for (TypeBuilder.RECORD.RECORD_FIELD recordField : recordFieldList) {
            BField bField = this.getBField(recordField, ownerRecordSymbol);
            fieldList.put(bField.getName().getValue(), bField);
        }
        return fieldList;
    }

    private BField getBField(TypeBuilder.RECORD.RECORD_FIELD recordField, BRecordTypeSymbol ownerRecordSymbol) {
        EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
        if (recordField.isFieldOptional()) {
            flags.add(Flag.OPTIONAL);
        }
        if (recordField.isFieldReadOnly()) {
            flags.add(Flag.READONLY);
        }
        if (recordField.hasFieldDefaultExpr()) {
            flags.remove((Object)Flag.OPTIONAL);
            flags.add(Flag.REQUIRED);
        }
        BVarSymbol fieldSymbol = new BVarSymbol(Flags.asMask(flags), Names.fromString(recordField.getName()), ownerRecordSymbol.pkgID, this.getBType(recordField.getType()), ownerRecordSymbol, this.symTable.builtinPos, ownerRecordSymbol.origin);
        return new BField(Names.fromString(recordField.getName()), this.symTable.builtinPos, fieldSymbol);
    }

    private List<BType> getTypeInclusions(List<TypeReferenceTypeSymbol> typeInclusions) {
        ArrayList<BType> typeInclusionList = new ArrayList<BType>();
        for (TypeReferenceTypeSymbol typeInclusion : typeInclusions) {
            typeInclusionList.add(this.getBType(typeInclusion));
        }
        return typeInclusionList;
    }

    private BType getBType(TypeSymbol typeSymbol) {
        if (typeSymbol != null) {
            if (typeSymbol instanceof AbstractTypeSymbol) {
                AbstractTypeSymbol abstractTypeSymbol = (AbstractTypeSymbol)typeSymbol;
                return abstractTypeSymbol.getBType();
            }
            throw new IllegalArgumentException("Invalid type provided");
        }
        return null;
    }

    public static class RecordFieldDataHolder
    implements TypeBuilder.RECORD.RECORD_FIELD {
        private TypeSymbol typeSymbol;
        private String name;
        private boolean readOnly = false;
        private boolean isOptional = false;
        private boolean hasDefaultValue = false;

        @Override
        public TypeBuilder.RECORD.RECORD_FIELD isReadOnly() {
            this.readOnly = true;
            return this;
        }

        @Override
        public TypeBuilder.RECORD.RECORD_FIELD withType(TypeSymbol type) {
            this.typeSymbol = type;
            return this;
        }

        @Override
        public TypeBuilder.RECORD.RECORD_FIELD withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public TypeBuilder.RECORD.RECORD_FIELD isOptional() {
            this.isOptional = true;
            return this;
        }

        @Override
        public TypeBuilder.RECORD.RECORD_FIELD hasDefaultExpr() {
            this.hasDefaultValue = true;
            return this;
        }

        @Override
        public boolean isFieldReadOnly() {
            return this.readOnly;
        }

        @Override
        public TypeSymbol getType() {
            return this.typeSymbol;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isFieldOptional() {
            return this.isOptional;
        }

        @Override
        public boolean hasFieldDefaultExpr() {
            return this.hasDefaultValue;
        }

        @Override
        public TypeBuilder.RECORD.RECORD_FIELD get() {
            if (this.name == null) {
                throw new IllegalArgumentException("Field name can not be null");
            }
            return this;
        }
    }
}

